/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.datastructure.tv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.queryengine.transformation.datastructure.Cache;
import org.apache.iotdb.db.queryengine.transformation.datastructure.iterator.TVListForwardIterator;
import org.apache.iotdb.db.queryengine.transformation.datastructure.tv.ElasticSerializableBinaryTVList;
import org.apache.iotdb.db.queryengine.transformation.datastructure.tv.SerializableTVList;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;

public class ElasticSerializableTVList {
    protected TSDataType dataType;
    protected String queryId;
    protected float memoryLimitInMB;
    protected int internalTVListCapacity;
    protected int cacheSize;
    protected LRUCache cache;
    protected List<SerializableTVList> internalTVList;
    protected List<Integer> internalColumnCountList;
    protected int pointCount;
    protected int evictionUpperBound;
    protected List<TVListForwardIterator> iteratorList;

    public static ElasticSerializableTVList construct(TSDataType dataType, String queryId, float memoryLimitInMB, int cacheSize) {
        return dataType.equals((Object)TSDataType.TEXT) ? new ElasticSerializableBinaryTVList(queryId, memoryLimitInMB, cacheSize) : new ElasticSerializableTVList(dataType, queryId, memoryLimitInMB, cacheSize);
    }

    protected ElasticSerializableTVList(TSDataType dataType, String queryId, float memoryLimitInMB, int cacheSize) {
        this.dataType = dataType;
        this.queryId = queryId;
        this.memoryLimitInMB = memoryLimitInMB;
        int allocatableCapacity = SerializableTVList.calculateCapacity(dataType, memoryLimitInMB);
        this.internalTVListCapacity = allocatableCapacity / cacheSize;
        if (this.internalTVListCapacity == 0) {
            cacheSize = 1;
            this.internalTVListCapacity = allocatableCapacity;
        }
        this.cacheSize = cacheSize;
        this.cache = new LRUCache(cacheSize);
        this.internalTVList = new ArrayList<SerializableTVList>();
        this.internalColumnCountList = new ArrayList<Integer>();
        this.pointCount = 0;
        this.evictionUpperBound = 0;
        this.iteratorList = new ArrayList<TVListForwardIterator>();
    }

    protected ElasticSerializableTVList(TSDataType dataType, String queryId, float memoryLimitInMB, int internalTVListCapacity, int cacheSize) {
        this.dataType = dataType;
        this.queryId = queryId;
        this.memoryLimitInMB = memoryLimitInMB;
        this.internalTVListCapacity = internalTVListCapacity;
        this.cacheSize = cacheSize;
        this.cache = new LRUCache(cacheSize);
        this.internalTVList = new ArrayList<SerializableTVList>();
        this.internalColumnCountList = new ArrayList<Integer>();
        this.pointCount = 0;
        this.evictionUpperBound = 0;
        this.iteratorList = new ArrayList<TVListForwardIterator>();
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public int size() {
        return this.pointCount;
    }

    public int getInternalTVListCapacity() {
        return this.internalTVListCapacity;
    }

    public SerializableTVList getSerializableTVList(int index) {
        return this.internalTVList.get(index);
    }

    public int getSerializableTVListSize() {
        return this.internalTVList.size();
    }

    public boolean isNull(int index) throws IOException {
        return this.cache.get(index / this.internalTVListCapacity).isNull(index % this.internalTVListCapacity);
    }

    public long getTime(int index) throws IOException {
        return this.cache.get(index / this.internalTVListCapacity).getTime(index % this.internalTVListCapacity);
    }

    public int getInt(int index) throws IOException {
        return this.cache.get(index / this.internalTVListCapacity).getInt(index % this.internalTVListCapacity);
    }

    public long getLong(int index) throws IOException {
        return this.cache.get(index / this.internalTVListCapacity).getLong(index % this.internalTVListCapacity);
    }

    public float getFloat(int index) throws IOException {
        return this.cache.get(index / this.internalTVListCapacity).getFloat(index % this.internalTVListCapacity);
    }

    public double getDouble(int index) throws IOException {
        return this.cache.get(index / this.internalTVListCapacity).getDouble(index % this.internalTVListCapacity);
    }

    public boolean getBoolean(int index) throws IOException {
        return this.cache.get(index / this.internalTVListCapacity).getBoolean(index % this.internalTVListCapacity);
    }

    public Binary getBinary(int index) throws IOException {
        return this.cache.get(index / this.internalTVListCapacity).getBinary(index % this.internalTVListCapacity);
    }

    public String getString(int index) throws IOException {
        return this.cache.get(index / this.internalTVListCapacity).getBinary(index % this.internalTVListCapacity).getStringValue(TSFileConfig.STRING_CHARSET);
    }

    public Column getTimeColumn(int externalIndex, int internalIndex) throws IOException {
        return this.cache.get(externalIndex).getTimeColumn(internalIndex);
    }

    public Column getValueColumn(int externalIndex, int internalIndex) throws IOException {
        return this.cache.get(externalIndex).getValueColumn(internalIndex);
    }

    public void putColumn(Column timeColumn, Column valueColumn) throws IOException {
        this.checkExpansion();
        int begin = 0;
        int end = 0;
        int total = timeColumn.getPositionCount();
        while (total > 0) {
            Column insertedValueColumn;
            Column insertedTimeColumn;
            int consumed;
            if (total + this.pointCount % this.internalTVListCapacity < this.internalTVListCapacity) {
                consumed = total;
                if (begin == 0) {
                    insertedTimeColumn = timeColumn;
                    insertedValueColumn = valueColumn;
                } else {
                    insertedTimeColumn = timeColumn.getRegionCopy(begin, consumed);
                    insertedValueColumn = valueColumn.getRegionCopy(begin, consumed);
                }
            } else {
                consumed = this.internalTVListCapacity - this.pointCount % this.internalTVListCapacity;
                insertedTimeColumn = timeColumn.getRegionCopy(begin, consumed);
                insertedValueColumn = valueColumn.getRegionCopy(begin, consumed);
            }
            begin = end += consumed;
            this.cache.get(this.pointCount / this.internalTVListCapacity).putColumns(insertedTimeColumn, insertedValueColumn);
            this.pointCount += consumed;
            if ((total -= consumed) <= 0) continue;
            this.doExpansion();
        }
    }

    public TVListForwardIterator constructIterator() {
        TVListForwardIterator iterator = new TVListForwardIterator(this);
        this.iteratorList.add(iterator);
        return iterator;
    }

    private void checkExpansion() {
        if (this.pointCount % this.internalTVListCapacity == 0) {
            this.doExpansion();
        }
    }

    private void doExpansion() {
        if (this.internalTVList.size() > 0) {
            int lastIndex = this.internalTVList.size() - 1;
            SerializableTVList lastInternalList = this.internalTVList.get(lastIndex);
            this.internalColumnCountList.add(lastInternalList.getColumnCount());
        }
        this.internalTVList.add(SerializableTVList.construct(this.queryId));
    }

    public void setEvictionUpperBound(int evictionUpperBound) {
        this.evictionUpperBound = evictionUpperBound;
    }

    public int getColumnCount(int index) {
        if (index == this.internalTVList.size() - 1) {
            SerializableTVList lastList = this.internalTVList.get(index);
            return lastList.getColumnCount();
        }
        return this.internalColumnCountList.get(index);
    }

    public int getLastPointIndex(int externalIndex, int internalIndex) {
        int index = this.internalTVListCapacity * externalIndex;
        int offset = this.internalTVList.get(externalIndex).getLastPointIndex(internalIndex);
        return index + offset;
    }

    public class LRUCache
    extends Cache {
        LRUCache(int capacity) {
            super(capacity);
        }

        public SerializableTVList get(int targetIndex) throws IOException {
            if (!this.containsKey(targetIndex)) {
                if (this.cacheCapacity <= super.size()) {
                    int lastIndex = this.getLast();
                    if (lastIndex < ElasticSerializableTVList.this.evictionUpperBound / ElasticSerializableTVList.this.internalTVListCapacity) {
                        ElasticSerializableTVList.this.internalTVList.set(lastIndex, null);
                    } else {
                        ElasticSerializableTVList.this.internalTVList.get(lastIndex).serialize();
                    }
                }
                ElasticSerializableTVList.this.internalTVList.get(targetIndex).deserialize();
            }
            this.putKey(targetIndex);
            return ElasticSerializableTVList.this.internalTVList.get(targetIndex);
        }
    }
}

