/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class RemoveRedundantIdentityProjections
implements Rule<ProjectNode> {
    private static final Pattern<ProjectNode> PATTERN = Patterns.project().matching(ProjectNode::isIdentity).matching(RemoveRedundantIdentityProjections::outputsSameAsSource);

    private static boolean outputsSameAsSource(ProjectNode node) {
        return ImmutableSet.copyOf(node.getOutputSymbols()).equals((Object)ImmutableSet.copyOf(node.getChild().getOutputSymbols()));
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ProjectNode project, Captures captures, Rule.Context context) {
        return Rule.Result.ofPlanNode(project.getChild());
    }
}

