/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.memory;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.commons.schema.node.MNodeType;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.plan.execution.memory.StatementMemorySource;
import org.apache.iotdb.db.queryengine.plan.execution.memory.StatementMemorySourceContext;
import org.apache.iotdb.db.queryengine.plan.planner.LogicalPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.DistributionPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanGraphPrinter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountDevicesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountNodesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowChildNodesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowChildPathsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowCurrentTimestampStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowPathsUsingTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.ExplainStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.ShowVersionStatement;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class StatementMemorySourceVisitor
extends StatementVisitor<StatementMemorySource, StatementMemorySourceContext> {
    @Override
    public StatementMemorySource visitNode(StatementNode node, StatementMemorySourceContext context) {
        DatasetHeader datasetHeader = context.getAnalysis().getRespDatasetHeader();
        return new StatementMemorySource(new TsBlock(0), datasetHeader == null ? DatasetHeader.EMPTY_HEADER : datasetHeader);
    }

    private boolean sourceNotExist(StatementMemorySourceContext context) {
        return !(context.getAnalysis().shouldHaveSourceExpression() || context.getAnalysis().getSourceExpressions() != null && !context.getAnalysis().getSourceExpressions().isEmpty() || context.getAnalysis().getDeviceToSourceExpressions() != null && !context.getAnalysis().getDeviceToSourceExpressions().isEmpty() || context.getAnalysis().getDeviceTemplate() != null);
    }

    @Override
    public StatementMemorySource visitExplain(ExplainStatement node, StatementMemorySourceContext context) {
        context.getAnalysis().setRealStatement(node.getQueryStatement());
        DatasetHeader header = new DatasetHeader(Collections.singletonList(new ColumnHeader("distribution plan", TSDataType.TEXT)), true);
        if (this.sourceNotExist(context)) {
            return new StatementMemorySource(new TsBlock(0), header);
        }
        LogicalQueryPlan logicalPlan = new LogicalPlanner(context.getQueryContext()).plan(context.getAnalysis());
        DistributionPlanner planner = new DistributionPlanner(context.getAnalysis(), logicalPlan);
        PlanNode rootWithExchange = planner.addExchangeNode(planner.rewriteSource());
        PlanNode optimizedRootWithExchange = planner.optimize(rootWithExchange);
        List<String> lines = optimizedRootWithExchange.accept(new PlanGraphPrinter(), new PlanGraphPrinter.GraphContext(context.getQueryContext().getTypeProvider().getTemplatedInfo()));
        return StatementMemorySourceVisitor.getStatementMemorySource(header, lines);
    }

    static StatementMemorySource getStatementMemorySource(DatasetHeader header, List<String> lines) {
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(TSDataType.TEXT));
        lines.forEach(line -> {
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(new Binary(line, TSFileConfig.STRING_CHARSET));
            builder.declarePosition();
        });
        TsBlock tsBlock = builder.build();
        return new StatementMemorySource(tsBlock, header);
    }

    @Override
    public StatementMemorySource visitShowChildPaths(ShowChildPathsStatement showChildPathsStatement, StatementMemorySourceContext context) {
        List outputDataTypes = ColumnHeaderConstant.showChildPathsColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(outputDataTypes);
        Set<TSchemaNode> matchedChildPaths = context.getAnalysis().getMatchedNodes();
        TreeSet<TSchemaNode> sortSet = new TreeSet<TSchemaNode>((o1, o2) -> {
            if (o1.getNodeType() == o2.getNodeType()) {
                return o1.getNodeName().compareTo(o2.getNodeName());
            }
            return o1.getNodeType() - o2.getNodeType();
        });
        sortSet.addAll(matchedChildPaths);
        sortSet.forEach(node -> {
            tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
            tsBlockBuilder.getColumnBuilder(0).writeBinary(new Binary(node.getNodeName(), TSFileConfig.STRING_CHARSET));
            tsBlockBuilder.getColumnBuilder(1).writeBinary(new Binary(MNodeType.getMNodeType((byte)node.getNodeType()).getNodeTypeName(), TSFileConfig.STRING_CHARSET));
            tsBlockBuilder.declarePosition();
        });
        return new StatementMemorySource(tsBlockBuilder.build(), context.getAnalysis().getRespDatasetHeader());
    }

    @Override
    public StatementMemorySource visitShowChildNodes(ShowChildNodesStatement showChildNodesStatement, StatementMemorySourceContext context) {
        List outputDataTypes = ColumnHeaderConstant.showChildNodesColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(outputDataTypes);
        Set matchedChildNodes = context.getAnalysis().getMatchedNodes().stream().map(TSchemaNode::getNodeName).collect(Collectors.toCollection(TreeSet::new));
        matchedChildNodes.forEach(node -> {
            try {
                PartialPath nodePath = new PartialPath(node);
                String nodeName = nodePath.getTailNode();
                tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
                tsBlockBuilder.getColumnBuilder(0).writeBinary(new Binary(nodeName, TSFileConfig.STRING_CHARSET));
                tsBlockBuilder.declarePosition();
            }
            catch (IllegalPathException illegalPathException) {
                // empty catch block
            }
        });
        return new StatementMemorySource(tsBlockBuilder.build(), context.getAnalysis().getRespDatasetHeader());
    }

    @Override
    public StatementMemorySource visitShowVersion(ShowVersionStatement showVersionStatement, StatementMemorySourceContext context) {
        return new StatementMemorySource(StatementMemorySourceVisitor.getVersionResult(), context.getAnalysis().getRespDatasetHeader());
    }

    public static TsBlock getVersionResult() {
        List outputDataTypes = ColumnHeaderConstant.showVersionColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(outputDataTypes);
        tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
        tsBlockBuilder.getColumnBuilder(0).writeBinary(new Binary(IoTDBConstant.VERSION, TSFileConfig.STRING_CHARSET));
        tsBlockBuilder.getColumnBuilder(1).writeBinary(new Binary(IoTDBConstant.BUILD_INFO, TSFileConfig.STRING_CHARSET));
        tsBlockBuilder.declarePosition();
        return tsBlockBuilder.build();
    }

    @Override
    public StatementMemorySource visitCountNodes(CountNodesStatement countStatement, StatementMemorySourceContext context) {
        List outputDataTypes = ColumnHeaderConstant.countNodesColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(outputDataTypes);
        Set matchedChildNodes = context.getAnalysis().getMatchedNodes().stream().map(TSchemaNode::getNodeName).collect(Collectors.toSet());
        tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
        tsBlockBuilder.getColumnBuilder(0).writeLong((long)matchedChildNodes.size());
        tsBlockBuilder.declarePosition();
        return new StatementMemorySource(tsBlockBuilder.build(), context.getAnalysis().getRespDatasetHeader());
    }

    @Override
    public StatementMemorySource visitCountDevices(CountDevicesStatement countStatement, StatementMemorySourceContext context) {
        List outputDataTypes = ColumnHeaderConstant.countDevicesColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(outputDataTypes);
        tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
        tsBlockBuilder.getColumnBuilder(0).writeLong(0L);
        tsBlockBuilder.declarePosition();
        return new StatementMemorySource(tsBlockBuilder.build(), context.getAnalysis().getRespDatasetHeader());
    }

    @Override
    public StatementMemorySource visitCountTimeSeries(CountTimeSeriesStatement countStatement, StatementMemorySourceContext context) {
        List outputDataTypes = ColumnHeaderConstant.countTimeSeriesColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(outputDataTypes);
        tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
        tsBlockBuilder.getColumnBuilder(0).writeLong(0L);
        tsBlockBuilder.declarePosition();
        return new StatementMemorySource(tsBlockBuilder.build(), context.getAnalysis().getRespDatasetHeader());
    }

    @Override
    public StatementMemorySource visitShowPathsUsingTemplate(ShowPathsUsingTemplateStatement showPathsUsingTemplateStatement, StatementMemorySourceContext context) {
        List outputDataTypes = ColumnHeaderConstant.showPathsUsingTemplateHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(outputDataTypes);
        return new StatementMemorySource(tsBlockBuilder.build(), context.getAnalysis().getRespDatasetHeader());
    }

    @Override
    public StatementMemorySource visitShowCurrentTimestamp(ShowCurrentTimestampStatement showCurrentTimestampStatement, StatementMemorySourceContext context) {
        return new StatementMemorySource(StatementMemorySourceVisitor.getCurrentTimestampResult(), context.getAnalysis().getRespDatasetHeader());
    }

    public static TsBlock getCurrentTimestampResult() {
        List outputDataTypes = ColumnHeaderConstant.SHOW_CURRENT_TIMESTAMP_COLUMN_HEADERS.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(outputDataTypes);
        tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
        tsBlockBuilder.getColumnBuilder(0).writeLong(System.currentTimeMillis());
        tsBlockBuilder.declarePosition();
        return tsBlockBuilder.build();
    }
}

