/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.table.column;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class FieldColumnSchema
extends TsTableColumnSchema {
    private final TSEncoding encoding;
    private final CompressionType compressor;

    public FieldColumnSchema(String columnName, TSDataType dataType) {
        super(columnName, dataType);
        this.encoding = TSEncoding.PLAIN;
        this.compressor = CompressionType.UNCOMPRESSED;
    }

    public FieldColumnSchema(String columnName, TSDataType dataType, TSEncoding encoding, CompressionType compressor) {
        super(columnName, dataType);
        this.encoding = encoding;
        this.compressor = compressor;
    }

    public FieldColumnSchema(String columnName, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props) {
        super(columnName, dataType, props);
        this.encoding = encoding;
        this.compressor = compressor;
    }

    public void setDataType(TSDataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public TsTableColumnCategory getColumnCategory() {
        return TsTableColumnCategory.FIELD;
    }

    public TSEncoding getEncoding() {
        return this.encoding;
    }

    public CompressionType getCompressor() {
        return this.compressor;
    }

    public IMeasurementSchema getMeasurementSchema() {
        return new MeasurementSchema(this.columnName, this.dataType, this.encoding, this.compressor, this.props);
    }

    @Override
    void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((String)this.columnName, (OutputStream)outputStream);
        ReadWriteIOUtils.write((TSDataType)this.dataType, (OutputStream)outputStream);
        ReadWriteIOUtils.write((TSEncoding)this.encoding, (OutputStream)outputStream);
        ReadWriteIOUtils.write((CompressionType)this.compressor, (OutputStream)outputStream);
        ReadWriteIOUtils.write((Map)this.props, (OutputStream)outputStream);
    }

    static FieldColumnSchema deserialize(InputStream stream) throws IOException {
        String columnName = ReadWriteIOUtils.readString((InputStream)stream);
        TSDataType dataType = ReadWriteIOUtils.readDataType((InputStream)stream);
        TSEncoding encoding = ReadWriteIOUtils.readEncoding((InputStream)stream);
        CompressionType compressor = ReadWriteIOUtils.readCompressionType((InputStream)stream);
        Map props = ReadWriteIOUtils.readMap((InputStream)stream);
        return new FieldColumnSchema(columnName, dataType, encoding, compressor, props);
    }

    static FieldColumnSchema deserialize(ByteBuffer buffer) {
        String columnName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        TSDataType dataType = ReadWriteIOUtils.readDataType((ByteBuffer)buffer);
        TSEncoding encoding = ReadWriteIOUtils.readEncoding((ByteBuffer)buffer);
        CompressionType compressor = ReadWriteIOUtils.readCompressionType((ByteBuffer)buffer);
        Map props = ReadWriteIOUtils.readMap((ByteBuffer)buffer);
        return new FieldColumnSchema(columnName, dataType, encoding, compressor, props);
    }
}

