/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc.relational;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.iotdb.jdbc.Field;
import org.apache.iotdb.jdbc.IoTDBAbstractDatabaseMetadata;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.iotdb.jdbc.IoTDBJDBCResultSet;
import org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import org.apache.tsfile.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBRelationalDatabaseMetadata
extends IoTDBAbstractDatabaseMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBRelationalDatabaseMetadata.class);
    private static final String DATABASE_VERSION = IoTDBRelationalDatabaseMetadata.class.getPackage().getImplementationVersion() != null ? IoTDBRelationalDatabaseMetadata.class.getPackage().getImplementationVersion() : "UNKNOWN";
    public static final String SHOW_TABLES_ERROR_MSG = "Show tables error: {}";
    public static final String[] allIotdbTableSQLKeywords = new String[]{"ALTER", "AND", "AS", "BETWEEN", "BY", "CASE", "CAST", "CONSTRAINT", "CREATE", "CROSS", "CUBE", "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DEALLOCATE", "DELETE", "DESCRIBE", "DISTINCT", "DROP", "ELSE", "END", "ESCAPE", "EXCEPT", "EXISTS", "EXTRACT", "FALSE", "FOR", "FROM", "FULL", "GROUP", "GROUPING", "HAVING", "IN", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "JOIN", "JSON_ARRAY", "JSON_EXISTS", "JSON_OBJECT", "JSON_QUERY", "JSON_TABLE", "JSON_VALUE", "LEFT", "LIKE", "LISTAGG", "LOCALTIME", "LOCALTIMESTAMP", "NATURAL", "NORMALIZE", "NOT", "NULL", "ON", "OR", "ORDER", "OUTER", "PREPARE", "RECURSIVE", "RIGHT", "ROLLUP", "SELECT", "SKIP", "TABLE", "THEN", "TRIM", "TRUE", "UESCAPE", "UNION", "UNNEST", "USING", "VALUES", "WHEN", "WHERE", "WITH", "FILL"};
    private static final String[] allIoTDBTableMathFunctions = new String[]{"ABS", "ACOS", "ASIN", "ATAN", "CEIL", "COS", "COSH", "DEGREES", "E", "EXP", "FLOOR", "LN", "LOG10", "PI", "RADIANS", "ROUND", "SIGN", "SIN", "SINH", "SQRT", "TAN", "TANH"};

    public IoTDBRelationalDatabaseMetadata(IoTDBConnection connection, IClientRPCService.Iface client, long sessionId, ZoneId zoneId) {
        super(connection, client, sessionId, zoneId);
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return DATABASE_VERSION;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return String.join((CharSequence)",", allIoTDBTableMathFunctions);
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "DATE_BIN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        ResultSet rs;
        boolean legacyMode = true;
        try (Statement stmt = this.connection.createStatement();){
            String sql = String.format("select * from information_schema.tables where database like '%s' escape '\\'", schemaPattern);
            rs = stmt.executeQuery(sql);
        }
        Field[] fields = new Field[]{new Field("", "TABLE_SCHEM", "TEXT"), new Field("", "TABLE_NAME", "TEXT"), new Field("", "TABLE_TYPE", "TEXT"), new Field("", "REMARKS", "TEXT"), new Field("", "COLUMN_SIZE", "INT32"), new Field("", "DECIMAL_DIGITS", "INT32")};
        List<TSDataType> tsDataTypeList = Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.INT32, TSDataType.INT32);
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        ArrayList<List<Object>> valuesList = new ArrayList<List<Object>>();
        for (int i = 0; i < fields.length; ++i) {
            columnNameList.add(fields[i].getName());
            columnTypeList.add(fields[i].getSqlType());
            columnNameIndex.put(fields[i].getName(), i);
        }
        boolean hasResultSet = false;
        while (rs.next()) {
            hasResultSet = true;
            ArrayList<Object> valueInRow = new ArrayList<Object>();
            for (int i = 0; i < fields.length; ++i) {
                if (i == 0) {
                    valueInRow.add(schemaPattern);
                    continue;
                }
                if (i == 1) {
                    valueInRow.add(legacyMode ? rs.getString("table_name") : rs.getString("TableName"));
                    continue;
                }
                if (i == 2) {
                    valueInRow.add("TABLE");
                    continue;
                }
                if (i == 3) {
                    String comment;
                    String string = comment = legacyMode ? rs.getString("comment") : rs.getString("Comment");
                    if (comment != null && !comment.isEmpty()) {
                        valueInRow.add(comment);
                        continue;
                    }
                    valueInRow.add("");
                    continue;
                }
                if (i == 4) {
                    valueInRow.add(this.getTypePrecision(fields[i].getSqlType()));
                    continue;
                }
                if (i == 5) {
                    valueInRow.add(this.getTypeScale(fields[i].getSqlType()));
                    continue;
                }
                valueInRow.add("TABLE");
            }
            valuesList.add(valueInRow);
        }
        ByteBuffer tsBlock = null;
        try {
            tsBlock = IoTDBRelationalDatabaseMetadata.convertTsBlock(valuesList, tsDataTypeList);
        }
        catch (IOException e) {
            LOGGER.error("Convert tsBlock error: {}", (Object)e.getMessage());
        }
        finally {
            this.close(rs, stmt);
        }
        return hasResultSet ? new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, true, this.client, null, -1L, this.sessionId, Collections.singletonList(tsBlock), null, 60000L, false, this.zoneId) : null;
    }

    public static String removeEscape(String pattern) {
        return pattern.replaceAll("\\_", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ResultSet rs;
        boolean legacyMode = true;
        try (Statement stmt = this.connection.createStatement();){
            String sql = String.format("select * from information_schema.columns where database like '%s' escape '\\' and table_name like '%s' escape '\\'", schemaPattern, tableNamePattern);
            rs = stmt.executeQuery(sql);
        }
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", "TEXT"), new Field("", "TABLE_SCHEM", "TEXT"), new Field("", "TABLE_NAME", "TEXT"), new Field("", "COLUMN_NAME", "TEXT"), new Field("", "DATA_TYPE", "INT32"), new Field("", "TYPE_NAME", "TEXT"), new Field("", "COLUMN_SIZE", "INT32"), new Field("", "BUFFER_LENGTH", "INT32"), new Field("", "DECIMAL_DIGITS", "INT32"), new Field("", "NUM_PREC_RADIX", "INT32"), new Field("", "NULLABLE", "INT32"), new Field("", "REMARKS", "TEXT"), new Field("", "COLUMN_DEF", "TEXT"), new Field("", "SQL_DATA_TYPE", "INT32"), new Field("", "SQL_DATETIME_SUB", "INT32"), new Field("", "CHAR_OCTET_LENGTH", "INT32"), new Field("", "ORDINAL_POSITION", "INT32"), new Field("", "IS_NULLABLE", "TEXT"), new Field("", "SCOPE_CATALOG", "TEXT"), new Field("", "SCOPE_SCHEMA", "TEXT"), new Field("", "SCOPE_TABLE", "TEXT"), new Field("", "SOURCE_DATA_TYPE", "TEXT"), new Field("", "IS_AUTOINCREMENT", "TEXT"), new Field("", "IS_GENERATEDCOLUMN", "TEXT")};
        List<TSDataType> tsDataTypeList = Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.INT32, TSDataType.TEXT, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.TEXT, TSDataType.TEXT, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.INT32, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT);
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        ArrayList<List<Object>> valuesList = new ArrayList<List<Object>>();
        for (int i = 0; i < fields.length; ++i) {
            columnNameList.add(fields[i].getName());
            columnTypeList.add(fields[i].getSqlType());
            columnNameIndex.put(fields[i].getName(), i);
        }
        int count = 1;
        while (rs.next()) {
            String columnName = legacyMode ? rs.getString("column_name") : rs.getString("ColumnName");
            String type = legacyMode ? rs.getString("datatype") : rs.getString("DataType");
            ArrayList<Object> valueInRow = new ArrayList<Object>();
            for (int i = 0; i < fields.length; ++i) {
                if (i == 0) {
                    valueInRow.add(schemaPattern);
                    continue;
                }
                if (i == 1) {
                    valueInRow.add("");
                    continue;
                }
                if (i == 2) {
                    valueInRow.add(tableNamePattern);
                    continue;
                }
                if (i == 3) {
                    valueInRow.add(columnName);
                    continue;
                }
                if (i == 4) {
                    valueInRow.add(this.getSQLType(type));
                    continue;
                }
                if (i == 5) {
                    valueInRow.add(type);
                    continue;
                }
                if (i == 6) {
                    valueInRow.add(0);
                    continue;
                }
                if (i == 7) {
                    valueInRow.add(65535);
                    continue;
                }
                if (i == 8) {
                    valueInRow.add(this.getTypeScale(fields[i].getSqlType()));
                    continue;
                }
                if (i == 9) {
                    valueInRow.add(0);
                    continue;
                }
                if (i == 10) {
                    if (!columnName.equals("time")) {
                        valueInRow.add(2);
                        continue;
                    }
                    valueInRow.add(0);
                    continue;
                }
                if (i == 11) {
                    String comment;
                    String string = comment = legacyMode ? rs.getString("comment") : rs.getString("Comment");
                    if (comment != null && !comment.isEmpty()) {
                        valueInRow.add(comment);
                        continue;
                    }
                    valueInRow.add("");
                    continue;
                }
                if (i == 12) {
                    valueInRow.add("");
                    continue;
                }
                if (i == 13) {
                    valueInRow.add(0);
                    continue;
                }
                if (i == 14) {
                    valueInRow.add(0);
                    continue;
                }
                if (i == 15) {
                    valueInRow.add(65535);
                    continue;
                }
                if (i == 16) {
                    valueInRow.add(count++);
                    continue;
                }
                if (i == 17) {
                    if (!columnName.equals("time")) {
                        valueInRow.add("YES");
                        continue;
                    }
                    valueInRow.add("NO");
                    continue;
                }
                if (i == 18) {
                    valueInRow.add("");
                    continue;
                }
                if (i == 19) {
                    valueInRow.add("");
                    continue;
                }
                if (i == 20) {
                    valueInRow.add("");
                    continue;
                }
                if (i == 21) {
                    valueInRow.add("");
                    continue;
                }
                if (i == 22) {
                    valueInRow.add("");
                    continue;
                }
                if (i != 23) continue;
                valueInRow.add("");
            }
            valuesList.add(valueInRow);
        }
        ByteBuffer tsBlock = null;
        try {
            tsBlock = IoTDBRelationalDatabaseMetadata.convertTsBlock(valuesList, tsDataTypeList);
        }
        catch (IOException e) {
            LOGGER.error("Convert tsBlock error: {}", (Object)e.getMessage());
        }
        finally {
            this.close(rs, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, true, this.client, null, -1L, this.sessionId, Collections.singletonList(tsBlock), null, 60000L, false, this.zoneId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPrimaryKeys(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ResultSet rs;
        boolean legacyMode = true;
        try (Statement stmt = this.connection.createStatement();){
            String sql = String.format("select * from information_schema.columns where database like '%s'  escape '\\' and table_name like '%s' escape '\\' and (category='TAG' or category='TIME')", schemaPattern, tableNamePattern);
            rs = stmt.executeQuery(sql);
        }
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", "TEXT"), new Field("", "TABLE_SCHEM", "TEXT"), new Field("", "TABLE_NAME", "TEXT"), new Field("", "COLUMN_NAME", "TEXT"), new Field("", "KEY_SEQ", "INT32"), new Field("", "PK_NAME", "TEXT")};
        List<TSDataType> tsDataTypeList = Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.INT32, TSDataType.TEXT);
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList<String> columnTypeList = new ArrayList<String>();
        HashMap<String, Integer> columnNameIndex = new HashMap<String, Integer>();
        ArrayList<List<Object>> valuesList = new ArrayList<List<Object>>();
        for (int i = 0; i < fields.length; ++i) {
            columnNameList.add(fields[i].getName());
            columnTypeList.add(fields[i].getSqlType());
            columnNameIndex.put(fields[i].getName(), i);
        }
        int count = 1;
        while (rs.next()) {
            String category;
            String columnName = legacyMode ? rs.getString("column_name") : rs.getString("ColumnName");
            String string = category = legacyMode ? rs.getString("category") : rs.getString("Category");
            if (!category.equals("TAG") && !category.equals("TIME")) continue;
            ArrayList<Object> valueInRow = new ArrayList<Object>();
            for (int i = 0; i < fields.length; ++i) {
                if (i == 0) {
                    valueInRow.add(schemaPattern);
                    continue;
                }
                if (i == 1) {
                    valueInRow.add(schemaPattern);
                    continue;
                }
                if (i == 2) {
                    valueInRow.add(tableNamePattern);
                    continue;
                }
                if (i == 3) {
                    valueInRow.add(columnName);
                    continue;
                }
                if (i == 4) {
                    valueInRow.add(count++);
                    continue;
                }
                valueInRow.add("PRIMARY");
            }
            valuesList.add(valueInRow);
        }
        ByteBuffer tsBlock = null;
        try {
            tsBlock = IoTDBRelationalDatabaseMetadata.convertTsBlock(valuesList, tsDataTypeList);
        }
        catch (IOException e) {
            LOGGER.error("Get primary keys error: {}", (Object)e.getMessage());
        }
        finally {
            this.close(null, stmt);
        }
        return new IoTDBJDBCResultSet(stmt, columnNameList, columnTypeList, columnNameIndex, true, this.client, null, -1L, this.sessionId, Collections.singletonList(tsBlock), null, 60000L, false, this.zoneId);
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "";
    }

    static {
        try {
            TreeMap myKeywordMap = new TreeMap();
            for (String allIotdbSQLKeyword : allIotdbTableSQLKeywords) {
                myKeywordMap.put(allIotdbSQLKeyword, null);
            }
            HashMap sql92KeywordMap = new HashMap(sql92Keywords.length);
            for (String sql92Keyword : sql92Keywords) {
                sql92KeywordMap.put(sql92Keyword, null);
            }
            Iterator it = sql92KeywordMap.keySet().iterator();
            while (it.hasNext()) {
                myKeywordMap.remove(it.next());
            }
            StringBuilder keywordBuf = new StringBuilder();
            it = myKeywordMap.keySet().iterator();
            if (it.hasNext()) {
                keywordBuf.append((String)it.next());
            }
            while (it.hasNext()) {
                keywordBuf.append(",");
                keywordBuf.append((String)it.next());
            }
            sqlKeywordsThatArentSQL92 = keywordBuf.toString();
        }
        catch (Exception e) {
            LOGGER.error("Error when initializing SQL keywords: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

