/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.pagemgr;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.metadata.schemafile.ColossalRecordException;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISegmentedPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFile;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.pagemgr.PageManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.pagemgr.SchemaPageContext;

public class BTreePageManager
extends PageManager {
    public BTreePageManager(FileChannel channel, File pmtFile, int lastPageIndex, String logPath) throws IOException, MetadataException {
        super(channel, pmtFile, lastPageIndex, logPath);
    }

    @Override
    protected void multiPageInsertOverflowOperation(ISchemaPage curPage, String key, ByteBuffer childBuffer, SchemaPageContext cxt) throws MetadataException, IOException {
        ISegmentedPage newPage = this.getMinApplSegmentedPageInMem((short)16350, cxt);
        newPage.allocNewSegment((short)16350);
        String sk = curPage.getAsSegmentedPage().splitWrappedSegment(key, childBuffer, newPage, true);
        curPage.getAsSegmentedPage().setNextSegAddress((short)0, SchemaFile.getGlobalIndex(newPage.getPageIndex(), (short)0));
        cxt.markDirty(curPage);
        this.insertIndexEntryEntrance(curPage, newPage, sk, cxt);
    }

    @Override
    protected void multiPageUpdateOverflowOperation(ISchemaPage curPage, String key, ByteBuffer childBuffer, SchemaPageContext cxt) throws MetadataException, IOException {
        ISegmentedPage splPage = this.getMinApplSegmentedPageInMem((short)16350, cxt);
        splPage.allocNewSegment((short)16350);
        String sk = curPage.getAsSegmentedPage().splitWrappedSegment(null, null, splPage, false);
        curPage.getAsSegmentedPage().setNextSegAddress((short)0, SchemaFile.getGlobalIndex(splPage.getPageIndex(), (short)0));
        if (key.compareTo(sk) >= 0) {
            splPage.update((short)0, key, childBuffer);
        } else {
            curPage.getAsSegmentedPage().update((short)0, key, childBuffer);
        }
        this.insertIndexEntryEntrance(curPage, splPage, sk, cxt);
    }

    @Override
    protected void buildSubIndex(ICachedMNode parNode, SchemaPageContext cxt) throws MetadataException, IOException {
        ISchemaPage cursorPage = this.getPageInstance(SchemaFile.getPageIndex(SchemaFile.getNodeAddress(parNode)), cxt);
        if (cursorPage.getAsInternalPage() == null) {
            throw new MetadataException("Subordinate index shall not build upon single page segment.");
        }
        ISchemaPage tPage = cursorPage;
        ISchemaPage subIndexPage = ISchemaPage.initAliasIndexPage(ByteBuffer.allocate(16384), -1);
        this.registerAsNewPage(subIndexPage, cxt);
        while (cursorPage.getAsInternalPage() != null) {
            cursorPage = this.getPageInstance(SchemaFile.getPageIndex(cursorPage.getAsInternalPage().getNextSegAddress()), cxt);
        }
        long nextAddr = cursorPage.getAsSegmentedPage().getNextSegAddress((short)0);
        Queue<ICachedMNode> children = cursorPage.getAsSegmentedPage().getChildren((short)0);
        while (!children.isEmpty() || nextAddr != -1L) {
            ICachedMNode child;
            if (children.isEmpty()) {
                cursorPage = this.getPageInstance(SchemaFile.getPageIndex(nextAddr), cxt);
                nextAddr = cursorPage.getAsSegmentedPage().getNextSegAddress((short)0);
                children = cursorPage.getAsSegmentedPage().getChildren((short)0);
            }
            if ((child = children.poll()) == null || !child.isMeasurement() || child.getAsMeasurementMNode().getAlias() == null) continue;
            subIndexPage = this.insertAliasIndexEntry(subIndexPage, child.getAsMeasurementMNode().getAlias(), child.getName(), cxt);
        }
        tPage.setSubIndex(subIndexPage.getPageIndex());
    }

    @Override
    protected void insertSubIndexEntry(int base, String key, String rec, SchemaPageContext cxt) throws MetadataException, IOException {
        this.insertAliasIndexEntry(this.getPageInstance(base, cxt), key, rec, cxt);
    }

    @Override
    protected void removeSubIndexEntry(int base, String oldAlias, SchemaPageContext cxt) throws MetadataException, IOException {
        ISchemaPage tarPage = this.getTargetLeafPage(this.getPageInstance(base, cxt), oldAlias, cxt);
        tarPage.getAsAliasIndexPage().removeRecord(oldAlias);
    }

    @Override
    protected String searchSubIndexAlias(int base, String alias, SchemaPageContext cxt) throws MetadataException, IOException {
        return this.getTargetLeafPage(this.getPageInstance(base, cxt), alias, cxt).getAsAliasIndexPage().getRecordByAlias(alias);
    }

    private ISchemaPage insertAliasIndexEntry(ISchemaPage topPage, String alias, String name, SchemaPageContext cxt) throws MetadataException, IOException {
        ISchemaPage tarPage = this.getTargetLeafPage(topPage, alias, cxt);
        if (tarPage.getAsAliasIndexPage() == null) {
            throw new MetadataException("File may be corrupted that subordinate index has broken.");
        }
        if (tarPage.getAsAliasIndexPage().insertRecord(alias, name) < 0) {
            ByteBuffer spltBuf = ByteBuffer.allocate(16384);
            String sk = tarPage.getAsAliasIndexPage().splitByKey(alias, name, spltBuf, true);
            SchemaPage splPage = ISchemaPage.loadSchemaPage(spltBuf);
            this.registerAsNewPage(splPage, cxt);
            if (cxt.treeTrace[0] < 1) {
                ByteBuffer trsBuf = ByteBuffer.allocate(16384);
                tarPage.getAsAliasIndexPage().extendsTo(trsBuf);
                SchemaPage trsPage = ISchemaPage.loadSchemaPage(trsBuf);
                this.registerAsNewPage(trsPage, cxt);
                SchemaPage repPage = ISchemaPage.initInternalPage(ByteBuffer.allocate(16384), tarPage.getPageIndex(), trsPage.getPageIndex(), tarPage.getRefCnt(), tarPage.getLock());
                if (0 > repPage.getAsInternalPage().insertRecord(sk, splPage.getPageIndex())) {
                    throw new ColossalRecordException(sk, alias);
                }
                repPage.getAsInternalPage().setNextSegAddress(SchemaFile.getGlobalIndex(trsPage.getPageIndex(), (short)0));
                this.replacePageInCache(repPage, cxt);
                return repPage;
            }
            this.insertIndexEntryRecursiveUpwards(cxt.treeTrace[0], sk, splPage.getPageIndex(), cxt);
            return this.getPageInstance(cxt.treeTrace[1], cxt);
        }
        return topPage;
    }

    private void insertIndexEntryEntrance(ISchemaPage curPage, ISchemaPage splPage, String sk, SchemaPageContext cxt) throws MetadataException, IOException {
        if (cxt.treeTrace[0] < 1) {
            ISegmentedPage trsPage = this.getMinApplSegmentedPageInMem((short)16350, cxt);
            trsPage.transplantSegment(curPage.getAsSegmentedPage(), (short)0, (short)16350);
            SchemaPage repPage = ISchemaPage.initInternalPage(ByteBuffer.allocate(16384), curPage.getPageIndex(), trsPage.getPageIndex(), curPage.getRefCnt(), curPage.getLock());
            if (0 > repPage.getAsInternalPage().insertRecord(sk, splPage.getPageIndex())) {
                throw new ColossalRecordException(sk);
            }
            repPage.getAsInternalPage().setNextSegAddress(SchemaFile.getGlobalIndex(trsPage.getPageIndex(), (short)0));
            cxt.invokeLastLeaf(trsPage);
            this.replacePageInCache(repPage, cxt);
        } else {
            cxt.invokeLastLeaf(curPage);
            this.insertIndexEntryRecursiveUpwards(cxt.treeTrace[0], sk, splPage.getPageIndex(), cxt);
        }
    }

    private void insertIndexEntryRecursiveUpwards(int treeTraceIndex, String key, int ptr, SchemaPageContext cxt) throws MetadataException, IOException {
        ISchemaPage idxPage = this.getPageInstance(cxt.treeTrace[treeTraceIndex], cxt);
        if (idxPage.getAsInternalPage().insertRecord(key, ptr) < 0) {
            if (treeTraceIndex > 1) {
                ByteBuffer dstBuffer = ByteBuffer.allocate(16384);
                String splitKey = idxPage.getAsInternalPage().splitByKey(key, ptr, dstBuffer, true);
                SchemaPage dstPage = ISchemaPage.loadSchemaPage(dstBuffer);
                this.registerAsNewPage(dstPage, cxt);
                this.insertIndexEntryRecursiveUpwards(treeTraceIndex - 1, splitKey, dstPage.getPageIndex(), cxt);
            } else {
                ByteBuffer splBuffer = ByteBuffer.allocate(16384);
                ByteBuffer trsBuffer = ByteBuffer.allocate(16384);
                String splitKey = idxPage.getAsInternalPage().splitByKey(key, ptr, splBuffer, true);
                idxPage.getAsInternalPage().extendsTo(trsBuffer);
                SchemaPage splPage = ISchemaPage.loadSchemaPage(splBuffer);
                SchemaPage trsPage = ISchemaPage.loadSchemaPage(trsBuffer);
                this.registerAsNewPage(splPage, cxt);
                this.registerAsNewPage(trsPage, cxt);
                idxPage.getAsInternalPage().resetBuffer(trsPage.getPageIndex());
                if (idxPage.getAsInternalPage().insertRecord(splitKey, splPage.getPageIndex()) < 0) {
                    throw new ColossalRecordException(splitKey);
                }
                idxPage.getAsInternalPage().setNextSegAddress(trsPage.getAsInternalPage().getNextSegAddress());
            }
        }
        cxt.markDirty(idxPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(ICachedMNode node) throws IOException, MetadataException {
        this.pagePool.cacheGuardian();
        SchemaPageContext cxt = new SchemaPageContext();
        this.entrantLock((ICachedMNode)node.getParent(), cxt);
        try {
            long recSegAddr = SchemaFile.getNodeAddress((ICachedMNode)node.getParent());
            recSegAddr = this.getTargetSegmentAddress(recSegAddr, node.getName(), cxt);
            ISchemaPage tarPage = this.getPageInstance(SchemaFile.getPageIndex(recSegAddr), cxt);
            cxt.markDirty(tarPage);
            tarPage.getAsSegmentedPage().removeRecord(SchemaFile.getSegIndex(recSegAddr), node.getName());
            if (!node.isMeasurement() && SchemaFile.getNodeAddress(node) > 0L) {
                long delSegAddr = SchemaFile.getNodeAddress(node);
                tarPage = this.getPageInstance(SchemaFile.getPageIndex(delSegAddr), cxt);
                if (tarPage.getAsSegmentedPage() != null) {
                    cxt.markDirty(tarPage);
                    tarPage.getAsSegmentedPage().deleteSegment(SchemaFile.getSegIndex(delSegAddr));
                    if (tarPage.getAsSegmentedPage().validSegments() == 0) {
                        tarPage.getAsSegmentedPage().purgeSegments();
                    }
                    cxt.indexBuckets.sortIntoBucket(tarPage, (short)-1);
                }
                if (tarPage.getAsInternalPage() != null) {
                    ArrayDeque<Integer> cascadePages = new ArrayDeque<Integer>(tarPage.getAsInternalPage().getAllRecords());
                    cascadePages.add(tarPage.getPageIndex());
                    if (tarPage.getSubIndex() >= 0) {
                        cascadePages.add(tarPage.getSubIndex());
                    }
                    while (!cascadePages.isEmpty()) {
                        tarPage = this.getPageInstance((Integer)cascadePages.poll(), cxt);
                        if (tarPage.getAsSegmentedPage() != null) {
                            tarPage.getAsSegmentedPage().purgeSegments();
                            cxt.markDirty(tarPage);
                            cxt.indexBuckets.sortIntoBucket(tarPage, (short)-1);
                            continue;
                        }
                        if (tarPage.getAsInternalPage() != null) {
                            cascadePages.addAll(tarPage.getAsInternalPage().getAllRecords());
                        }
                        tarPage = ISchemaPage.initSegmentedPage(ByteBuffer.allocate(16384), tarPage.getPageIndex(), tarPage.getRefCnt(), tarPage.getLock());
                        this.replacePageInCache(tarPage, cxt);
                    }
                }
            }
            this.flushDirtyPages(cxt);
        }
        finally {
            this.releaseLocks(cxt);
            this.pagePool.releaseReferent(cxt);
        }
    }

    private ISchemaPage validatePage(ISchemaPage initPage, ICachedMNode parent, SchemaPageContext cxt) throws IOException, MetadataException {
        ISchemaPage crabPage;
        SchemaPageContext doubleCheckContext;
        boolean safeFlag = false;
        while (SchemaFile.getPageIndex(SchemaFile.getNodeAddress(parent)) != initPage.getPageIndex()) {
            doubleCheckContext = new SchemaPageContext();
            long addrB4Lock = SchemaFile.getNodeAddress(parent);
            int piB4Lock = SchemaFile.getPageIndex(addrB4Lock);
            initPage.decrementAndGetRefCnt();
            initPage.getLock().readLock().unlock();
            crabPage = this.getPageInstance(piB4Lock, doubleCheckContext);
            crabPage.getLock().readLock().lock();
            cxt.referredPages.remove(initPage.getPageIndex());
            cxt.referredPages.put(crabPage.getPageIndex(), crabPage);
            initPage = crabPage;
        }
        doubleCheckContext = new SchemaPageContext();
        crabPage = this.getPageInstance(initPage.getPageIndex(), doubleCheckContext);
        if (crabPage != initPage) {
            if (crabPage.getLock() != initPage.getLock() || crabPage.getRefCnt() != initPage.getRefCnt()) {
                crabPage.decrementAndGetRefCnt();
                initPage.decrementAndGetRefCnt();
                initPage.getLock().readLock().unlock();
                throw new MetadataException("Page[%d] replacement error: Different ref count or lock object.");
            }
            cxt.referredPages.put(initPage.getPageIndex(), crabPage);
            initPage = crabPage;
        }
        crabPage.decrementAndGetRefCnt();
        return initPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICachedMNode getChildNode(ICachedMNode parent, String childName) throws MetadataException, IOException {
        SchemaPageContext cxt = new SchemaPageContext();
        this.threadContexts.put(Thread.currentThread().getId(), cxt);
        if (SchemaFile.getNodeAddress(parent) < 0L) {
            throw new MetadataException(String.format("Node [%s] has no valid segment address in pbtree file.", parent.getFullPath()));
        }
        int initIndex = SchemaFile.getPageIndex(SchemaFile.getNodeAddress(parent));
        ISchemaPage initPage = this.getPageInstance(initIndex, cxt);
        initPage.getLock().readLock().lock();
        initPage = this.validatePage(initPage, parent, cxt);
        try {
            long actualSegAddr = this.getTargetSegmentAddress(SchemaFile.getNodeAddress(parent), childName, cxt);
            ICachedMNode child = this.getPageInstance(SchemaFile.getPageIndex(actualSegAddr), cxt).getAsSegmentedPage().read(SchemaFile.getSegIndex(actualSegAddr), childName);
            if (child == null && parent.isDevice()) {
                child = this.getPageInstance(SchemaFile.getPageIndex(actualSegAddr), cxt).getAsSegmentedPage().readByAlias(SchemaFile.getSegIndex(actualSegAddr), childName);
                if (child != null) {
                    ICachedMNode iCachedMNode = child;
                    return iCachedMNode;
                }
                ICachedMNode iCachedMNode = this.getChildWithAlias(parent, childName, cxt);
                return iCachedMNode;
            }
            ICachedMNode iCachedMNode = child;
            return iCachedMNode;
        }
        finally {
            initPage.getLock().readLock().unlock();
            this.pagePool.releaseReferent(cxt);
            this.threadContexts.remove(Thread.currentThread().getId(), cxt);
        }
    }

    private ICachedMNode getChildWithAlias(ICachedMNode par, String alias, SchemaPageContext cxt) throws IOException, MetadataException {
        long srtAddr = SchemaFile.getNodeAddress(par);
        ISchemaPage page = this.getPageInstance(SchemaFile.getPageIndex(srtAddr), cxt);
        if (page.getAsInternalPage() == null || page.getSubIndex() < 0) {
            return null;
        }
        String name = this.searchSubIndexAlias(page.getSubIndex(), alias, cxt);
        if (name == null) {
            return null;
        }
        return this.getTargetLeafPage(page, name, cxt).getAsSegmentedPage().read((short)0, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ICachedMNode> getChildren(ICachedMNode parent) throws MetadataException, IOException {
        final SchemaPageContext cxt = new SchemaPageContext();
        int pageIdx = SchemaFile.getPageIndex(SchemaFile.getNodeAddress(parent));
        short segId = SchemaFile.getSegIndex(SchemaFile.getNodeAddress(parent));
        ISchemaPage page = this.getPageInstance(pageIdx, cxt);
        page.getLock().readLock().lock();
        ISchemaPage pageHeldLock = page = this.validatePage(page, parent, cxt);
        try {
            while (page.getAsSegmentedPage() == null) {
                page = this.getPageInstance(SchemaFile.getPageIndex(page.getAsInternalPage().getNextSegAddress()), cxt);
            }
            final long actualSegAddr = page.getAsSegmentedPage().getNextSegAddress(segId);
            final Queue<ICachedMNode> initChildren = page.getAsSegmentedPage().getChildren(segId);
            Iterator<ICachedMNode> iterator = new Iterator<ICachedMNode>(){
                long nextSeg;
                Queue<ICachedMNode> children;
                {
                    this.nextSeg = actualSegAddr;
                    this.children = initChildren;
                }

                @Override
                public boolean hasNext() {
                    if (!this.children.isEmpty()) {
                        return true;
                    }
                    if (this.nextSeg < 0L) {
                        return false;
                    }
                    try {
                        while (this.children.isEmpty() && this.nextSeg >= 0L) {
                            boolean hasThisPage = cxt.referredPages.containsKey(SchemaFile.getPageIndex(this.nextSeg));
                            ISchemaPage nPage = BTreePageManager.this.getPageInstance(SchemaFile.getPageIndex(this.nextSeg), cxt);
                            this.children = nPage.getAsSegmentedPage().getChildren(SchemaFile.getSegIndex(this.nextSeg));
                            this.nextSeg = nPage.getAsSegmentedPage().getNextSegAddress(SchemaFile.getSegIndex(this.nextSeg));
                            if (hasThisPage) continue;
                            cxt.referredPages.remove(nPage.getPageIndex());
                            nPage.decrementAndGetRefCnt();
                        }
                    }
                    catch (IOException | MetadataException e) {
                        PageManager.logger.error(e.getMessage());
                        return false;
                    }
                    return !this.children.isEmpty();
                }

                @Override
                public ICachedMNode next() {
                    return this.children.poll();
                }
            };
            return iterator;
        }
        finally {
            pageHeldLock.getLock().readLock().unlock();
            this.pagePool.releaseReferent(cxt);
        }
    }

    private ISchemaPage getTargetLeafPage(ISchemaPage topPage, String recKey, SchemaPageContext cxt) throws IOException, MetadataException {
        cxt.treeTrace[0] = 0;
        if (topPage.getAsInternalPage() == null) {
            return topPage;
        }
        ISchemaPage curPage = topPage;
        int i = 0;
        while (curPage.getAsInternalPage() != null) {
            cxt.treeTrace[++i] = curPage.getPageIndex();
            curPage = this.getPageInstance(curPage.getAsInternalPage().getRecordByKey(recKey), cxt);
        }
        cxt.treeTrace[0] = i;
        return curPage;
    }

    @Override
    protected long getTargetSegmentAddress(long curSegAddr, String recKey, SchemaPageContext cxt) throws IOException, MetadataException {
        cxt.treeTrace[0] = 0;
        ISchemaPage curPage = this.getPageInstance(SchemaFile.getPageIndex(curSegAddr), cxt);
        if (curPage.getAsSegmentedPage() != null) {
            return curSegAddr;
        }
        int i = 0;
        while (curPage.getAsInternalPage() != null) {
            cxt.treeTrace[++i] = curPage.getPageIndex();
            curPage = this.getPageInstance(curPage.getAsInternalPage().getRecordByKey(recKey), cxt);
        }
        cxt.treeTrace[0] = i;
        return SchemaFile.getGlobalIndex(curPage.getPageIndex(), (short)0);
    }
}

