/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.BinaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeEnum;

public class RoundColumnTransformer
extends BinaryColumnTransformer {
    public RoundColumnTransformer(Type returnType, ColumnTransformer leftTransformer, ColumnTransformer rightTransformer) {
        super(returnType, leftTransformer, rightTransformer);
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount) {
        TypeEnum sourceType = this.leftTransformer.getType().getTypeEnum();
        for (int i = 0; i < positionCount; ++i) {
            if (!leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                this.transform(sourceType, leftColumn, rightColumn, builder, i);
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount, boolean[] selection) {
        TypeEnum sourceType = this.leftTransformer.getType().getTypeEnum();
        for (int i = 0; i < positionCount; ++i) {
            if (selection[i] && !leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                this.transform(sourceType, leftColumn, rightColumn, builder, i);
                continue;
            }
            builder.appendNull();
        }
    }

    private void transform(TypeEnum sourceType, Column leftColumn, Column rightColumn, ColumnBuilder builder, int i) {
        int places = this.rightTransformer.getType().getInt(rightColumn, i);
        switch (sourceType) {
            case INT32: {
                builder.writeDouble(Math.rint((double)leftColumn.getInt(i) * Math.pow(10.0, places)) / Math.pow(10.0, places));
                break;
            }
            case INT64: {
                builder.writeDouble(Math.rint((double)leftColumn.getLong(i) * Math.pow(10.0, places)) / Math.pow(10.0, places));
                break;
            }
            case FLOAT: {
                builder.writeDouble(Math.rint((double)leftColumn.getFloat(i) * Math.pow(10.0, places)) / Math.pow(10.0, places));
                break;
            }
            case DOUBLE: {
                builder.writeDouble(Math.rint(leftColumn.getDouble(i) * Math.pow(10.0, places)) / Math.pow(10.0, places));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported source dataType: %s", sourceType));
            }
        }
    }

    @Override
    protected void checkType() {
        if (!this.leftTransformer.isReturnTypeNumeric() || !this.rightTransformer.isReturnTypeNumeric()) {
            throw new UnsupportedOperationException("Unsupported Type");
        }
    }
}

