/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import java.util.List;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.MultiColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.Binary;

public class ConcatMultiColumnTransformer
extends MultiColumnTransformer {
    public ConcatMultiColumnTransformer(Type returnType, List<ColumnTransformer> columnTransformerList) {
        super(returnType, columnTransformerList);
    }

    @Override
    protected void checkType() {
    }

    @Override
    protected void doTransform(List<Column> childrenColumns, ColumnBuilder builder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            this.transform(builder, childrenColumns, i);
        }
    }

    @Override
    protected void doTransform(List<Column> childrenColumns, ColumnBuilder builder, int positionCount, boolean[] selection) {
        for (int i = 0; i < positionCount; ++i) {
            if (selection[i]) {
                this.transform(builder, childrenColumns, i);
                continue;
            }
            builder.appendNull();
        }
    }

    private void transform(ColumnBuilder builder, List<Column> childrenColumns, int i) {
        boolean isNull = true;
        int length = 0;
        for (Column childrenColumn : childrenColumns) {
            if (childrenColumn.isNull(i)) continue;
            isNull = false;
            length += childrenColumn.getBinary(i).getValues().length;
        }
        if (isNull) {
            builder.appendNull();
        } else {
            byte[] result = new byte[length];
            int index = 0;
            for (Column childrenColumn : childrenColumns) {
                if (childrenColumn.isNull(i)) continue;
                byte[] value = childrenColumn.getBinary(i).getValues();
                System.arraycopy(value, 0, result, index, value.length);
                index += value.length;
            }
            builder.writeBinary(new Binary(result));
        }
    }
}

