/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Assignments;
import org.apache.iotdb.db.queryengine.plan.relational.planner.DataOrganizationSpecification;
import org.apache.iotdb.db.queryengine.plan.relational.planner.NodeAndMappings;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolAllocator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.DeterminismEvaluator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ApplyNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AssignUniqueId;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.CorrelatedJoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.DeviceTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.EnforceSingleRowNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ExplainAnalyzeNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FilterNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.GapFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.GroupNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.InformationSchemaTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.LimitNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.LinearFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.MarkDistinctNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.OffsetNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.OutputNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.PreviousFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SemiJoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableFunctionNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableFunctionProcessorNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TopKNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TreeDeviceViewScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ValueFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PlanOptimizer;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.SymbolMapper;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;

public class UnaliasSymbolReferences
implements PlanOptimizer {
    private final Metadata metadata;

    public UnaliasSymbolReferences(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, PlanOptimizer.Context context) {
        Objects.requireNonNull(plan, "plan is null");
        Visitor visitor = new Visitor(this.metadata, SymbolMapper::symbolMapper);
        PlanAndMappings result = plan.accept(visitor, UnaliasContext.empty());
        return result.getRoot();
    }

    public NodeAndMappings reallocateSymbols(PlanNode plan, List<Symbol> fields, SymbolAllocator symbolAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(fields, "fields is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Visitor visitor = new Visitor(this.metadata, mapping -> SymbolMapper.symbolReallocator(mapping, symbolAllocator));
        PlanAndMappings result = plan.accept(visitor, UnaliasContext.empty());
        return new NodeAndMappings(result.getRoot(), SymbolMapper.symbolMapper(result.getMappings()).map(fields));
    }

    private static class Visitor
    extends PlanVisitor<PlanAndMappings, UnaliasContext> {
        private final Metadata metadata;
        private final Function<Map<Symbol, Symbol>, SymbolMapper> mapperProvider;

        public Visitor(Metadata metadata, Function<Map<Symbol, Symbol>, SymbolMapper> mapperProvider) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.mapperProvider = Objects.requireNonNull(mapperProvider, "mapperProvider is null");
        }

        private SymbolMapper symbolMapper(Map<Symbol, Symbol> mappings) {
            return this.mapperProvider.apply(mappings);
        }

        @Override
        public PlanAndMappings visitPlan(PlanNode node, UnaliasContext context) {
            throw new UnsupportedOperationException("Unsupported plan node " + node.getClass().getSimpleName());
        }

        @Override
        public PlanAndMappings visitAggregation(AggregationNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getChild().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            AggregationNode rewrittenAggregation = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenAggregation, mapping);
        }

        @Override
        public PlanAndMappings visitTreeDeviceViewScan(TreeDeviceViewScanNode node, UnaliasContext context) {
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(context.getCorrelationMapping());
            SymbolMapper mapper = this.symbolMapper(mapping);
            List<Symbol> newOutputs = mapper.map(node.getOutputSymbols());
            HashMap<Symbol, ColumnSchema> newAssignments = new HashMap<Symbol, ColumnSchema>();
            node.getAssignments().forEach((symbol, handle) -> {
                Symbol newSymbol = mapper.map((Symbol)symbol);
                newAssignments.put(newSymbol, (ColumnSchema)handle);
            });
            return new PlanAndMappings(new TreeDeviceViewScanNode(node.getPlanNodeId(), node.getQualifiedObjectName(), newOutputs, newAssignments, node.getDeviceEntries(), node.getIdAndAttributeIndexMap(), node.getScanOrder(), node.getTimePredicate().orElse(null), node.getPushDownPredicate(), node.getPushDownLimit(), node.getPushDownOffset(), node.isPushLimitToEachDevice(), node.containsNonAlignedDevice(), node.getTreeDBName(), node.getMeasurementColumnNameMap()), mapping);
        }

        @Override
        public PlanAndMappings visitDeviceTableScan(DeviceTableScanNode node, UnaliasContext context) {
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(context.getCorrelationMapping());
            SymbolMapper mapper = this.symbolMapper(mapping);
            List<Symbol> newOutputs = mapper.map(node.getOutputSymbols());
            HashMap<Symbol, ColumnSchema> newAssignments = new HashMap<Symbol, ColumnSchema>();
            node.getAssignments().forEach((symbol, handle) -> {
                Symbol newSymbol = mapper.map((Symbol)symbol);
                newAssignments.put(newSymbol, (ColumnSchema)handle);
            });
            return new PlanAndMappings(new DeviceTableScanNode(node.getPlanNodeId(), node.getQualifiedObjectName(), newOutputs, newAssignments, node.getDeviceEntries(), node.getIdAndAttributeIndexMap(), node.getScanOrder(), node.getTimePredicate().orElse(null), node.getPushDownPredicate(), node.getPushDownLimit(), node.getPushDownOffset(), node.isPushLimitToEachDevice(), node.containsNonAlignedDevice()), mapping);
        }

        @Override
        public PlanAndMappings visitInformationSchemaTableScan(InformationSchemaTableScanNode node, UnaliasContext context) {
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(context.getCorrelationMapping());
            SymbolMapper mapper = this.symbolMapper(mapping);
            List<Symbol> newOutputs = mapper.map(node.getOutputSymbols());
            HashMap<Symbol, ColumnSchema> newAssignments = new HashMap<Symbol, ColumnSchema>();
            node.getAssignments().forEach((symbol, handle) -> {
                Symbol newSymbol = mapper.map((Symbol)symbol);
                newAssignments.put(newSymbol, (ColumnSchema)handle);
            });
            return new PlanAndMappings(new InformationSchemaTableScanNode(node.getPlanNodeId(), node.getQualifiedObjectName(), newOutputs, newAssignments, node.getPushDownPredicate(), node.getPushDownLimit(), node.getPushDownOffset()), mapping);
        }

        @Override
        public PlanAndMappings visitGapFill(GapFillNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getChild().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            List<Symbol> groupingKeys = Collections.emptyList();
            if (!node.getGapFillGroupingKeys().isEmpty()) {
                groupingKeys = mapper.mapAndDistinct(node.getGapFillGroupingKeys());
            }
            return new PlanAndMappings(new GapFillNode(node.getPlanNodeId(), rewrittenSource.getRoot(), node.getStartTime(), node.getEndTime(), node.getMonthDuration(), node.getNonMonthDuration(), mapper.map(node.getGapFillColumn()), groupingKeys), mapping);
        }

        @Override
        public PlanAndMappings visitPreviousFill(PreviousFillNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getChild().accept(this, context);
            if (node.getHelperColumn().isPresent() || node.getGroupingKeys().isPresent()) {
                HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
                SymbolMapper mapper = this.symbolMapper(mapping);
                Symbol helperColumn = null;
                if (node.getHelperColumn().isPresent()) {
                    helperColumn = mapper.map(node.getHelperColumn().get());
                }
                List<Symbol> groupingKeys = null;
                if (node.getGroupingKeys().isPresent()) {
                    groupingKeys = mapper.mapAndDistinct(node.getGroupingKeys().get());
                }
                return new PlanAndMappings(new PreviousFillNode(node.getPlanNodeId(), rewrittenSource.getRoot(), node.getTimeBound().orElse(null), helperColumn, groupingKeys), mapping);
            }
            return new PlanAndMappings(node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)rewrittenSource.getRoot())), rewrittenSource.getMappings());
        }

        @Override
        public PlanAndMappings visitLinearFill(LinearFillNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getChild().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            List<Symbol> groupingKeys = null;
            if (node.getGroupingKeys().isPresent()) {
                groupingKeys = mapper.mapAndDistinct(node.getGroupingKeys().get());
            }
            return new PlanAndMappings(new LinearFillNode(node.getPlanNodeId(), rewrittenSource.getRoot(), mapper.map(node.getHelperColumn()), groupingKeys), mapping);
        }

        @Override
        public PlanAndMappings visitValueFill(ValueFillNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getChild().accept(this, context);
            return new PlanAndMappings(node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)rewrittenSource.getRoot())), rewrittenSource.getMappings());
        }

        @Override
        public PlanAndMappings visitOffset(OffsetNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getChild().accept(this, context);
            return new PlanAndMappings(node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)rewrittenSource.getRoot())), rewrittenSource.getMappings());
        }

        @Override
        public PlanAndMappings visitExplainAnalyze(ExplainAnalyzeNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getChild().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            List<Symbol> newChildPermittedOutputs = mapper.map(node.getChildPermittedOutputs());
            return new PlanAndMappings(new ExplainAnalyzeNode(node.getPlanNodeId(), rewrittenSource.getRoot(), node.isVerbose(), node.getQueryId(), node.getTimeout(), node.getOutputSymbols().get(0), newChildPermittedOutputs), mapping);
        }

        @Override
        public PlanAndMappings visitMarkDistinct(MarkDistinctNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getChild().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            Symbol newMarkerSymbol = mapper.map(node.getMarkerSymbol());
            List<Symbol> newDistinctSymbols = mapper.mapAndDistinct(node.getDistinctSymbols());
            Optional<Symbol> newHashSymbol = node.getHashSymbol().map(mapper::map);
            return new PlanAndMappings(new MarkDistinctNode(node.getPlanNodeId(), rewrittenSource.getRoot(), newMarkerSymbol, newDistinctSymbols, newHashSymbol), mapping);
        }

        @Override
        public PlanAndMappings visitLimit(LimitNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getChild().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            LimitNode rewrittenLimit = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenLimit, mapping);
        }

        @Override
        public PlanAndMappings visitTopK(TopKNode node, UnaliasContext context) {
            List<PlanAndMappings> rewrittenSources = node.getChildren().stream().map(child -> child.accept(this, context)).collect(Collectors.toList());
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>();
            rewrittenSources.forEach(map -> map.getMappings().forEach(mapping::putIfAbsent));
            SymbolMapper mapper = this.symbolMapper(mapping);
            TopKNode rewrittenTopN = mapper.map(node, rewrittenSources.stream().map(PlanAndMappings::getRoot).collect(Collectors.toList()));
            return new PlanAndMappings(rewrittenTopN, mapping);
        }

        @Override
        public PlanAndMappings visitSort(SortNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getChild().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            OrderingScheme newOrderingScheme = mapper.map(node.getOrderingScheme());
            return new PlanAndMappings(new SortNode(node.getPlanNodeId(), rewrittenSource.getRoot(), newOrderingScheme, node.isPartial(), node.isOrderByAllIdsAndTime()), mapping);
        }

        @Override
        public PlanAndMappings visitGroup(GroupNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getChild().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            OrderingScheme newOrderingScheme = mapper.map(node.getOrderingScheme());
            return new PlanAndMappings(new GroupNode(node.getPlanNodeId(), rewrittenSource.getRoot(), newOrderingScheme, node.getPartitionKeyCount()), mapping);
        }

        @Override
        public PlanAndMappings visitFilter(FilterNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getChild().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            Expression newPredicate = mapper.map(node.getPredicate());
            return new PlanAndMappings(new FilterNode(node.getPlanNodeId(), rewrittenSource.getRoot(), newPredicate), mapping);
        }

        @Override
        public PlanAndMappings visitProject(ProjectNode node, UnaliasContext context) {
            ImmutableSet symbolsInCorrelationMapping;
            ImmutableSet symbolsInSourceMapping;
            PlanAndMappings rewrittenSource = node.getChild().accept(this, context);
            Assignments assignments = node.getAssignments();
            Set<Symbol> newlyAssignedSymbols = assignments.filter(output -> !assignments.isIdentity((Symbol)output)).getSymbols();
            boolean ambiguousSymbolsPresent = !Sets.intersection(newlyAssignedSymbols, (Set)Sets.difference((Set)(symbolsInSourceMapping = ImmutableSet.builder().addAll(rewrittenSource.getMappings().keySet()).addAll(rewrittenSource.getMappings().values()).build()), (Set)(symbolsInCorrelationMapping = ImmutableSet.builder().addAll(context.getCorrelationMapping().keySet()).addAll(context.getCorrelationMapping().values()).build()))).isEmpty();
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            ImmutableList.Builder rewrittenAssignments = ImmutableList.builder();
            for (Map.Entry<Symbol, Expression> assignment : node.getAssignments().entrySet()) {
                rewrittenAssignments.add(new AbstractMap.SimpleEntry<Symbol, Expression>(ambiguousSymbolsPresent ? assignment.getKey() : mapper.map(assignment.getKey()), mapper.map(assignment.getValue())));
            }
            Map deduplicateAssignments = (Map)rewrittenAssignments.build().stream().distinct().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<Symbol, Symbol> newMapping = this.mappingFromAssignments(deduplicateAssignments, ambiguousSymbolsPresent);
            HashMap<Symbol, Symbol> outputMapping = new HashMap<Symbol, Symbol>();
            outputMapping.putAll(ambiguousSymbolsPresent ? context.getCorrelationMapping() : mapping);
            outputMapping.putAll(newMapping);
            mapper = this.symbolMapper(outputMapping);
            Assignments.Builder newAssignments = Assignments.builder();
            for (Map.Entry assignment : deduplicateAssignments.entrySet()) {
                newAssignments.put(mapper.map((Symbol)assignment.getKey()), (Expression)assignment.getValue());
            }
            return new PlanAndMappings(new ProjectNode(node.getPlanNodeId(), rewrittenSource.getRoot(), newAssignments.build()), outputMapping);
        }

        private Map<Symbol, Symbol> mappingFromAssignments(Map<Symbol, Expression> assignments, boolean ambiguousSymbolsPresent) {
            HashMap<Symbol, Symbol> newMapping = new HashMap<Symbol, Symbol>();
            HashMap<Expression, Symbol> inputsToOutputs = new HashMap<Expression, Symbol>();
            for (Map.Entry<Symbol, Expression> assignment : assignments.entrySet()) {
                Expression expression = assignment.getValue();
                if (expression instanceof SymbolReference && !ambiguousSymbolsPresent) {
                    Symbol value = Symbol.from(expression);
                    if (assignment.getKey().equals(value)) continue;
                    newMapping.put(assignment.getKey(), value);
                    continue;
                }
                if (!DeterminismEvaluator.isDeterministic(expression) || expression instanceof NullLiteral) continue;
                Symbol previous = (Symbol)inputsToOutputs.get(expression);
                if (previous == null) {
                    inputsToOutputs.put(expression, assignment.getKey());
                    continue;
                }
                newMapping.put(assignment.getKey(), previous);
            }
            return newMapping;
        }

        @Override
        public PlanAndMappings visitOutput(OutputNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getChild().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            List<Symbol> newOutputs = mapper.map(node.getOutputSymbols());
            return new PlanAndMappings(new OutputNode(node.getPlanNodeId(), rewrittenSource.getRoot(), node.getColumnNames(), newOutputs), mapping);
        }

        @Override
        public PlanAndMappings visitEnforceSingleRow(EnforceSingleRowNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            return new PlanAndMappings(node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)rewrittenSource.getRoot())), rewrittenSource.getMappings());
        }

        @Override
        public PlanAndMappings visitApply(ApplyNode node, UnaliasContext context) {
            PlanAndMappings rewrittenInput = node.getInput().accept(this, context);
            HashMap<Symbol, Symbol> inputMapping = new HashMap<Symbol, Symbol>(rewrittenInput.getMappings());
            SymbolMapper mapper = this.symbolMapper(inputMapping);
            List<Symbol> rewrittenCorrelation = mapper.mapAndDistinct(node.getCorrelation());
            ImmutableSet correlationSymbols = ImmutableSet.copyOf(node.getCorrelation());
            HashMap<Symbol, Symbol> correlationMapping = new HashMap<Symbol, Symbol>();
            for (Map.Entry entry : inputMapping.entrySet()) {
                if (!correlationSymbols.contains(entry.getKey())) continue;
                correlationMapping.put((Symbol)entry.getKey(), mapper.map((Symbol)entry.getKey()));
            }
            HashMap<Symbol, Symbol> mappingForSubquery = new HashMap<Symbol, Symbol>();
            mappingForSubquery.putAll(context.getCorrelationMapping());
            mappingForSubquery.putAll(correlationMapping);
            PlanAndMappings rewrittenSubquery = node.getSubquery().accept(this, new UnaliasContext(mappingForSubquery));
            HashMap<Symbol, Symbol> resultMapping = new HashMap<Symbol, Symbol>();
            resultMapping.putAll(rewrittenInput.getMappings());
            resultMapping.putAll(rewrittenSubquery.getMappings());
            mapper = this.symbolMapper(resultMapping);
            ImmutableList.Builder rewrittenAssignments = ImmutableList.builder();
            for (Map.Entry<Symbol, ApplyNode.SetExpression> assignment : node.getSubqueryAssignments().entrySet()) {
                rewrittenAssignments.add(new AbstractMap.SimpleEntry<Symbol, ApplyNode.SetExpression>(mapper.map(assignment.getKey()), mapper.map(assignment.getValue())));
            }
            Map deduplicateAssignments = (Map)rewrittenAssignments.build().stream().distinct().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            mapper = this.symbolMapper(resultMapping);
            ImmutableMap.Builder newAssignments = ImmutableMap.builder();
            for (Map.Entry assignment : deduplicateAssignments.entrySet()) {
                newAssignments.put((Object)mapper.map((Symbol)assignment.getKey()), (Object)((ApplyNode.SetExpression)assignment.getValue()));
            }
            return new PlanAndMappings(new ApplyNode(node.getPlanNodeId(), rewrittenInput.getRoot(), rewrittenSubquery.getRoot(), (Map<Symbol, ApplyNode.SetExpression>)newAssignments.buildOrThrow(), rewrittenCorrelation, node.getOriginSubquery()), resultMapping);
        }

        @Override
        public PlanAndMappings visitCorrelatedJoin(CorrelatedJoinNode node, UnaliasContext context) {
            PlanAndMappings rewrittenInput = node.getInput().accept(this, context);
            HashMap<Symbol, Symbol> inputMapping = new HashMap<Symbol, Symbol>(rewrittenInput.getMappings());
            SymbolMapper mapper = this.symbolMapper(inputMapping);
            List<Symbol> rewrittenCorrelation = mapper.mapAndDistinct(node.getCorrelation());
            ImmutableSet correlationSymbols = ImmutableSet.copyOf(node.getCorrelation());
            HashMap<Symbol, Symbol> correlationMapping = new HashMap<Symbol, Symbol>();
            for (Map.Entry entry : inputMapping.entrySet()) {
                if (!correlationSymbols.contains(entry.getKey())) continue;
                correlationMapping.put((Symbol)entry.getKey(), mapper.map((Symbol)entry.getKey()));
            }
            HashMap<Symbol, Symbol> mappingForSubquery = new HashMap<Symbol, Symbol>();
            mappingForSubquery.putAll(context.getCorrelationMapping());
            mappingForSubquery.putAll(correlationMapping);
            PlanAndMappings rewrittenSubquery = node.getSubquery().accept(this, new UnaliasContext(mappingForSubquery));
            HashMap<Symbol, Symbol> resultMapping = new HashMap<Symbol, Symbol>();
            resultMapping.putAll(rewrittenInput.getMappings());
            resultMapping.putAll(rewrittenSubquery.getMappings());
            mapper = this.symbolMapper(resultMapping);
            Expression newFilter = mapper.map(node.getFilter());
            return new PlanAndMappings(new CorrelatedJoinNode(node.getPlanNodeId(), rewrittenInput.getRoot(), rewrittenSubquery.getRoot(), rewrittenCorrelation, node.getJoinType(), newFilter, node.getOriginSubquery()), resultMapping);
        }

        @Override
        public PlanAndMappings visitJoin(JoinNode node, UnaliasContext context) {
            PlanAndMappings rewrittenLeft = node.getLeftChild().accept(this, context);
            PlanAndMappings rewrittenRight = node.getRightChild().accept(this, context);
            HashMap<Symbol, Symbol> unifiedMapping = new HashMap<Symbol, Symbol>();
            unifiedMapping.putAll(rewrittenLeft.getMappings());
            unifiedMapping.putAll(rewrittenRight.getMappings());
            SymbolMapper mapper = this.symbolMapper(unifiedMapping);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JoinNode.EquiJoinClause clause2 : node.getCriteria()) {
                builder.add((Object)new JoinNode.EquiJoinClause(mapper.map(clause2.getLeft()), mapper.map(clause2.getRight())));
            }
            ImmutableList newCriteria = builder.build();
            Optional<Expression> newFilter = node.getFilter().map(mapper::map);
            HashMap newMapping = new HashMap();
            if (node.getJoinType() == JoinNode.JoinType.INNER) {
                newCriteria.forEach(clause -> newMapping.put(clause.getRight(), clause.getLeft()));
            }
            HashMap<Symbol, Symbol> outputMapping = new HashMap<Symbol, Symbol>();
            outputMapping.putAll(unifiedMapping);
            outputMapping.putAll(newMapping);
            mapper = this.symbolMapper(outputMapping);
            List<Symbol> canonicalOutputs = mapper.mapAndDistinct(node.getOutputSymbols());
            List newLeftOutputSymbols = (List)canonicalOutputs.stream().filter(rewrittenLeft.getRoot().getOutputSymbols()::contains).collect(ImmutableList.toImmutableList());
            List newRightOutputSymbols = (List)canonicalOutputs.stream().filter(rewrittenRight.getRoot().getOutputSymbols()::contains).collect(ImmutableList.toImmutableList());
            return new PlanAndMappings(new JoinNode(node.getPlanNodeId(), node.getJoinType(), rewrittenLeft.getRoot(), rewrittenRight.getRoot(), (List<JoinNode.EquiJoinClause>)newCriteria, node.getAsofCriteria(), newLeftOutputSymbols, newRightOutputSymbols, newFilter, node.isSpillable()), outputMapping);
        }

        @Override
        public PlanAndMappings visitSemiJoin(SemiJoinNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            PlanAndMappings rewrittenFilteringSource = node.getFilteringSource().accept(this, context);
            HashMap<Symbol, Symbol> outputMapping = new HashMap<Symbol, Symbol>();
            outputMapping.putAll(rewrittenSource.getMappings());
            outputMapping.putAll(rewrittenFilteringSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(outputMapping);
            Symbol newSourceJoinSymbol = mapper.map(node.getSourceJoinSymbol());
            Symbol newFilteringSourceJoinSymbol = mapper.map(node.getFilteringSourceJoinSymbol());
            Symbol newSemiJoinOutput = mapper.map(node.getSemiJoinOutput());
            return new PlanAndMappings(new SemiJoinNode(node.getPlanNodeId(), rewrittenSource.getRoot(), rewrittenFilteringSource.getRoot(), newSourceJoinSymbol, newFilteringSourceJoinSymbol, newSemiJoinOutput), outputMapping);
        }

        @Override
        public PlanAndMappings visitAssignUniqueId(AssignUniqueId node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getChild().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            Symbol newUnique = mapper.map(node.getIdColumn());
            return new PlanAndMappings(new AssignUniqueId(node.getPlanNodeId(), rewrittenSource.getRoot(), newUnique), mapping);
        }

        @Override
        public PlanAndMappings visitTableFunction(TableFunctionNode node, UnaliasContext context) {
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(context.getCorrelationMapping());
            SymbolMapper mapper = this.symbolMapper(mapping);
            List<Symbol> newProperOutputs = mapper.map(node.getProperOutputs());
            ImmutableList.Builder newSources = ImmutableList.builder();
            ImmutableList.Builder newTableArgumentProperties = ImmutableList.builder();
            for (int i = 0; i < node.getChildren().size(); ++i) {
                PlanAndMappings newSource = node.getChildren().get(i).accept(this, context);
                newSources.add((Object)newSource.getRoot());
                SymbolMapper inputMapper = this.symbolMapper(new HashMap<Symbol, Symbol>(newSource.getMappings()));
                TableFunctionNode.TableArgumentProperties properties = node.getTableArgumentProperties().get(i);
                Optional<DataOrganizationSpecification> newSpecification = properties.getDataOrganizationSpecification().map(inputMapper::mapAndDistinct);
                TableFunctionNode.PassThroughSpecification newPassThroughSpecification = new TableFunctionNode.PassThroughSpecification(properties.getPassThroughSpecification().isDeclaredAsPassThrough(), (List)properties.getPassThroughSpecification().getColumns().stream().map(column -> new TableFunctionNode.PassThroughColumn(inputMapper.map(column.getSymbol()), column.isPartitioningColumn())).collect(ImmutableList.toImmutableList()));
                newTableArgumentProperties.add((Object)new TableFunctionNode.TableArgumentProperties(properties.getArgumentName(), properties.isRowSemantics(), newPassThroughSpecification, inputMapper.map(properties.getRequiredColumns()), newSpecification, properties.isRequireRecordSnapshot()));
            }
            return new PlanAndMappings(new TableFunctionNode(node.getPlanNodeId(), node.getName(), node.getTableFunctionHandle(), newProperOutputs, (List<PlanNode>)newSources.build(), (List<TableFunctionNode.TableArgumentProperties>)newTableArgumentProperties.build()), mapping);
        }

        @Override
        public PlanAndMappings visitTableFunctionProcessor(TableFunctionProcessorNode node, UnaliasContext context) {
            if (node.getChildren().isEmpty()) {
                HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(context.getCorrelationMapping());
                SymbolMapper mapper = this.symbolMapper(mapping);
                return new PlanAndMappings(new TableFunctionProcessorNode(node.getPlanNodeId(), node.getName(), mapper.map(node.getProperOutputs()), Optional.empty(), Optional.empty(), (List<Symbol>)ImmutableList.of(), Optional.empty(), node.isRowSemantic(), node.getTableFunctionHandle(), node.isRequireRecordSnapshot()), mapping);
            }
            PlanAndMappings rewrittenSource = node.getChild().accept(this, context);
            HashMap<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>(rewrittenSource.getMappings());
            SymbolMapper mapper = this.symbolMapper(mapping);
            Optional<TableFunctionNode.PassThroughSpecification> newPassThroughSpecification = node.getPassThroughSpecification().map(passThroughSpecification -> new TableFunctionNode.PassThroughSpecification(passThroughSpecification.isDeclaredAsPassThrough(), (List)passThroughSpecification.getColumns().stream().map(column -> new TableFunctionNode.PassThroughColumn(mapper.map(column.getSymbol()), column.isPartitioningColumn())).collect(ImmutableList.toImmutableList())));
            List<Symbol> newRequiredSymbols = mapper.map(node.getRequiredSymbols());
            Optional<DataOrganizationSpecification> newSpecification = node.getDataOrganizationSpecification().map(mapper::mapAndDistinct);
            TableFunctionProcessorNode rewrittenTableFunctionProcessor = new TableFunctionProcessorNode(node.getPlanNodeId(), node.getName(), mapper.map(node.getProperOutputs()), Optional.of(rewrittenSource.getRoot()), newPassThroughSpecification, newRequiredSymbols, newSpecification, node.isRowSemantic(), node.getTableFunctionHandle(), node.isRequireRecordSnapshot());
            return new PlanAndMappings(rewrittenTableFunctionProcessor, mapping);
        }
    }

    private static class UnaliasContext {
        private final Map<Symbol, Symbol> correlationMapping;

        public UnaliasContext(Map<Symbol, Symbol> correlationMapping) {
            this.correlationMapping = Objects.requireNonNull(correlationMapping, "correlationMapping is null");
        }

        public static UnaliasContext empty() {
            return new UnaliasContext((Map<Symbol, Symbol>)ImmutableMap.of());
        }

        public Map<Symbol, Symbol> getCorrelationMapping() {
            return this.correlationMapping;
        }
    }

    private static class PlanAndMappings {
        private final PlanNode root;
        private final Map<Symbol, Symbol> mappings;

        public PlanAndMappings(PlanNode root, Map<Symbol, Symbol> mappings) {
            this.root = Objects.requireNonNull(root, "root is null");
            this.mappings = ImmutableMap.copyOf(Objects.requireNonNull(mappings, "mappings is null"));
        }

        public PlanNode getRoot() {
            return this.root;
        }

        public Map<Symbol, Symbol> getMappings() {
            return this.mappings;
        }
    }
}

