/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.planner.DataOrganizationSpecification;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.CorrelatedJoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.DeviceTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.GroupNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SemiJoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.StreamSortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableFunctionProcessorNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TopKNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PlanOptimizer;

public class ParallelizeGrouping
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, PlanOptimizer.Context context) {
        if (!context.getAnalysis().isQuery()) {
            return plan;
        }
        return plan.accept(new Rewriter(context.getAnalysis()), new Context(null, 0));
    }

    private static class Rewriter
    extends PlanVisitor<PlanNode, Context> {
        private final Analysis analysis;

        public Rewriter(Analysis analysis) {
            this.analysis = analysis;
        }

        @Override
        public PlanNode visitPlan(PlanNode node, Context context) {
            PlanNode newNode = node.clone();
            for (PlanNode child : node.getChildren()) {
                newNode.addChild(child.accept(this, context));
            }
            return newNode;
        }

        private void checkPrefixMatch(Context context, List<Symbol> childOrder) {
            if (context.canSkip()) {
                return;
            }
            if (context.partitionKeyCount > childOrder.size()) {
                context.canOptimized = CanOptimized.TO_SORT;
                return;
            }
            OrderingScheme prefix = context.sortKey;
            for (int i = 0; i < context.partitionKeyCount; ++i) {
                Symbol rhs;
                Symbol lhs = prefix.getOrderBy().get(i);
                if (lhs.equals(rhs = childOrder.get(i))) continue;
                context.canOptimized = CanOptimized.TO_SORT;
                return;
            }
            context.canOptimized = CanOptimized.ENABLE_PARALLEL;
        }

        @Override
        public PlanNode visitGroup(GroupNode node, Context context) {
            this.checkPrefixMatch(context, node.getOrderingScheme().getOrderBy().subList(0, node.getPartitionKeyCount()));
            Context newContext = new Context(node.getOrderingScheme(), node.getPartitionKeyCount());
            PlanNode child = node.getChild().accept(this, newContext);
            switch (newContext.canOptimized) {
                case ENABLE_PARALLEL: {
                    GroupNode newNode = (GroupNode)node.clone();
                    newNode.addChild(child);
                    return newNode;
                }
            }
            return new SortNode(node.getPlanNodeId(), child, node.getOrderingScheme(), false, false);
        }

        @Override
        public PlanNode visitSort(SortNode node, Context context) {
            this.checkPrefixMatch(context, node.getOrderingScheme().getOrderBy());
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public PlanNode visitStreamSort(StreamSortNode node, Context context) {
            this.checkPrefixMatch(context, node.getOrderingScheme().getOrderBy());
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public PlanNode visitTopK(TopKNode node, Context context) {
            this.checkPrefixMatch(context, node.getOrderingScheme().getOrderBy());
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public PlanNode visitJoin(JoinNode node, Context context) {
            context.canOptimized = CanOptimized.TO_SORT;
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public PlanNode visitCorrelatedJoin(CorrelatedJoinNode node, Context context) {
            context.canOptimized = CanOptimized.TO_SORT;
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, Context context) {
            context.canOptimized = CanOptimized.TO_SORT;
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public PlanNode visitTableFunctionProcessor(TableFunctionProcessorNode node, Context context) {
            if (!context.canSkip()) {
                if (node.getChildren().isEmpty()) {
                    context.canOptimized = CanOptimized.TO_SORT;
                    return node;
                }
                Optional<DataOrganizationSpecification> dataOrganizationSpecification = node.getDataOrganizationSpecification();
                if (!dataOrganizationSpecification.isPresent()) {
                    context.canOptimized = CanOptimized.TO_SORT;
                } else {
                    this.checkPrefixMatch(context, dataOrganizationSpecification.get().getPartitionBy());
                }
            }
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public PlanNode visitDeviceTableScan(DeviceTableScanNode node, Context context) {
            if (!context.canSkip()) {
                OrderingScheme sortKey = context.sortKey;
                Map<Symbol, ColumnSchema> tableColumnSchema = this.analysis.getTableColumnSchema(node.getQualifiedObjectName());
                Set tagSymbols = tableColumnSchema.entrySet().stream().filter(entry -> ((ColumnSchema)entry.getValue()).getColumnCategory() == TsTableColumnCategory.TAG).map(Map.Entry::getKey).collect(Collectors.toSet());
                block4: for (int i = 0; i < context.partitionKeyCount; ++i) {
                    Symbol symbol = sortKey.getOrderBy().get(i);
                    if (!tableColumnSchema.containsKey(symbol)) {
                        context.canOptimized = CanOptimized.TO_SORT;
                        return node;
                    }
                    switch (tableColumnSchema.get(symbol).getColumnCategory()) {
                        case TAG: {
                            tagSymbols.remove(symbol);
                            continue block4;
                        }
                        case ATTRIBUTE: {
                            continue block4;
                        }
                        default: {
                            context.canOptimized = CanOptimized.TO_SORT;
                            return node;
                        }
                    }
                }
                if (!tagSymbols.isEmpty()) {
                    context.canOptimized = CanOptimized.TO_SORT;
                } else {
                    context.canOptimized = CanOptimized.ENABLE_PARALLEL;
                }
            }
            return node;
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, Context context) {
            this.checkPrefixMatch(context, node.getGroupingKeys());
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public PlanNode visitAggregationTableScan(AggregationTableScanNode node, Context context) {
            this.checkPrefixMatch(context, node.getGroupingKeys());
            return node;
        }
    }

    private static class Context {
        private final OrderingScheme sortKey;
        private final int partitionKeyCount;
        private CanOptimized canOptimized = CanOptimized.PENDING;

        private Context(OrderingScheme sortKey, int partitionKeyCount) {
            this.sortKey = sortKey;
            this.partitionKeyCount = partitionKeyCount;
        }

        private boolean canSkip() {
            return this.sortKey == null || this.canOptimized != CanOptimized.PENDING;
        }
    }

    protected static enum CanOptimized {
        ENABLE_PARALLEL,
        TO_SORT,
        PENDING;

    }
}

