/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterTopology {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterTopology.class);
    private final Integer myself;
    private final AtomicReference<Map<Integer, TDataNodeLocation>> dataNodes;
    private final AtomicReference<Map<Integer, Set<Integer>>> topologyMap;
    private final AtomicBoolean isPartitioned = new AtomicBoolean();

    public static ClusterTopology getInstance() {
        return ClusterTopologyHolder.INSTANCE;
    }

    public TRegionReplicaSet getValidatedReplicaSet(TRegionReplicaSet origin) {
        if (!this.isPartitioned.get() || origin == null) {
            return origin;
        }
        Set<Integer> reachableToMyself = Collections.unmodifiableSet(this.topologyMap.get().get(this.myself));
        ArrayList<TDataNodeLocation> locations = new ArrayList<TDataNodeLocation>();
        for (TDataNodeLocation location : origin.getDataNodeLocations()) {
            if (!reachableToMyself.contains(location.getDataNodeId())) continue;
            locations.add(location);
        }
        return new TRegionReplicaSet(origin.getRegionId(), locations);
    }

    public <T> Set<Map.Entry<TRegionReplicaSet, T>> filterReachableCandidates(Set<Map.Entry<TRegionReplicaSet, T>> input) {
        if (!this.isPartitioned.get()) {
            return input;
        }
        List<TRegionReplicaSet> allSets = input.stream().map(Map.Entry::getKey).collect(Collectors.toList());
        List<TRegionReplicaSet> candidates = this.getReachableCandidates(allSets);
        HashMap newMap = new HashMap();
        candidates.forEach(set -> newMap.put(set.getRegionId(), set));
        HashMap<TRegionReplicaSet, T> candidateMap = new HashMap<TRegionReplicaSet, T>();
        for (Map.Entry<TRegionReplicaSet, T> entry : input) {
            TConsensusGroupId gid = entry.getKey().getRegionId();
            TRegionReplicaSet replicaSet = (TRegionReplicaSet)newMap.get(gid);
            if (replicaSet == null) continue;
            candidateMap.put(replicaSet, entry.getValue());
        }
        return candidateMap.entrySet();
    }

    private List<TRegionReplicaSet> getReachableCandidates(List<TRegionReplicaSet> all) {
        if (!this.isPartitioned.get() || all == null || all.isEmpty()) {
            return all;
        }
        if (all.stream().anyMatch(set -> set.getDataNodeLocationsSize() == 0)) {
            return Collections.emptyList();
        }
        Map<Integer, Set<Integer>> topologyMapCurrent = Collections.unmodifiableMap(this.topologyMap.get());
        ArrayList<Integer> dataNodeCandidates = new ArrayList<Integer>();
        for (Integer datanode : topologyMapCurrent.keySet()) {
            boolean reachableToAllSets = true;
            Set<Integer> datanodeReachableToThis = topologyMapCurrent.get(datanode);
            for (TRegionReplicaSet replicaSet : all) {
                List replicaNodeLocations = replicaSet.getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toList());
                replicaNodeLocations.retainAll(datanodeReachableToThis);
                reachableToAllSets = !replicaNodeLocations.isEmpty();
            }
            if (!reachableToAllSets) continue;
            dataNodeCandidates.add(datanode);
        }
        ArrayList<TRegionReplicaSet> reachableSetCandidates = new ArrayList<TRegionReplicaSet>();
        for (TRegionReplicaSet replicaSet : all) {
            List commonLocations = replicaSet.getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toList());
            commonLocations.retainAll(dataNodeCandidates);
            if (commonLocations.isEmpty()) continue;
            List validLocations = commonLocations.stream().map(this.dataNodes.get()::get).collect(Collectors.toList());
            TRegionReplicaSet validCandidate = new TRegionReplicaSet(replicaSet.getRegionId(), validLocations);
            reachableSetCandidates.add(validCandidate);
        }
        return reachableSetCandidates;
    }

    public void updateTopology(Map<Integer, TDataNodeLocation> dataNodes, Map<Integer, Set<Integer>> latestTopology) {
        if (!latestTopology.equals(this.topologyMap.get())) {
            LOGGER.info("[Topology] latest view from config-node: {}", latestTopology);
        }
        this.dataNodes.set(dataNodes);
        this.topologyMap.set(latestTopology);
        if (latestTopology.get(this.myself) == null || latestTopology.get(this.myself).isEmpty()) {
            this.isPartitioned.set(false);
        } else {
            this.isPartitioned.set(latestTopology.get(this.myself).size() != latestTopology.keySet().size());
        }
        if (this.isPartitioned.get() && LOGGER.isDebugEnabled()) {
            HashSet<Integer> allDataLocations = new HashSet<Integer>(latestTopology.keySet());
            allDataLocations.removeAll((Collection)latestTopology.get(this.myself));
            String partitioned = allDataLocations.stream().collect(StringBuilder::new, (sb, id) -> sb.append(",").append(id), StringBuilder::append).toString();
            LOGGER.debug("This DataNode {} is partitioned with [{}]", (Object)this.myself, (Object)partitioned);
        }
    }

    private ClusterTopology() {
        this.myself = IoTDBDescriptor.getInstance().getConfig().generateLocalDataNodeLocation().getDataNodeId();
        this.isPartitioned.set(false);
        this.topologyMap = new AtomicReference(Collections.emptyMap());
        this.dataNodes = new AtomicReference(Collections.emptyMap());
    }

    private static class ClusterTopologyHolder {
        private static final ClusterTopology INSTANCE = new ClusterTopology();

        private ClusterTopologyHolder() {
        }
    }
}

