/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.last;

import com.google.common.base.Preconditions;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.AbstractUpdateLastCacheOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TreeDeviceSchemaCacheManager;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;

public class UpdateLastCacheOperator
extends AbstractUpdateLastCacheOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(UpdateLastCacheOperator.class);
    private final MeasurementPath fullPath;
    protected final String dataType;

    public UpdateLastCacheOperator(OperatorContext operatorContext, Operator child, MeasurementPath fullPath, TSDataType dataType, TreeDeviceSchemaCacheManager treeDeviceSchemaCacheManager, boolean needUpdateCache, boolean isNeedUpdateNullEntry) {
        super(operatorContext, child, treeDeviceSchemaCacheManager, needUpdateCache, isNeedUpdateNullEntry);
        this.fullPath = fullPath;
        this.dataType = dataType.name();
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock res = this.child.nextWithTimer();
        if (res == null) {
            return null;
        }
        if (res.isEmpty()) {
            return LAST_QUERY_EMPTY_TSBLOCK;
        }
        Preconditions.checkArgument((res.getPositionCount() == 1 ? 1 : 0) != 0, (Object)"last query result should only have one record");
        if (res.getColumn(0).isNull(0)) {
            this.mayUpdateLastCache(Long.MIN_VALUE, null, this.fullPath);
            return LAST_QUERY_EMPTY_TSBLOCK;
        }
        long lastTime = res.getColumn(0).getLong(0);
        TsPrimitiveType lastValue = res.getColumn(1).getTsPrimitiveType(0);
        this.mayUpdateLastCache(lastTime, lastValue, this.fullPath);
        this.tsBlockBuilder.reset();
        this.appendLastValueToTsBlockBuilder(lastTime, lastValue);
        return this.tsBlockBuilder.build();
    }

    protected void appendLastValueToTsBlockBuilder(long lastTime, TsPrimitiveType lastValue) {
        LastQueryUtil.appendLastValue(this.tsBlockBuilder, lastTime, this.fullPath.getFullPath(), lastValue.getStringValue(), this.dataType);
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + RamUsageEstimator.sizeOf((String)this.databaseName) + RamUsageEstimator.sizeOf((String)this.dataType) + MemoryEstimationHelper.getEstimatedSizeOfPartialPath((PartialPath)this.fullPath) + this.tsBlockBuilder.getRetainedSizeInBytes();
    }
}

