/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.rpc;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.client.request.AsyncRequestContext;
import org.apache.iotdb.commons.client.request.AsyncRequestRPCHandler;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.handlers.rpc.CheckTimeSeriesExistenceRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.CountPathsUsingTemplateRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.DataNodeTSStatusRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.FetchSchemaBlackListRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.PipeHeartbeatRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.PipePushMetaRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.SchemaUpdateRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.SubmitTestConnectionTaskRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.TransferLeaderRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.subscription.CheckSchemaRegionUsingTemplateRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.subscription.ConsumerGroupPushMetaRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.subscription.TopicPushMetaRPCHandler;

public abstract class DataNodeAsyncRequestRPCHandler<Response>
extends AsyncRequestRPCHandler<Response, CnToDnAsyncRequestType, TDataNodeLocation> {
    protected DataNodeAsyncRequestRPCHandler(CnToDnAsyncRequestType requestType, int requestId, TDataNodeLocation targetNode, Map<Integer, TDataNodeLocation> dataNodeLocationMap, Map<Integer, Response> integerResponseMap, CountDownLatch countDownLatch) {
        super((Object)requestType, requestId, (Object)targetNode, dataNodeLocationMap, integerResponseMap, countDownLatch);
    }

    protected String generateFormattedTargetLocation(TDataNodeLocation dataNodeLocation) {
        return "{id=" + ((TDataNodeLocation)this.targetNode).getDataNodeId() + ", internalEndPoint=" + ((TDataNodeLocation)this.targetNode).getInternalEndPoint() + "}";
    }

    public static DataNodeAsyncRequestRPCHandler<?> buildHandler(AsyncRequestContext<?, ?, CnToDnAsyncRequestType, TDataNodeLocation> context, int requestId, TDataNodeLocation targetDataNode) {
        CnToDnAsyncRequestType requestType = (CnToDnAsyncRequestType)((Object)context.getRequestType());
        Map dataNodeLocationMap = context.getNodeLocationMap();
        Map responseMap = context.getResponseMap();
        CountDownLatch countDownLatch = context.getCountDownLatch();
        switch (requestType) {
            case CONSTRUCT_SCHEMA_BLACK_LIST: 
            case ROLLBACK_SCHEMA_BLACK_LIST: 
            case DELETE_DATA_FOR_DELETE_SCHEMA: 
            case DELETE_TIMESERIES: 
            case CONSTRUCT_SCHEMA_BLACK_LIST_WITH_TEMPLATE: 
            case ROLLBACK_SCHEMA_BLACK_LIST_WITH_TEMPLATE: 
            case DEACTIVATE_TEMPLATE: 
            case CONSTRUCT_VIEW_SCHEMA_BLACK_LIST: 
            case ROLLBACK_VIEW_SCHEMA_BLACK_LIST: 
            case DELETE_VIEW: 
            case ALTER_VIEW: {
                return new SchemaUpdateRPCHandler(requestType, requestId, targetDataNode, (Map<Integer, TDataNodeLocation>)dataNodeLocationMap, responseMap, countDownLatch);
            }
            case FETCH_SCHEMA_BLACK_LIST: {
                return new FetchSchemaBlackListRPCHandler(requestType, requestId, targetDataNode, (Map<Integer, TDataNodeLocation>)dataNodeLocationMap, responseMap, countDownLatch);
            }
            case COUNT_PATHS_USING_TEMPLATE: {
                return new CountPathsUsingTemplateRPCHandler(requestType, requestId, targetDataNode, (Map<Integer, TDataNodeLocation>)dataNodeLocationMap, responseMap, countDownLatch);
            }
            case CHECK_SCHEMA_REGION_USING_TEMPLATE: {
                return new CheckSchemaRegionUsingTemplateRPCHandler(requestType, requestId, targetDataNode, (Map<Integer, TDataNodeLocation>)dataNodeLocationMap, responseMap, countDownLatch);
            }
            case CHECK_TIMESERIES_EXISTENCE: {
                return new CheckTimeSeriesExistenceRPCHandler(requestType, requestId, targetDataNode, (Map<Integer, TDataNodeLocation>)dataNodeLocationMap, responseMap, countDownLatch);
            }
            case PIPE_HEARTBEAT: {
                return new PipeHeartbeatRPCHandler(requestType, requestId, targetDataNode, (Map<Integer, TDataNodeLocation>)dataNodeLocationMap, responseMap, countDownLatch);
            }
            case PIPE_PUSH_ALL_META: 
            case PIPE_PUSH_SINGLE_META: 
            case PIPE_PUSH_MULTI_META: {
                return new PipePushMetaRPCHandler(requestType, requestId, targetDataNode, (Map<Integer, TDataNodeLocation>)dataNodeLocationMap, responseMap, countDownLatch);
            }
            case TOPIC_PUSH_ALL_META: 
            case TOPIC_PUSH_SINGLE_META: 
            case TOPIC_PUSH_MULTI_META: {
                return new TopicPushMetaRPCHandler(requestType, requestId, targetDataNode, (Map<Integer, TDataNodeLocation>)dataNodeLocationMap, responseMap, countDownLatch);
            }
            case CONSUMER_GROUP_PUSH_ALL_META: 
            case CONSUMER_GROUP_PUSH_SINGLE_META: {
                return new ConsumerGroupPushMetaRPCHandler(requestType, requestId, targetDataNode, (Map<Integer, TDataNodeLocation>)dataNodeLocationMap, responseMap, countDownLatch);
            }
            case CHANGE_REGION_LEADER: {
                return new TransferLeaderRPCHandler(requestType, requestId, targetDataNode, (Map<Integer, TDataNodeLocation>)dataNodeLocationMap, responseMap, countDownLatch);
            }
            case SUBMIT_TEST_CONNECTION_TASK: 
            case SUBMIT_TEST_DN_INTERNAL_CONNECTION_TASK: {
                return new SubmitTestConnectionTaskRPCHandler(requestType, requestId, targetDataNode, (Map<Integer, TDataNodeLocation>)dataNodeLocationMap, responseMap, countDownLatch);
            }
        }
        return new DataNodeTSStatusRPCHandler(requestType, requestId, targetDataNode, (Map<Integer, TDataNodeLocation>)dataNodeLocationMap, responseMap, countDownLatch);
    }
}

