/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.block.column;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.ColumnEncoder;
import org.apache.tsfile.read.common.block.column.DoubleColumn;
import org.apache.tsfile.read.common.block.column.LongColumn;

public class Int64ArrayColumnEncoder
implements ColumnEncoder {
    @Override
    public Column readColumn(ByteBuffer input, TSDataType dataType, int positionCount) {
        boolean[] nullIndicators = ColumnEncoder.deserializeNullIndicators(input, positionCount);
        switch (dataType) {
            case INT64: 
            case TIMESTAMP: {
                long[] values = new long[positionCount];
                if (nullIndicators == null) {
                    for (int i = 0; i < positionCount; ++i) {
                        values[i] = input.getLong();
                    }
                } else {
                    for (int i = 0; i < positionCount; ++i) {
                        if (nullIndicators[i]) continue;
                        values[i] = input.getLong();
                    }
                }
                return new LongColumn(0, positionCount, nullIndicators, values);
            }
            case DOUBLE: {
                double[] doubleValues = new double[positionCount];
                if (nullIndicators == null) {
                    for (int i = 0; i < positionCount; ++i) {
                        doubleValues[i] = Double.longBitsToDouble(input.getLong());
                    }
                } else {
                    for (int i = 0; i < positionCount; ++i) {
                        if (nullIndicators[i]) continue;
                        doubleValues[i] = Double.longBitsToDouble(input.getLong());
                    }
                }
                return new DoubleColumn(0, positionCount, nullIndicators, doubleValues);
            }
        }
        throw new IllegalArgumentException("Invalid data type: " + dataType);
    }

    @Override
    public void writeColumn(DataOutputStream output, Column column) throws IOException {
        ColumnEncoder.serializeNullIndicators(output, column);
        TSDataType dataType = column.getDataType();
        int positionCount = column.getPositionCount();
        switch (dataType) {
            case INT64: 
            case TIMESTAMP: {
                for (int i = 0; i < positionCount; ++i) {
                    if (column.isNull(i)) continue;
                    output.writeLong(column.getLong(i));
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < positionCount; ++i) {
                    if (column.isNull(i)) continue;
                    output.writeLong(Double.doubleToLongBits(column.getDouble(i)));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid data type: " + dataType);
            }
        }
    }
}

