/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.leader;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Comparator;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.rpc.CallId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.leader.FollowerInfo;
import org.apache.ratis.server.leader.LeaderState;
import org.apache.ratis.server.leader.LogAppender;
import org.apache.ratis.server.leader.LogAppenderBase;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.server.util.ServerStringUtils;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.util.ReferenceCountedObject;
import org.apache.ratis.util.Timestamp;

class LogAppenderDefault
extends LogAppenderBase {
    LogAppenderDefault(RaftServer.Division server, LeaderState leaderState, FollowerInfo f) {
        super(server, leaderState, f);
    }

    public long getCallId() {
        return CallId.get();
    }

    public Comparator<Long> getCallIdComparator() {
        return CallId.getComparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RaftProtos.AppendEntriesReplyProto sendAppendEntriesWithRetries(AtomicLong requestFirstIndex) throws InterruptedException, InterruptedIOException, RaftLogIOException {
        int retry = 0;
        while (this.isRunning()) {
            ReferenceCountedObject<RaftProtos.AppendEntriesRequestProto> request = this.nextAppendEntriesRequest(CallId.getAndIncrement(), false);
            if (request == null) {
                LOG.trace("{} no entries to send now, wait ...", (Object)this);
                return null;
            }
            try {
                if (!this.isRunning()) {
                    LOG.info("{} is stopped. Skip appendEntries.", (Object)this);
                    RaftProtos.AppendEntriesReplyProto appendEntriesReplyProto = null;
                    return appendEntriesReplyProto;
                }
                RaftProtos.AppendEntriesRequestProto proto = (RaftProtos.AppendEntriesRequestProto)request.get();
                RaftProtos.AppendEntriesReplyProto reply = this.sendAppendEntries(proto);
                long first = proto.getEntriesCount() > 0 ? proto.getEntries(0).getIndex() : -1L;
                requestFirstIndex.set(first);
                RaftProtos.AppendEntriesReplyProto appendEntriesReplyProto = reply;
                return appendEntriesReplyProto;
            }
            catch (InterruptedIOException | RaftLogIOException e) {
                throw e;
            }
            catch (IOException ioe) {
                if (retry % 10 == 0) {
                    LOG.warn("{}: Failed to appendEntries (retry={})", new Object[]{this, retry, ioe});
                }
                this.handleException(ioe);
            }
            finally {
                request.release();
            }
            if (this.isRunning()) {
                this.getServer().properties().rpcSleepTime().sleep();
            }
            ++retry;
        }
        return null;
    }

    private RaftProtos.AppendEntriesReplyProto sendAppendEntries(RaftProtos.AppendEntriesRequestProto request) throws IOException {
        this.resetHeartbeatTrigger();
        Timestamp sendTime = Timestamp.currentTime();
        this.getFollower().updateLastRpcSendTime(request.getEntriesCount() == 0);
        RaftProtos.AppendEntriesReplyProto r = this.getServerRpc().appendEntries(request);
        this.getFollower().updateLastRpcResponseTime();
        this.getFollower().updateLastRespondedAppendEntriesSendTime(sendTime);
        this.getLeaderState().onFollowerCommitIndex(this.getFollower(), r.getFollowerCommit());
        return r;
    }

    private RaftProtos.InstallSnapshotReplyProto installSnapshot(SnapshotInfo snapshot) throws InterruptedIOException {
        String requestId = UUID.randomUUID().toString();
        RaftProtos.InstallSnapshotReplyProto reply = null;
        try {
            for (RaftProtos.InstallSnapshotRequestProto request : this.newInstallSnapshotRequests(requestId, snapshot)) {
                this.getFollower().updateLastRpcSendTime(false);
                reply = this.getServerRpc().installSnapshot(request);
                this.getFollower().updateLastRpcResponseTime();
                if (reply.getServerReply().getSuccess()) continue;
                return reply;
            }
        }
        catch (InterruptedIOException iioe) {
            throw iioe;
        }
        catch (Exception ioe) {
            LOG.warn("{}: Failed to installSnapshot {}", new Object[]{this, snapshot, ioe});
            this.handleException(ioe);
            return null;
        }
        if (reply != null) {
            this.getFollower().setSnapshotIndex(snapshot.getTermIndex().getIndex());
            LOG.info("{}: installSnapshot {} successfully", (Object)this, (Object)snapshot);
            this.getServer().getRaftServerMetrics().onSnapshotInstalled();
        }
        return reply;
    }

    public void run() throws InterruptedException, IOException {
        while (this.isRunning()) {
            if (this.shouldSendAppendEntries()) {
                SnapshotInfo snapshot = this.shouldInstallSnapshot();
                if (snapshot != null) {
                    LOG.info("{}: followerNextIndex = {} but logStartIndex = {}, send snapshot {} to follower", new Object[]{this, this.getFollower().getNextIndex(), this.getRaftLog().getStartIndex(), snapshot});
                    RaftProtos.InstallSnapshotReplyProto r = this.installSnapshot(snapshot);
                    if (r != null) {
                        switch (r.getResult()) {
                            case NOT_LEADER: {
                                this.onFollowerTerm(r.getTerm());
                                break;
                            }
                            case SUCCESS: 
                            case SNAPSHOT_UNAVAILABLE: 
                            case ALREADY_INSTALLED: 
                            case SNAPSHOT_EXPIRED: {
                                this.getFollower().setAttemptedToInstallSnapshot();
                                break;
                            }
                        }
                    }
                } else {
                    AtomicLong requestFirstIndex = new AtomicLong(-1L);
                    RaftProtos.AppendEntriesReplyProto r = this.sendAppendEntriesWithRetries(requestFirstIndex);
                    if (r != null) {
                        this.handleReply(r, requestFirstIndex.get());
                    }
                }
            }
            if (this.isRunning() && !this.hasAppendEntries()) {
                this.getEventAwaitForSignal().await(this.getHeartbeatWaitTimeMs(), TimeUnit.MILLISECONDS);
            }
            this.getLeaderState().checkHealth(this.getFollower());
        }
    }

    private void handleReply(RaftProtos.AppendEntriesReplyProto reply, long requestFirstIndex) throws IllegalArgumentException {
        if (reply != null) {
            switch (reply.getResult()) {
                case SUCCESS: {
                    long oldNextIndex = this.getFollower().getNextIndex();
                    long nextIndex = reply.getNextIndex();
                    if (nextIndex < oldNextIndex) {
                        throw new IllegalStateException("nextIndex=" + nextIndex + " < oldNextIndex=" + oldNextIndex + ", reply=" + ServerStringUtils.toAppendEntriesReplyString(reply));
                    }
                    if (nextIndex <= oldNextIndex) break;
                    this.getFollower().updateMatchIndex(nextIndex - 1L);
                    this.getFollower().increaseNextIndex(nextIndex);
                    this.getLeaderState().onFollowerSuccessAppendEntries(this.getFollower());
                    break;
                }
                case NOT_LEADER: {
                    this.onFollowerTerm(reply.getTerm());
                    break;
                }
                case INCONSISTENCY: {
                    this.getFollower().setNextIndex(this.getNextIndexForInconsistency(requestFirstIndex, reply.getNextIndex()));
                    break;
                }
                case UNRECOGNIZED: {
                    LOG.warn("{}: received {}", (Object)this, (Object)reply.getResult());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unable to process result " + reply.getResult());
                }
            }
            this.getLeaderState().onAppendEntriesReply((LogAppender)this, reply);
        }
    }

    private void handleException(Exception e) {
        LOG.trace("TRACE", (Throwable)e);
        this.getServerRpc().handleException(this.getFollowerId(), e, false);
    }
}

