/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.exceptions.StreamException;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ReferenceCountedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessageStreamRequests {
    public static final Logger LOG = LoggerFactory.getLogger(MessageStreamRequests.class);
    private final String name;
    private final StreamMap streams = new StreamMap();

    MessageStreamRequests(Object name) {
        this.name = name + "-" + JavaUtils.getClassSimpleName(this.getClass());
    }

    CompletableFuture<?> streamAsync(ReferenceCountedObject<RaftClientRequest> requestRef) {
        RaftClientRequest request = (RaftClientRequest)requestRef.get();
        RaftProtos.MessageStreamRequestTypeProto stream = request.getType().getMessageStream();
        Preconditions.assertTrue((!stream.getEndOfRequest() ? 1 : 0) != 0);
        ClientInvocationId key = ClientInvocationId.valueOf((ClientId)request.getClientId(), (long)stream.getStreamId());
        PendingStream pending = this.streams.computeIfAbsent(key);
        return pending.append(stream.getMessageId(), requestRef);
    }

    CompletableFuture<ReferenceCountedObject<RaftClientRequest>> streamEndOfRequestAsync(ReferenceCountedObject<RaftClientRequest> requestRef) {
        RaftClientRequest request = (RaftClientRequest)requestRef.get();
        RaftProtos.MessageStreamRequestTypeProto stream = request.getType().getMessageStream();
        Preconditions.assertTrue((boolean)stream.getEndOfRequest());
        ClientInvocationId key = ClientInvocationId.valueOf((ClientId)request.getClientId(), (long)stream.getStreamId());
        PendingStream pending = this.streams.remove(key);
        if (pending == null) {
            return JavaUtils.completeExceptionally((Throwable)new StreamException(this.name + ": " + key + " not found"));
        }
        return pending.getWriteRequest(stream.getMessageId(), requestRef);
    }

    void clear() {
        this.streams.clear();
    }

    static class StreamMap {
        private final Map<ClientInvocationId, PendingStream> map = new HashMap<ClientInvocationId, PendingStream>();

        StreamMap() {
        }

        synchronized PendingStream computeIfAbsent(ClientInvocationId key) {
            return this.map.computeIfAbsent(key, PendingStream::new);
        }

        synchronized PendingStream remove(ClientInvocationId key) {
            return this.map.remove(key);
        }

        synchronized void clear() {
            this.map.values().forEach(PendingStream::clear);
            this.map.clear();
        }
    }

    private static class PendingStream {
        private final ClientInvocationId key;
        private long nextId = -1L;
        private ByteString bytes = ByteString.EMPTY;
        private final List<ReferenceCountedObject<RaftClientRequest>> pendingRefs = new LinkedList<ReferenceCountedObject<RaftClientRequest>>();

        PendingStream(ClientInvocationId key) {
            this.key = key;
        }

        synchronized CompletableFuture<ByteString> append(long messageId, ReferenceCountedObject<RaftClientRequest> requestRef) {
            if (this.nextId == -1L) {
                this.nextId = messageId;
            } else if (messageId != this.nextId) {
                return JavaUtils.completeExceptionally((Throwable)new StreamException("Unexpected message id in " + this.key + ": messageId = " + messageId + " != nextId = " + this.nextId));
            }
            ++this.nextId;
            Message message = ((RaftClientRequest)requestRef.retain()).getMessage();
            this.pendingRefs.add(requestRef);
            this.bytes = this.bytes.concat(message.getContent());
            return CompletableFuture.completedFuture(this.bytes);
        }

        synchronized CompletableFuture<ReferenceCountedObject<RaftClientRequest>> getWriteRequest(long messageId, ReferenceCountedObject<RaftClientRequest> requestRef) {
            return ((CompletableFuture)this.append(messageId, requestRef).thenApply(appended -> RaftClientRequest.toWriteRequest((RaftClientRequest)((RaftClientRequest)requestRef.get()), () -> appended))).thenApply(request -> ReferenceCountedObject.delegateFrom(this.pendingRefs, (Object)request));
        }

        synchronized void clear() {
            this.pendingRefs.forEach(ReferenceCountedObject::release);
            this.pendingRefs.clear();
        }
    }
}

