/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.parameter;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.path.AlignedFullPath;
import org.apache.iotdb.commons.path.IFullPath;
import org.apache.iotdb.commons.path.NonAlignedFullPath;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.factory.FilterFactory;
import org.apache.tsfile.read.filter.factory.TimeFilterApi;
import org.apache.tsfile.read.reader.series.PaginationController;

public class SeriesScanOptions {
    private Filter globalTimeFilter;
    private final AtomicBoolean timeFilterUpdatedByTll = new AtomicBoolean(false);
    private final Filter pushDownFilter;
    private final long pushDownLimit;
    private final long pushDownOffset;
    private final Set<String> allSensors;
    private final boolean pushLimitToEachDevice;
    private PaginationController paginationController;

    public SeriesScanOptions(Filter globalTimeFilter, Filter pushDownFilter, long pushDownLimit, long pushDownOffset, Set<String> allSensors, boolean pushLimitToEachDevice) {
        this.globalTimeFilter = globalTimeFilter;
        this.pushDownFilter = pushDownFilter;
        this.pushDownLimit = pushDownLimit;
        this.pushDownOffset = pushDownOffset;
        this.allSensors = allSensors;
        this.pushLimitToEachDevice = pushLimitToEachDevice;
    }

    public static SeriesScanOptions getDefaultSeriesScanOptions(IFullPath seriesPath) {
        Builder builder = new Builder();
        if (seriesPath instanceof AlignedFullPath) {
            builder.withAllSensors(new HashSet<String>(((AlignedFullPath)seriesPath).getMeasurementList()));
        } else {
            builder.withAllSensors(new HashSet<String>(Collections.singletonList(((NonAlignedFullPath)seriesPath).getMeasurement())));
        }
        return builder.build();
    }

    public Filter getGlobalTimeFilter() {
        return this.globalTimeFilter;
    }

    public Filter getPushDownFilter() {
        return this.pushDownFilter;
    }

    public long getPushDownLimit() {
        return this.pushDownLimit;
    }

    public long getPushDownOffset() {
        return this.pushDownOffset;
    }

    public boolean getPushLimitToEachDevice() {
        return this.pushLimitToEachDevice;
    }

    public Set<String> getAllSensors() {
        return this.allSensors;
    }

    public PaginationController getPaginationController() {
        if (this.pushLimitToEachDevice) {
            return new PaginationController(this.pushDownLimit, this.pushDownOffset);
        }
        if (this.paginationController == null) {
            this.paginationController = new PaginationController(this.pushDownLimit, this.pushDownOffset);
        }
        return this.paginationController;
    }

    public boolean timeFilterNeedUpdatedByTll() {
        return !this.timeFilterUpdatedByTll.get();
    }

    public void setTTL(long dataTTL) {
        if (this.timeFilterUpdatedByTll.compareAndSet(false, true)) {
            this.globalTimeFilter = SeriesScanOptions.updateFilterUsingTTL(this.globalTimeFilter, dataTTL);
        }
    }

    public static Filter updateFilterUsingTTL(Filter filter, long dataTTL) {
        if (dataTTL != Long.MAX_VALUE) {
            filter = filter != null ? FilterFactory.and((Filter)filter, (Filter)TimeFilterApi.gtEq((long)(CommonDateTimeUtils.currentTime() - dataTTL))) : TimeFilterApi.gtEq((long)(CommonDateTimeUtils.currentTime() - dataTTL));
        }
        return filter;
    }

    public boolean limitConsumedUp() {
        return !this.pushLimitToEachDevice && this.paginationController != null && !this.paginationController.hasCurLimit();
    }

    public static class Builder {
        private Filter globalTimeFilter = null;
        private Filter pushDownFilter = null;
        private long pushDownLimit = 0L;
        private long pushDownOffset = 0L;
        private Set<String> allSensors;
        private boolean pushLimitToEachDevice = true;

        public Builder withGlobalTimeFilter(Filter globalTimeFilter) {
            this.globalTimeFilter = globalTimeFilter;
            return this;
        }

        public Builder withPushDownFilter(Filter pushDownFilter) {
            this.pushDownFilter = pushDownFilter;
            return this;
        }

        public Builder withPushDownLimit(long pushDownLimit) {
            this.pushDownLimit = pushDownLimit;
            return this;
        }

        public Builder withPushDownOffset(long pushDownOffset) {
            this.pushDownOffset = pushDownOffset;
            return this;
        }

        public Builder withPushLimitToEachDevice(boolean pushLimitToEachDevice) {
            this.pushLimitToEachDevice = pushLimitToEachDevice;
            return this;
        }

        public void withAllSensors(Set<String> allSensors) {
            this.allSensors = allSensors;
        }

        public SeriesScanOptions build() {
            return new SeriesScanOptions(this.globalTimeFilter, this.pushDownFilter, this.pushDownLimit, this.pushDownOffset, this.allSensors, this.pushLimitToEachDevice);
        }
    }
}

