/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ReferenceCountedObject;
import org.apache.ratis.util.StringUtils;
import org.apache.ratis.util.function.CheckedSupplier;
import org.apache.ratis.util.function.UncheckedAutoCloseableSupplier;

interface RaftLogSequentialOps {
    public long append(long var1, TransactionContext var3) throws StateMachineException;

    public long append(long var1, RaftConfiguration var3);

    public long appendMetadata(long var1, long var3);

    public CompletableFuture<Long> appendEntry(RaftProtos.LogEntryProto var1);

    @Deprecated
    default public CompletableFuture<Long> appendEntry(RaftProtos.LogEntryProto entry, TransactionContext context) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<Long> appendEntry(ReferenceCountedObject<RaftProtos.LogEntryProto> entryRef, TransactionContext context) {
        return this.appendEntry((RaftProtos.LogEntryProto)entryRef.get(), context);
    }

    @Deprecated
    default public List<CompletableFuture<Long>> append(RaftProtos.LogEntryProto ... entries) {
        return this.append(Arrays.asList(entries));
    }

    @Deprecated
    default public List<CompletableFuture<Long>> append(List<RaftProtos.LogEntryProto> entries) {
        throw new UnsupportedOperationException();
    }

    default public List<CompletableFuture<Long>> append(ReferenceCountedObject<List<RaftProtos.LogEntryProto>> entriesRef) {
        try (UncheckedAutoCloseableSupplier entries = entriesRef.retainAndReleaseOnClose();){
            List<CompletableFuture<Long>> list = this.append((List)entries.get());
            return list;
        }
    }

    public CompletableFuture<Long> truncate(long var1);

    public static class Runner {
        private final Object name;
        private final AtomicReference<Thread> runner = new AtomicReference();

        Runner(Supplier<String> name) {
            this.name = StringUtils.stringSupplierAsObject(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <OUTPUT, THROWABLE extends Throwable> OUTPUT runSequentially(CheckedSupplier<OUTPUT, THROWABLE> operation) throws THROWABLE {
            Thread current = Thread.currentThread();
            Thread previous = this.runner.getAndUpdate(prev -> prev != null ? prev : current);
            if (previous == null) {
                Object object;
                try {
                    object = operation.get();
                    Thread got = this.runner.getAndUpdate(prev -> prev != current ? prev : null);
                    Preconditions.assertTrue((got == current ? 1 : 0) != 0, () -> this.name + ": Unexpected runner " + got + " != " + current);
                }
                catch (Throwable throwable) {
                    Thread got = this.runner.getAndUpdate(prev -> prev != current ? prev : null);
                    Preconditions.assertTrue((got == current ? 1 : 0) != 0, () -> this.name + ": Unexpected runner " + got + " != " + current);
                    throw throwable;
                }
                return (OUTPUT)object;
            }
            if (previous == current) {
                return (OUTPUT)operation.get();
            }
            Throwable cause = new Throwable("The thread already running: " + previous);
            cause.setStackTrace(previous.getStackTrace());
            throw new IllegalStateException(this.name + ": Already running a method by " + previous + ", current=" + current, cause);
        }
    }
}

