/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.ReferenceCountedObject;

public interface RaftClientAsynchronousProtocol {
    default public CompletableFuture<RaftClientReply> submitClientRequestAsync(RaftClientRequest request) throws IOException {
        return this.submitClientRequestAsync(ReferenceCountedObject.wrap(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public CompletableFuture<RaftClientReply> submitClientRequestAsync(ReferenceCountedObject<RaftClientRequest> requestRef) {
        try {
            CompletableFuture<RaftClientReply> completableFuture = this.submitClientRequestAsync(requestRef.retain());
            return completableFuture;
        }
        catch (Exception e) {
            CompletableFuture<RaftClientReply> completableFuture = JavaUtils.completeExceptionally(e);
            return completableFuture;
        }
        finally {
            requestRef.release();
        }
    }
}

