/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations;

import java.util.Map;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.DeviceTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.GroupNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.InformationSchemaTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.StreamSortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PlanOptimizer;

public class TransformSortToStreamSort
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, PlanOptimizer.Context context) {
        if (!context.getAnalysis().hasSortNode()) {
            return plan;
        }
        return plan.accept(new Rewriter(context.getAnalysis(), context.getQueryContext()), new Context());
    }

    public static boolean isOrderByAllIdsAndTime(Map<Symbol, ColumnSchema> tableColumnSchema, OrderingScheme orderingScheme, int streamSortIndex) {
        for (Map.Entry<Symbol, ColumnSchema> entry : tableColumnSchema.entrySet()) {
            if (entry.getValue().getColumnCategory() != TsTableColumnCategory.TAG || orderingScheme.getOrderings().containsKey(entry.getKey())) continue;
            return false;
        }
        return orderingScheme.getOrderings().size() == streamSortIndex + 1 || DeviceTableScanNode.isTimeColumn(orderingScheme.getOrderBy().get(streamSortIndex + 1), tableColumnSchema);
    }

    private static class Rewriter
    extends PlanVisitor<PlanNode, Context> {
        private final Analysis analysis;
        private final MPPQueryContext queryContext;

        public Rewriter(Analysis analysis, MPPQueryContext queryContext) {
            this.analysis = analysis;
            this.queryContext = queryContext;
        }

        @Override
        public PlanNode visitPlan(PlanNode node, Context context) {
            PlanNode newNode = node.clone();
            for (PlanNode child : node.getChildren()) {
                newNode.addChild(child.accept(this, context));
            }
            return newNode;
        }

        @Override
        public PlanNode visitSort(SortNode node, Context context) {
            PlanNode child = node.getChild().accept(this, context);
            if (!context.canTransform()) {
                node.setChild(child);
                return node;
            }
            context.setCanTransform(false);
            DeviceTableScanNode deviceTableScanNode = context.getTableScanNode();
            Map<Symbol, ColumnSchema> tableColumnSchema = this.analysis.getTableColumnSchema(deviceTableScanNode.getQualifiedObjectName());
            OrderingScheme orderingScheme = node.getOrderingScheme();
            int streamSortIndex = -1;
            for (Symbol orderBy : orderingScheme.getOrderBy()) {
                if (!tableColumnSchema.containsKey(orderBy) || tableColumnSchema.get(orderBy).getColumnCategory() == TsTableColumnCategory.FIELD || tableColumnSchema.get(orderBy).getColumnCategory() == TsTableColumnCategory.TIME) break;
                ++streamSortIndex;
            }
            if (streamSortIndex >= 0) {
                boolean orderByAllIdsAndTime = TransformSortToStreamSort.isOrderByAllIdsAndTime(tableColumnSchema, orderingScheme, streamSortIndex);
                return new StreamSortNode(this.queryContext.getQueryId().genPlanNodeId(), child, node.getOrderingScheme(), node.isPartial(), orderByAllIdsAndTime, streamSortIndex);
            }
            return node;
        }

        @Override
        public PlanNode visitGroup(GroupNode node, Context context) {
            return (PlanNode)this.visitSingleChildProcess(node, context);
        }

        @Override
        public PlanNode visitDeviceTableScan(DeviceTableScanNode node, Context context) {
            context.setTableScanNode(node);
            return node;
        }

        @Override
        public PlanNode visitInformationSchemaTableScan(InformationSchemaTableScanNode node, Context context) {
            context.setCanTransform(false);
            return node;
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, Context context) {
            context.setCanTransform(false);
            return (PlanNode)this.visitSingleChildProcess(node, context);
        }

        @Override
        public PlanNode visitAggregationTableScan(AggregationTableScanNode node, Context context) {
            context.setCanTransform(false);
            return (PlanNode)this.visitTableScan(node, context);
        }
    }

    private static class Context {
        private DeviceTableScanNode tableScanNode;
        private boolean canTransform = true;

        private Context() {
        }

        public DeviceTableScanNode getTableScanNode() {
            return this.tableScanNode;
        }

        public void setTableScanNode(DeviceTableScanNode tableScanNode) {
            this.tableScanNode = tableScanNode;
        }

        public boolean canTransform() {
            return this.canTransform;
        }

        public void setCanTransform(boolean canTransform) {
            this.canTransform = canTransform;
        }
    }
}

