/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.window.function.value;

import org.apache.iotdb.db.queryengine.execution.operator.process.window.function.value.ValueWindowFunction;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.Partition;
import org.apache.tsfile.block.column.ColumnBuilder;

public class NthValueFunction
extends ValueWindowFunction {
    private final int n;
    private final int channel;
    private final boolean ignoreNull;

    public NthValueFunction(int n, int channel, boolean ignoreNull) {
        this.n = n;
        this.channel = channel;
        this.ignoreNull = ignoreNull;
    }

    @Override
    public void transform(Partition partition, ColumnBuilder builder, int index, int frameStart, int frameEnd) {
        if (frameStart < 0) {
            builder.appendNull();
            return;
        }
        if (this.ignoreNull) {
            int pos;
            int nonNullCount = 0;
            for (pos = frameStart; pos <= frameEnd && (partition.isNull(this.channel, pos) || ++nonNullCount != this.n); ++pos) {
            }
            if (pos <= frameEnd) {
                partition.writeTo(builder, this.channel, pos);
            } else {
                builder.appendNull();
            }
            return;
        }
        int pos = frameStart + this.n - 1;
        if (pos <= frameEnd) {
            if (!partition.isNull(this.channel, pos)) {
                partition.writeTo(builder, this.channel, pos);
            } else {
                builder.appendNull();
            }
        } else {
            builder.appendNull();
        }
    }
}

