/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.util.builder;

import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.pipe.connector.util.builder.PipeTreeModelTsFileBuilder;
import org.apache.iotdb.db.pipe.connector.util.builder.PipeTsFileBuilder;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.storageengine.dataregion.flush.MemTableFlushTask;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.PrimitiveMemTable;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.apache.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTreeModelTsFileBuilderV2
extends PipeTsFileBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTreeModelTsFileBuilderV2.class);
    private static final PlanNodeId PLACEHOLDER_PLAN_NODE_ID = new PlanNodeId("PipeTreeModelTsFileBuilderV2");
    private final List<Tablet> tabletList = new ArrayList<Tablet>();
    private final List<Boolean> isTabletAlignedList = new ArrayList<Boolean>();
    private final PipeTreeModelTsFileBuilder fallbackBuilder;

    public PipeTreeModelTsFileBuilderV2(AtomicLong currentBatchId, AtomicLong tsFileIdGenerator) {
        super(currentBatchId, tsFileIdGenerator);
        this.fallbackBuilder = new PipeTreeModelTsFileBuilder(currentBatchId, tsFileIdGenerator);
    }

    @Override
    public void bufferTableModelTablet(String dataBase, Tablet tablet) {
        throw new UnsupportedOperationException("PipeTreeModelTsFileBuilderV2 does not support table model tablet to build TSFile");
    }

    @Override
    public void bufferTreeModelTablet(Tablet tablet, Boolean isAligned) {
        this.tabletList.add(tablet);
        this.isTabletAlignedList.add(isAligned);
        this.fallbackBuilder.bufferTreeModelTablet(tablet, isAligned);
    }

    @Override
    public List<Pair<String, File>> convertTabletToTsFileWithDBInfo() throws IOException, org.apache.tsfile.exception.write.WriteProcessException {
        try {
            return this.writeTabletsToTsFiles();
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred when PipeTreeModelTsFileBuilderV2 writing tablets to tsfile, use fallback tsfile builder: {}", (Object)e.getMessage(), (Object)e);
            return this.fallbackBuilder.convertTabletToTsFileWithDBInfo();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.tabletList.isEmpty();
    }

    @Override
    public void onSuccess() {
        super.onSuccess();
        this.tabletList.clear();
        this.isTabletAlignedList.clear();
        this.fallbackBuilder.onSuccess();
    }

    @Override
    public synchronized void close() {
        super.close();
        this.tabletList.clear();
        this.isTabletAlignedList.clear();
        this.fallbackBuilder.close();
    }

    private List<Pair<String, File>> writeTabletsToTsFiles() throws org.apache.tsfile.exception.write.WriteProcessException {
        PrimitiveMemTable memTable = new PrimitiveMemTable(null, null);
        ArrayList<Pair<String, File>> sealedFiles = new ArrayList<Pair<String, File>>();
        try (RestorableTsFileIOWriter writer = new RestorableTsFileIOWriter(this.createFile());){
            this.writeTabletsIntoOneFile(memTable, writer);
            sealedFiles.add(new Pair(null, (Object)writer.getFile()));
        }
        catch (Exception e) {
            LOGGER.warn("Batch id = {}: Failed to write tablets into tsfile, because {}", new Object[]{this.currentBatchId.get(), e.getMessage(), e});
            throw new org.apache.tsfile.exception.write.WriteProcessException((Throwable)e);
        }
        finally {
            memTable.release();
        }
        return sealedFiles;
    }

    private void writeTabletsIntoOneFile(IMemTable memTable, RestorableTsFileIOWriter writer) throws Exception {
        int size = this.tabletList.size();
        for (int i = 0; i < size; ++i) {
            Tablet tablet = this.tabletList.get(i);
            Object[] values = tablet.getValues();
            for (int j = 0; j < tablet.getSchemas().size(); ++j) {
                IMeasurementSchema schema2 = (IMeasurementSchema)tablet.getSchemas().get(j);
                if (!Objects.nonNull(schema2) || !Objects.equals(TSDataType.DATE, schema2.getType()) || !(values[j] instanceof LocalDate[])) continue;
                LocalDate[] dates = (LocalDate[])values[j];
                int[] dateValues = new int[dates.length];
                for (int k = 0; k < Math.min(dates.length, tablet.getRowSize()); ++k) {
                    dateValues[k] = DateUtils.parseDateExpressionToInt((LocalDate)dates[k]);
                }
                values[j] = dateValues;
            }
            InsertTabletNode insertTabletNode = new InsertTabletNode(PLACEHOLDER_PLAN_NODE_ID, new PartialPath(tablet.getDeviceId()), this.isTabletAlignedList.get(i), (String[])tablet.getSchemas().stream().map(IMeasurementSchema::getMeasurementName).toArray(String[]::new), (TSDataType[])tablet.getSchemas().stream().map(IMeasurementSchema::getType).toArray(TSDataType[]::new), (MeasurementSchema[])tablet.getSchemas().stream().map(schema -> (MeasurementSchema)schema).toArray(MeasurementSchema[]::new), tablet.getTimestamps(), tablet.getBitMaps(), tablet.getValues(), tablet.getRowSize());
            boolean start = false;
            int end = insertTabletNode.getRowCount();
            try {
                if (insertTabletNode.isAligned()) {
                    memTable.insertAlignedTablet(insertTabletNode, 0, end, null);
                    continue;
                }
                memTable.insertTablet(insertTabletNode, 0, end);
                continue;
            }
            catch (WriteProcessException e) {
                throw new org.apache.tsfile.exception.write.WriteProcessException((Throwable)((Object)e));
            }
        }
        MemTableFlushTask memTableFlushTask = new MemTableFlushTask(memTable, writer, null, null);
        memTableFlushTask.syncFlushMemTable();
        writer.endFile();
    }
}

