/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth;

import com.google.common.util.concurrent.SettableFuture;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PrivilegeModelType;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.PrivilegeUnion;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.confignode.rpc.thrift.TAuthizedPatternTreeResp;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerRelationalReq;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerReq;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerResp;
import org.apache.iotdb.confignode.rpc.thrift.TCheckUserPrivilegesReq;
import org.apache.iotdb.confignode.rpc.thrift.TLoginReq;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TRoleResp;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.auth.IAuthorCache;
import org.apache.iotdb.db.auth.IAuthorityFetcher;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RelationalAuthorStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.AuthorStatement;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterAuthorityFetcher
implements IAuthorityFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterAuthorityFetcher.class);
    private static final CommonConfig CONFIG = CommonDescriptor.getInstance().getConfig();
    private final IAuthorCache iAuthorCache;
    private boolean cacheOutDate = false;
    private long heartBeatTimeStamp = 0L;
    private boolean acceptCache = true;
    private static final IClientManager<ConfigRegionId, ConfigNodeClient> CONFIG_NODE_CLIENT_MANAGER = ConfigNodeClientManager.getInstance();
    private static final String CONNECTERROR = "Failed to connect to config node.";

    public ClusterAuthorityFetcher(IAuthorCache iAuthorCache) {
        this.iAuthorCache = iAuthorCache;
    }

    private TSStatus checkPrivilege(String username, PrivilegeUnion union, BiFunction<Role, PrivilegeUnion, Boolean> privilegeCheck, TCheckUserPrivilegesReq req) {
        User user = this.iAuthorCache.getUserCache(username);
        if (user != null) {
            if (privilegeCheck.apply((Role)user, union).booleanValue()) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            boolean remoteCheck = false;
            for (String rolename : user.getRoleSet()) {
                Role role = this.iAuthorCache.getRoleCache(rolename);
                if (role == null) {
                    remoteCheck = true;
                    break;
                }
                if (!privilegeCheck.apply(role, union).booleanValue()) continue;
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            if (remoteCheck) {
                return this.checkPrivilegeFromConfigNode(req).getStatus();
            }
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_PERMISSION);
        }
        return this.checkPrivilegeFromConfigNode(req).getStatus();
    }

    @Override
    public TSStatus checkUserSysPrivileges(String username, PrivilegeType permission) {
        this.checkCacheAvailable();
        return this.checkPrivilege(username, new PrivilegeUnion(permission, false), (role, union) -> role.checkSysPrivilege(union.getPrivilegeType()), new TCheckUserPrivilegesReq(username, PrivilegeModelType.SYSTEM.ordinal(), permission.ordinal(), false));
    }

    @Override
    public TSStatus checkUserSysPrivilegesGrantOpt(String username, PrivilegeType permission) {
        this.checkCacheAvailable();
        return this.checkPrivilege(username, new PrivilegeUnion(permission, true), (role, union) -> role.checkSysPriGrantOpt(union.getPrivilegeType()), new TCheckUserPrivilegesReq(username, PrivilegeModelType.SYSTEM.ordinal(), permission.ordinal(), true));
    }

    @Override
    public List<Integer> checkUserPathPrivileges(String username, List<? extends PartialPath> allPath, PrivilegeType permission) {
        this.checkCacheAvailable();
        ArrayList<Integer> posList = new ArrayList<Integer>();
        User user = this.iAuthorCache.getUserCache(username);
        if (user != null) {
            if (user.isOpenIdUser()) {
                return posList;
            }
            int pos = 0;
            for (PartialPath partialPath : allPath) {
                if (!user.checkPathPrivilege(partialPath, permission)) {
                    boolean checkFromRole = false;
                    for (String rolename : user.getRoleSet()) {
                        Role cachedRole = this.iAuthorCache.getRoleCache(rolename);
                        if (cachedRole == null) {
                            return this.checkPathFromConfigNode(username, allPath, permission);
                        }
                        if (!cachedRole.checkPathPrivilege(partialPath, permission)) continue;
                        checkFromRole = true;
                        break;
                    }
                    if (!checkFromRole) {
                        posList.add(pos);
                    }
                }
                ++pos;
            }
            return posList;
        }
        return this.checkPathFromConfigNode(username, allPath, permission);
    }

    @Override
    public TSStatus checkUserPathPrivilegesGrantOpt(String username, List<? extends PartialPath> paths, PrivilegeType permission) {
        User user = this.iAuthorCache.getUserCache(username);
        if (user != null) {
            if (user.isOpenIdUser()) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            for (PartialPath partialPath : paths) {
                if (user.checkPathPrivilegeGrantOpt(partialPath, permission)) continue;
                boolean checkFromRole = false;
                for (String roleName : user.getRoleSet()) {
                    Role role = this.iAuthorCache.getRoleCache(roleName);
                    if (role == null) {
                        return this.checkPrivilegeFromConfigNode(new TCheckUserPrivilegesReq(username, PrivilegeModelType.TREE.ordinal(), permission.ordinal(), true).setPaths(AuthUtils.serializePartialPathList(paths))).getStatus();
                    }
                    if (!role.checkPathPrivilegeGrantOpt(partialPath, permission)) continue;
                    checkFromRole = true;
                    break;
                }
                if (checkFromRole) continue;
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_PERMISSION);
            }
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        return this.checkPrivilegeFromConfigNode(new TCheckUserPrivilegesReq(username, PrivilegeModelType.TREE.ordinal(), permission.ordinal(), true).setPaths(AuthUtils.serializePartialPathList(paths))).getStatus();
    }

    @Override
    public TSStatus checkUserDBPrivileges(String username, String database, PrivilegeType permission) {
        this.checkCacheAvailable();
        return this.checkPrivilege(username, new PrivilegeUnion(database, permission), (role, union) -> role.checkDatabasePrivilege(union.getDBName(), union.getPrivilegeType()), new TCheckUserPrivilegesReq(username, PrivilegeModelType.RELATIONAL.ordinal(), permission.ordinal(), false).setDatabase(database));
    }

    @Override
    public TSStatus checkUserDBPrivilegesGrantOpt(String username, String database, PrivilegeType permission) {
        this.checkCacheAvailable();
        return this.checkPrivilege(username, new PrivilegeUnion(database, permission, true), (role, union) -> role.checkDatabasePrivilegeGrantOption(union.getDBName(), union.getPrivilegeType()), new TCheckUserPrivilegesReq(username, PrivilegeModelType.RELATIONAL.ordinal(), permission.ordinal(), true).setDatabase(database));
    }

    @Override
    public TSStatus checkUserTBPrivileges(String username, String database, String table, PrivilegeType permission) {
        this.checkCacheAvailable();
        return this.checkPrivilege(username, new PrivilegeUnion(database, table, permission), (role, union) -> role.checkTablePrivilege(union.getDBName(), union.getTbName(), union.getPrivilegeType()), new TCheckUserPrivilegesReq(username, PrivilegeModelType.RELATIONAL.ordinal(), permission.ordinal(), false).setDatabase(database).setTable(table));
    }

    @Override
    public TSStatus checkUserTBPrivilegesGrantOpt(String username, String database, String table, PrivilegeType permission) {
        this.checkCacheAvailable();
        return this.checkPrivilege(username, new PrivilegeUnion(database, table, permission, true), (role, union) -> role.checkTablePrivilegeGrantOption(union.getDBName(), union.getTbName(), union.getPrivilegeType()), new TCheckUserPrivilegesReq(username, PrivilegeModelType.RELATIONAL.ordinal(), permission.ordinal(), true).setDatabase(database).setTable(table));
    }

    @Override
    public TSStatus checkUserAnyScopePrivilegeGrantOption(String username, PrivilegeType permission) {
        this.checkCacheAvailable();
        return this.checkPrivilege(username, new PrivilegeUnion(permission, false, true), (role, union) -> role.checkAnyScopePrivilegeGrantOption(union.getPrivilegeType()), new TCheckUserPrivilegesReq(username, PrivilegeModelType.RELATIONAL.ordinal(), permission.ordinal(), true));
    }

    @Override
    public TSStatus checkDBVisible(String username, String database) {
        this.checkCacheAvailable();
        return this.checkPrivilege(username, new PrivilegeUnion(database, null, false), (role, union) -> role.checkDBVisible(union.getDBName()), new TCheckUserPrivilegesReq(username, PrivilegeModelType.RELATIONAL.ordinal(), -1, false).setDatabase(database));
    }

    @Override
    public TSStatus checkTBVisible(String username, String database, String table) {
        this.checkCacheAvailable();
        return this.checkPrivilege(username, new PrivilegeUnion(database, table, null, false), (role, union) -> role.checkTBVisible(union.getDBName(), union.getTbName()), new TCheckUserPrivilegesReq(username, PrivilegeModelType.RELATIONAL.ordinal(), -1, false).setDatabase(database).setTable(table));
    }

    @Override
    public PathPatternTree getAuthorizedPatternTree(String username, PrivilegeType permission) throws AuthException {
        PathPatternTree patternTree = new PathPatternTree();
        User user = this.iAuthorCache.getUserCache(username);
        if (user != null) {
            for (PathPrivilege path : user.getPathPrivilegeList()) {
                if (!path.checkPrivilege(permission)) continue;
                patternTree.appendPathPattern(path.getPath());
            }
            for (String roleName : user.getRoleSet()) {
                Role role = this.iAuthorCache.getRoleCache(roleName);
                if (role != null) {
                    for (PathPrivilege path : role.getPathPrivilegeList()) {
                        if (!path.checkPrivilege(permission)) continue;
                        patternTree.appendPathPattern(path.getPath());
                    }
                    continue;
                }
                return this.fetchAuthizedPatternTree(username, permission);
            }
            patternTree.constructTree();
            return patternTree;
        }
        return this.fetchAuthizedPatternTree(username, permission);
    }

    private PathPatternTree fetchAuthizedPatternTree(String username, PrivilegeType permission) throws AuthException {
        TCheckUserPrivilegesReq req = new TCheckUserPrivilegesReq(username, PrivilegeModelType.TREE.ordinal(), permission.ordinal(), false);
        TAuthizedPatternTreeResp authizedPatternTree = new TAuthizedPatternTreeResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            authizedPatternTree = configNodeClient.fetchAuthizedPatternTree(req);
        }
        catch (ClientManagerException | TException e) {
            LOGGER.error(CONNECTERROR);
            authizedPatternTree.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)CONNECTERROR));
        }
        if (authizedPatternTree.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            if (this.acceptCache) {
                this.iAuthorCache.putUserCache(username, this.cacheUser(authizedPatternTree.getPermissionInfo()));
            }
            return PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(authizedPatternTree.getPathPatternTree()));
        }
        throw new AuthException(TSStatusCode.EXECUTE_STATEMENT_ERROR, authizedPatternTree.getStatus().getMessage());
    }

    private SettableFuture<ConfigTaskResult> operatePermissionInternal(Object plan, boolean isRelational) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus;
            TSStatus tSStatus = tsStatus = isRelational ? configNodeClient.operateRPermission(this.statementToAuthorizerReq((RelationalAuthorStatement)plan)) : configNodeClient.operatePermission(this.statementToAuthorizerReq((AuthorStatement)plan));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (AuthException e) {
            future.setException((Throwable)e);
        }
        catch (ClientManagerException | TException e) {
            LOGGER.error(CONNECTERROR);
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> operatePermission(AuthorStatement authorStatement) {
        return this.operatePermissionInternal(authorStatement, false);
    }

    @Override
    public SettableFuture<ConfigTaskResult> operatePermission(RelationalAuthorStatement authorStatement) {
        return this.operatePermissionInternal(authorStatement, true);
    }

    private SettableFuture<ConfigTaskResult> queryPermissionInternal(Object plan, boolean isRelational) {
        SettableFuture future = SettableFuture.create();
        TAuthorizerResp authorizerResp = new TAuthorizerResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TAuthorizerResp tAuthorizerResp = authorizerResp = isRelational ? configNodeClient.queryRPermission(this.statementToAuthorizerReq((RelationalAuthorStatement)plan)) : configNodeClient.queryPermission(this.statementToAuthorizerReq((AuthorStatement)plan));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != authorizerResp.getStatus().getCode()) {
                future.setException((Throwable)new IoTDBException(authorizerResp.getStatus().message, authorizerResp.getStatus().code));
            } else {
                AuthorityChecker.buildTSBlock(authorizerResp, (SettableFuture<ConfigTaskResult>)future);
            }
        }
        catch (AuthException e) {
            future.setException((Throwable)e);
        }
        catch (ClientManagerException | TException e) {
            LOGGER.error(CONNECTERROR);
            authorizerResp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)CONNECTERROR));
            future.setException((Throwable)new IoTDBException(authorizerResp.getStatus().message, authorizerResp.getStatus().code));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> queryPermission(AuthorStatement authorStatement) {
        return this.queryPermissionInternal(authorStatement, false);
    }

    @Override
    public SettableFuture<ConfigTaskResult> queryPermission(RelationalAuthorStatement authorStatement) {
        return this.queryPermissionInternal(authorStatement, true);
    }

    @Override
    public IAuthorCache getAuthorCache() {
        return this.iAuthorCache;
    }

    @Override
    public void refreshToken() {
        long currentTime = System.currentTimeMillis();
        if (this.heartBeatTimeStamp == 0L) {
            this.heartBeatTimeStamp = currentTime;
            return;
        }
        if (currentTime - this.heartBeatTimeStamp > CONFIG.getDatanodeTokenTimeoutMS()) {
            this.cacheOutDate = true;
        }
        this.heartBeatTimeStamp = currentTime;
    }

    private void checkCacheAvailable() {
        if (this.cacheOutDate) {
            this.iAuthorCache.invalidAllCache();
        }
        this.cacheOutDate = false;
    }

    @TestOnly
    public void setAcceptCache(boolean acceptCache) {
        this.acceptCache = acceptCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TSStatus checkUser(String username, String password) {
        this.checkCacheAvailable();
        User user = this.iAuthorCache.getUserCache(username);
        if (user != null) {
            if (user.isOpenIdUser()) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            if (password != null && AuthUtils.validatePassword((String)password, (String)user.getPassword())) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRONG_LOGIN_PASSWORD, (String)"Authentication failed.");
        }
        TLoginReq req = new TLoginReq(username, password);
        TPermissionInfoResp status = null;
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            status = configNodeClient.login(req);
        }
        catch (ClientManagerException | TException e) {
            LOGGER.error(CONNECTERROR);
            status = new TPermissionInfoResp();
            status.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)CONNECTERROR));
        }
        finally {
            if (status == null) {
                status = new TPermissionInfoResp();
            }
        }
        if (status.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            if (this.acceptCache) {
                this.iAuthorCache.putUserCache(username, this.cacheUser(status));
            }
            return status.getStatus();
        }
        return status.getStatus();
    }

    @Override
    public boolean checkRole(String userName, String roleName) {
        this.checkCacheAvailable();
        User user = this.iAuthorCache.getUserCache(userName);
        if (user != null) {
            return user.isOpenIdUser() || user.getRoleSet().contains(roleName);
        }
        return this.checkRoleFromConfigNode(userName, roleName);
    }

    private TPermissionInfoResp checkPrivilegeFromConfigNode(TCheckUserPrivilegesReq req) {
        TPermissionInfoResp permissionInfoResp;
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            permissionInfoResp = configNodeClient.checkUserPrivileges(req);
        }
        catch (ClientManagerException | TException e) {
            LOGGER.error(CONNECTERROR);
            permissionInfoResp = new TPermissionInfoResp();
            permissionInfoResp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)CONNECTERROR));
        }
        if (permissionInfoResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && this.acceptCache) {
            this.iAuthorCache.putUserCache(req.getUsername(), this.cacheUser(permissionInfoResp));
        }
        return permissionInfoResp;
    }

    private List<Integer> checkPathFromConfigNode(String username, List<? extends PartialPath> allPath, PrivilegeType permission) {
        TCheckUserPrivilegesReq req = new TCheckUserPrivilegesReq(username, PrivilegeModelType.TREE.ordinal(), permission.ordinal(), false);
        req.setPaths(AuthUtils.serializePartialPathList(allPath));
        return this.checkPrivilegeFromConfigNode(req).getFailPos();
    }

    private boolean checkRoleFromConfigNode(String username, String rolename) {
        TPermissionInfoResp permissionInfoResp;
        TAuthorizerReq req = new TAuthorizerReq();
        req.setAuthorType(0);
        req.setPassword("");
        req.setNewPassword("");
        req.setNodeNameList(AuthUtils.serializePartialPathList(Collections.emptyList()));
        req.setPermissions(Collections.emptySet());
        req.setGrantOpt(false);
        req.setUserName(username);
        req.setRoleName(rolename);
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            permissionInfoResp = configNodeClient.checkRoleOfUser(req);
        }
        catch (ClientManagerException | TException e) {
            LOGGER.error(CONNECTERROR);
            permissionInfoResp = new TPermissionInfoResp();
            permissionInfoResp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)CONNECTERROR));
        }
        if (permissionInfoResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            if (this.acceptCache) {
                this.iAuthorCache.putUserCache(username, this.cacheUser(permissionInfoResp));
            }
            return true;
        }
        if (permissionInfoResp.getStatus().getCode() == TSStatusCode.USER_NOT_HAS_ROLE.getStatusCode()) {
            if (this.acceptCache) {
                this.iAuthorCache.putUserCache(username, this.cacheUser(permissionInfoResp));
            }
            return false;
        }
        return false;
    }

    public User cacheUser(TPermissionInfoResp tPermissionInfoResp) {
        User user = new User();
        List privilegeList = tPermissionInfoResp.getUserInfo().getPermissionInfo().getPrivilegeList();
        user.setName(tPermissionInfoResp.getUserInfo().getPermissionInfo().getName());
        user.setPassword(tPermissionInfoResp.getUserInfo().getPassword());
        user.loadDatabaseAndTablePrivilegeInfo(tPermissionInfoResp.getUserInfo().getPermissionInfo().getDbPrivilegeMap());
        user.setAnyScopePrivilegeSetInt(tPermissionInfoResp.getUserInfo().getPermissionInfo().getAnyScopeSet());
        user.setAnyScopePrivilegeGrantOptSetInt(tPermissionInfoResp.getUserInfo().getPermissionInfo().getAnyScopeGrantSet());
        user.setOpenIdUser(tPermissionInfoResp.getUserInfo().isIsOpenIdUser());
        user.setRoleSet(tPermissionInfoResp.getUserInfo().getRoleSet());
        user.setSysPrivilegeSetInt(tPermissionInfoResp.getUserInfo().getPermissionInfo().getSysPriSet());
        user.setSysPriGrantOptInt(tPermissionInfoResp.getUserInfo().getPermissionInfo().getSysPriSetGrantOpt());
        try {
            user.loadTreePrivilegeInfo(privilegeList);
        }
        catch (MetadataException e) {
            LOGGER.error("cache user's path privileges error", (Throwable)e);
        }
        if (tPermissionInfoResp.isSetRoleInfo()) {
            for (String roleName : tPermissionInfoResp.getRoleInfo().keySet()) {
                this.iAuthorCache.putRoleCache(roleName, this.cacheRole(roleName, tPermissionInfoResp));
            }
        }
        return user;
    }

    public Role cacheRole(String roleName, TPermissionInfoResp tPermissionInfoResp) {
        TRoleResp resp = (TRoleResp)tPermissionInfoResp.getRoleInfo().get(roleName);
        Role role = new Role(resp.getName());
        role.setAnyScopePrivilegeSetInt(resp.getAnyScopeSet());
        role.setAnyScopePrivilegeGrantOptSetInt(resp.getAnyScopeGrantSet());
        role.loadDatabaseAndTablePrivilegeInfo(resp.getDbPrivilegeMap());
        role.setSysPriGrantOptInt(((TRoleResp)tPermissionInfoResp.getRoleInfo().get(roleName)).getSysPriSetGrantOpt());
        role.setSysPrivilegeSetInt(((TRoleResp)tPermissionInfoResp.getRoleInfo().get(roleName)).getSysPriSet());
        try {
            role.loadTreePrivilegeInfo(resp.getPrivilegeList());
        }
        catch (MetadataException e) {
            LOGGER.error("cache role's path privileges error", (Throwable)e);
        }
        return role;
    }

    private TAuthorizerReq statementToAuthorizerReq(AuthorStatement authorStatement) throws AuthException {
        if (authorStatement.getAuthorType() == null) {
            authorStatement.setNodeNameList(new ArrayList<PartialPath>());
        }
        return new TAuthorizerReq(authorStatement.getAuthorType().ordinal(), authorStatement.getUserName() == null ? "" : authorStatement.getUserName(), authorStatement.getRoleName() == null ? "" : authorStatement.getRoleName(), authorStatement.getPassWord() == null ? "" : authorStatement.getPassWord(), authorStatement.getNewPassword() == null ? "" : authorStatement.getNewPassword(), AuthUtils.strToPermissions((String[])authorStatement.getPrivilegeList()), authorStatement.getGrantOpt(), AuthUtils.serializePartialPathList(authorStatement.getNodeNameList()));
    }

    private TAuthorizerRelationalReq statementToAuthorizerReq(RelationalAuthorStatement authorStatement) {
        return new TAuthorizerRelationalReq(authorStatement.getAuthorType().ordinal(), authorStatement.getUserName() == null ? "" : authorStatement.getUserName(), authorStatement.getRoleName() == null ? "" : authorStatement.getRoleName(), authorStatement.getPassword() == null ? "" : authorStatement.getPassword(), authorStatement.getDatabase() == null ? "" : authorStatement.getDatabase(), authorStatement.getTableName() == null ? "" : authorStatement.getTableName(), authorStatement.getPrivilegeTypes() == null ? Collections.emptySet() : authorStatement.getPrivilegeIds(), authorStatement.isGrantOption());
    }
}

