/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.file.metadata;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.tsfile.enums.ColumnCategory;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.tsfile.file.metadata.TableSchema;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class LogicalTableSchema
extends TableSchema {
    private int maxLevel;

    public LogicalTableSchema(String tableName) {
        super(tableName);
    }

    @Override
    public void update(ChunkGroupMetadata chunkGroupMetadata) {
        super.update(chunkGroupMetadata);
        this.maxLevel = Math.max(this.maxLevel, chunkGroupMetadata.getDevice().segmentNum());
    }

    private List<IMeasurementSchema> generateIdColumns() {
        ArrayList<IMeasurementSchema> generatedIdColumns = new ArrayList<IMeasurementSchema>();
        for (int i = 1; i < this.maxLevel; ++i) {
            generatedIdColumns.add(new MeasurementSchema("__level" + i, TSDataType.STRING, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED));
        }
        return generatedIdColumns;
    }

    public void finalizeColumnSchema() {
        if (!this.updatable) {
            return;
        }
        ArrayList<IMeasurementSchema> allColumns = new ArrayList<IMeasurementSchema>(this.generateIdColumns());
        List allColumnCategories = ColumnCategory.nCopy((ColumnCategory)ColumnCategory.TAG, (int)allColumns.size());
        allColumns.addAll(this.measurementSchemas);
        allColumnCategories.addAll(this.columnCategories);
        this.measurementSchemas = allColumns;
        this.columnCategories = allColumnCategories;
        this.updatable = false;
    }

    @Override
    public int serialize(OutputStream out) throws IOException {
        this.finalizeColumnSchema();
        return super.serialize(out);
    }
}

