/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.region;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.manager.load.balancer.region.IRegionGroupAllocator;

public class GreedyCopySetRegionGroupAllocator
implements IRegionGroupAllocator {
    private static final Random RANDOM = new Random();
    private static final int GCR_MAX_OPTIMAL_PLAN_NUM = 100;
    private int replicationFactor;
    private int[] dataNodeIds;
    private int[] regionCounter;
    private int[] databaseRegionCounter;
    private int[][] combinationCounter;
    private Map<String, int[]> initialDbLoad;
    int optimalRegionSum;
    int optimalDatabaseRegionSum;
    int optimalCombinationSum;
    List<int[]> optimalReplicaSets;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TRegionReplicaSet generateOptimalRegionReplicasDistribution(Map<Integer, TDataNodeConfiguration> availableDataNodeMap, Map<Integer, Double> freeDiskSpaceMap, List<TRegionReplicaSet> allocatedRegionGroups, List<TRegionReplicaSet> databaseAllocatedRegionGroups, int replicationFactor, TConsensusGroupId consensusGroupId) {
        try {
            this.replicationFactor = replicationFactor;
            this.prepare(availableDataNodeMap, allocatedRegionGroups, databaseAllocatedRegionGroups);
            this.dfsAllocateReplica(-1, 0, new int[replicationFactor], 0, 0);
            Collections.shuffle(this.optimalReplicaSets);
            int[] optimalReplicaSet = this.optimalReplicaSets.get(0);
            TRegionReplicaSet result = new TRegionReplicaSet();
            result.setRegionId(consensusGroupId);
            for (int i = 0; i < replicationFactor; ++i) {
                result.addToDataNodeLocations(availableDataNodeMap.get(optimalReplicaSet[i]).getLocation());
            }
            TRegionReplicaSet tRegionReplicaSet = result;
            return tRegionReplicaSet;
        }
        finally {
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TConsensusGroupId, TDataNodeConfiguration> removeNodeReplicaSelect(Map<Integer, TDataNodeConfiguration> availableDataNodeMap, Map<Integer, Double> freeDiskSpaceMap, List<TRegionReplicaSet> allocatedRegionGroups, Map<TConsensusGroupId, String> regionDatabaseMap, Map<String, List<TRegionReplicaSet>> databaseAllocatedRegionGroupMap, Map<TConsensusGroupId, TRegionReplicaSet> remainReplicasMap) {
        try {
            this.prepare(availableDataNodeMap, allocatedRegionGroups, Collections.emptyList());
            this.computeInitialDbLoad(databaseAllocatedRegionGroupMap);
            ArrayList<TConsensusGroupId> regionKeys = new ArrayList<TConsensusGroupId>(remainReplicasMap.keySet());
            HashMap<TConsensusGroupId, List<Integer>> allowedCandidatesMap = new HashMap<TConsensusGroupId, List<Integer>>();
            for (TConsensusGroupId regionId : regionKeys) {
                TRegionReplicaSet remainReplicaSet = remainReplicasMap.get(regionId);
                HashSet<Integer> notAllowedNodes = new HashSet<Integer>();
                for (Object location : remainReplicaSet.getDataNodeLocations()) {
                    notAllowedNodes.add(location.getDataNodeId());
                }
                List candidates = availableDataNodeMap.keySet().stream().filter(nodeId -> !notAllowedNodes.contains(nodeId)).sorted((a, b) -> {
                    int cmp = Integer.compare(this.regionCounter[a], this.regionCounter[b]);
                    if (cmp == 0) {
                        cmp = Integer.compare(this.databaseRegionCounter[a], this.databaseRegionCounter[b]);
                    }
                    return cmp;
                }).collect(Collectors.toList());
                allowedCandidatesMap.put(regionId, candidates);
            }
            regionKeys.sort(Comparator.comparingInt(id -> ((List)allowedCandidatesMap.get(id)).size()));
            int n = regionKeys.size();
            int[] currentAssignment = new int[n];
            int[] additionalLoad = new int[this.regionCounter.length];
            ArrayList<int[]> optimalAssignments = new ArrayList<int[]>();
            int[] bestMetrics = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
            this.dfsRemoveNodeReplica(0, regionKeys, allowedCandidatesMap, currentAssignment, additionalLoad, optimalAssignments, bestMetrics, remainReplicasMap, regionDatabaseMap);
            if (optimalAssignments.isEmpty()) {
                Object location;
                location = Collections.emptyMap();
                return location;
            }
            Collections.shuffle(optimalAssignments);
            int[] bestAssignment = (int[])optimalAssignments.get(0);
            HashMap<TConsensusGroupId, TDataNodeConfiguration> result = new HashMap<TConsensusGroupId, TDataNodeConfiguration>();
            for (int i = 0; i < n; ++i) {
                TConsensusGroupId regionId = (TConsensusGroupId)regionKeys.get(i);
                int chosenNodeId = bestAssignment[i];
                result.put(regionId, availableDataNodeMap.get(chosenNodeId));
            }
            HashMap<TConsensusGroupId, TDataNodeConfiguration> hashMap = result;
            return hashMap;
        }
        finally {
            this.clear();
        }
    }

    private void dfsRemoveNodeReplica(int index, List<TConsensusGroupId> regionKeys, Map<TConsensusGroupId, List<Integer>> allowedCandidatesMap, int[] currentAssignment, int[] additionalLoad, List<int[]> optimalAssignments, int[] bestMetrics, Map<TConsensusGroupId, TRegionReplicaSet> remainReplicasMap, Map<TConsensusGroupId, String> regionDatabaseMap) {
        int n = regionKeys.size();
        if (index == n) {
            int currentScatter = 0;
            for (int r = 0; r < n; ++r) {
                TConsensusGroupId regionId = regionKeys.get(r);
                for (TDataNodeLocation location : remainReplicasMap.get(regionId).getDataNodeLocations()) {
                    int nodeA = currentAssignment[r];
                    int nodeB = location.getDataNodeId();
                    currentScatter += this.combinationCounter[nodeA][nodeB];
                }
            }
            int[] currentMetrics = this.getCurrentMetrics(additionalLoad, currentScatter, regionKeys, regionDatabaseMap, currentAssignment);
            boolean isBetter = false;
            boolean isEqual = true;
            for (int i = 0; i < 3; ++i) {
                if (currentMetrics[i] < bestMetrics[i]) {
                    isBetter = true;
                    isEqual = false;
                    break;
                }
                if (currentMetrics[i] <= bestMetrics[i]) continue;
                isEqual = false;
                break;
            }
            if (isBetter) {
                bestMetrics[0] = currentMetrics[0];
                bestMetrics[1] = currentMetrics[1];
                bestMetrics[2] = currentMetrics[2];
                optimalAssignments.clear();
                optimalAssignments.add(Arrays.copyOf(currentAssignment, n));
            } else if (isEqual) {
                optimalAssignments.add(Arrays.copyOf(currentAssignment, n));
                if (optimalAssignments.size() >= 100) {
                    return;
                }
            }
            return;
        }
        TConsensusGroupId regionId = regionKeys.get(index);
        List<Integer> candidates = allowedCandidatesMap.get(regionId);
        for (Integer candidate : candidates) {
            currentAssignment[index] = candidate;
            int n2 = candidate;
            additionalLoad[n2] = additionalLoad[n2] + 1;
            this.dfsRemoveNodeReplica(index + 1, regionKeys, allowedCandidatesMap, currentAssignment, additionalLoad, optimalAssignments, bestMetrics, remainReplicasMap, regionDatabaseMap);
            int n3 = candidate;
            additionalLoad[n3] = additionalLoad[n3] - 1;
        }
    }

    private int computeDatabaseLoadSquaredSum(int[] currentAssignment, List<TConsensusGroupId> regionKeys, Map<TConsensusGroupId, String> regionDatabaseMap) {
        HashMap<String, int[]> extraLoadPerDb = new HashMap<String, int[]>();
        for (String db : this.initialDbLoad.keySet()) {
            extraLoadPerDb.put(db, new int[this.regionCounter.length]);
        }
        for (int i = 0; i < regionKeys.size(); ++i) {
            TConsensusGroupId regionId = regionKeys.get(i);
            String db = regionDatabaseMap.get(regionId);
            int nodeId = currentAssignment[i];
            int[] nArray = (int[])extraLoadPerDb.get(db);
            int n = nodeId;
            nArray[n] = nArray[n] + 1;
        }
        int sumSquared = 0;
        for (String db : this.initialDbLoad.keySet()) {
            int[] initLoads = this.initialDbLoad.get(db);
            int[] extras = (int[])extraLoadPerDb.get(db);
            int maxLoad = 0;
            for (int nodeId = 0; nodeId < this.regionCounter.length; ++nodeId) {
                int load = initLoads[nodeId] + extras[nodeId];
                if (load <= maxLoad) continue;
                maxLoad = load;
            }
            sumSquared += maxLoad * maxLoad;
        }
        return sumSquared;
    }

    private int[] getCurrentMetrics(int[] additionalLoad, int currentScatter, List<TConsensusGroupId> regionKeys, Map<TConsensusGroupId, String> regionDatabaseMap, int[] currentAssignment) {
        int currentMaxGlobalLoad = 0;
        for (int nodeId = 0; nodeId < additionalLoad.length; ++nodeId) {
            int globalLoad = this.regionCounter[nodeId] + additionalLoad[nodeId];
            currentMaxGlobalLoad = Math.max(currentMaxGlobalLoad, globalLoad);
        }
        int dbLoadSquaredSum = this.computeDatabaseLoadSquaredSum(currentAssignment, regionKeys, regionDatabaseMap);
        return new int[]{currentMaxGlobalLoad, dbLoadSquaredSum, currentScatter};
    }

    private void computeInitialDbLoad(Map<String, List<TRegionReplicaSet>> databaseAllocatedRegionGroupMap) {
        this.initialDbLoad = new HashMap<String, int[]>();
        for (String database : databaseAllocatedRegionGroupMap.keySet()) {
            List<TRegionReplicaSet> replicaSets = databaseAllocatedRegionGroupMap.get(database);
            int[] load = new int[this.regionCounter.length];
            for (TRegionReplicaSet replicaSet : replicaSets) {
                for (TDataNodeLocation location : replicaSet.getDataNodeLocations()) {
                    int nodeId;
                    int n = nodeId = location.getDataNodeId();
                    load[n] = load[n] + 1;
                }
            }
            this.initialDbLoad.put(database, load);
        }
    }

    private void prepare(Map<Integer, TDataNodeConfiguration> availableDataNodeMap, List<TRegionReplicaSet> allocatedRegionGroups, List<TRegionReplicaSet> databaseAllocatedRegionGroups) {
        List dataNodeLocations;
        int maxDataNodeId = Math.max(availableDataNodeMap.keySet().stream().max(Integer::compareTo).orElse(0), allocatedRegionGroups.stream().flatMap(regionGroup -> regionGroup.getDataNodeLocations().stream()).mapToInt(TDataNodeLocation::getDataNodeId).max().orElse(0));
        this.regionCounter = new int[maxDataNodeId + 1];
        Arrays.fill(this.regionCounter, 0);
        this.databaseRegionCounter = new int[maxDataNodeId + 1];
        Arrays.fill(this.databaseRegionCounter, 0);
        this.combinationCounter = new int[maxDataNodeId + 1][maxDataNodeId + 1];
        for (int i = 0; i <= maxDataNodeId; ++i) {
            Arrays.fill(this.combinationCounter[i], 0);
        }
        for (TRegionReplicaSet regionReplicaSet : allocatedRegionGroups) {
            dataNodeLocations = regionReplicaSet.getDataNodeLocations();
            for (int i = 0; i < dataNodeLocations.size(); ++i) {
                int n = ((TDataNodeLocation)dataNodeLocations.get(i)).getDataNodeId();
                this.regionCounter[n] = this.regionCounter[n] + 1;
                for (int j = i + 1; j < dataNodeLocations.size(); ++j) {
                    int[] nArray = this.combinationCounter[((TDataNodeLocation)dataNodeLocations.get(i)).getDataNodeId()];
                    int n2 = ((TDataNodeLocation)dataNodeLocations.get(j)).getDataNodeId();
                    nArray[n2] = nArray[n2] + 1;
                    int[] nArray2 = this.combinationCounter[((TDataNodeLocation)dataNodeLocations.get(j)).getDataNodeId()];
                    int n3 = ((TDataNodeLocation)dataNodeLocations.get(i)).getDataNodeId();
                    nArray2[n3] = nArray2[n3] + 1;
                }
            }
        }
        for (TRegionReplicaSet regionReplicaSet : databaseAllocatedRegionGroups) {
            dataNodeLocations = regionReplicaSet.getDataNodeLocations();
            for (TDataNodeLocation dataNodeLocation : dataNodeLocations) {
                int n = dataNodeLocation.getDataNodeId();
                this.databaseRegionCounter[n] = this.databaseRegionCounter[n] + 1;
            }
        }
        HashMap dataNodeEntryMap = new HashMap(maxDataNodeId + 1);
        availableDataNodeMap.keySet().forEach(dataNodeId -> {
            int scatterWidth = 0;
            for (int j = 0; j <= maxDataNodeId; ++j) {
                if (this.combinationCounter[dataNodeId][j] <= 0) continue;
                ++scatterWidth;
            }
            dataNodeEntryMap.put(dataNodeId, new DataNodeEntry(this.databaseRegionCounter[dataNodeId], this.regionCounter[dataNodeId], scatterWidth));
        });
        this.dataNodeIds = dataNodeEntryMap.entrySet().stream().sorted(Map.Entry.comparingByValue(DataNodeEntry::compare)).map(Map.Entry::getKey).collect(Collectors.toList()).stream().mapToInt(Integer::intValue).toArray();
        this.optimalDatabaseRegionSum = Integer.MAX_VALUE;
        this.optimalRegionSum = Integer.MAX_VALUE;
        this.optimalCombinationSum = Integer.MAX_VALUE;
        this.optimalReplicaSets = new ArrayList<int[]>();
    }

    private void dfsAllocateReplica(int lastIndex, int currentReplica, int[] currentReplicaSet, int databaseRegionSum, int regionSum) {
        if (regionSum > this.optimalRegionSum) {
            return;
        }
        if (regionSum == this.optimalRegionSum && databaseRegionSum > this.optimalDatabaseRegionSum) {
            return;
        }
        if (currentReplica == this.replicationFactor) {
            int combinationSum = 0;
            for (int i = 0; i < this.replicationFactor; ++i) {
                for (int j = i + 1; j < this.replicationFactor; ++j) {
                    combinationSum += this.combinationCounter[currentReplicaSet[i]][currentReplicaSet[j]];
                }
            }
            if (regionSum == this.optimalRegionSum && databaseRegionSum == this.optimalDatabaseRegionSum && combinationSum > this.optimalCombinationSum) {
                return;
            }
            if (regionSum < this.optimalRegionSum || databaseRegionSum < this.optimalDatabaseRegionSum || combinationSum < this.optimalCombinationSum) {
                this.optimalDatabaseRegionSum = databaseRegionSum;
                this.optimalRegionSum = regionSum;
                this.optimalCombinationSum = combinationSum;
                this.optimalReplicaSets.clear();
            }
            this.optimalReplicaSets.add(Arrays.copyOf(currentReplicaSet, this.replicationFactor));
            return;
        }
        for (int i = lastIndex + 1; i < this.dataNodeIds.length; ++i) {
            currentReplicaSet[currentReplica] = this.dataNodeIds[i];
            this.dfsAllocateReplica(i, currentReplica + 1, currentReplicaSet, databaseRegionSum + this.databaseRegionCounter[this.dataNodeIds[i]], regionSum + this.regionCounter[this.dataNodeIds[i]]);
            if (this.optimalReplicaSets.size() != 100) continue;
            return;
        }
    }

    void clear() {
        this.optimalReplicaSets.clear();
    }

    private static class DataNodeEntry {
        private final int regionCount;
        private final int databaseRegionCount;
        private final int scatterWidth;
        private final int randomWeight;

        public DataNodeEntry(int databaseRegionCount, int regionCount, int scatterWidth) {
            this.databaseRegionCount = databaseRegionCount;
            this.regionCount = regionCount;
            this.scatterWidth = scatterWidth;
            this.randomWeight = RANDOM.nextInt();
        }

        public int compare(DataNodeEntry e) {
            return this.regionCount != e.regionCount ? Integer.compare(this.regionCount, e.regionCount) : (this.databaseRegionCount != e.databaseRegionCount ? Integer.compare(this.databaseRegionCount, e.databaseRegionCount) : (this.scatterWidth != e.scatterWidth ? Integer.compare(this.scatterWidth, e.scatterWidth) : Integer.compare(this.randomWeight, e.randomWeight)));
        }
    }
}

