/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.agent;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.db.subscription.broker.SubscriptionBroker;
import org.apache.iotdb.db.subscription.event.SubscriptionEvent;
import org.apache.iotdb.db.subscription.resource.SubscriptionDataNodeResourceManager;
import org.apache.iotdb.db.subscription.task.subtask.SubscriptionConnectorSubtask;
import org.apache.iotdb.rpc.subscription.config.ConsumerConfig;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionBrokerAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionBrokerAgent.class);
    private final Map<String, SubscriptionBroker> consumerGroupIdToSubscriptionBroker = new ConcurrentHashMap<String, SubscriptionBroker>();

    public List<SubscriptionEvent> poll(ConsumerConfig consumerConfig, Set<String> topicNames, long maxBytes) {
        String consumerGroupId = consumerConfig.getConsumerGroupId();
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            String errorMessage = String.format("Subscription: broker bound to consumer group [%s] does not exist", consumerGroupId);
            LOGGER.warn(errorMessage);
            throw new SubscriptionException(errorMessage);
        }
        String consumerId = consumerConfig.getConsumerId();
        return broker.poll(consumerId, topicNames, maxBytes);
    }

    public List<SubscriptionEvent> pollTsFile(ConsumerConfig consumerConfig, SubscriptionCommitContext commitContext, long writingOffset) {
        String consumerGroupId = consumerConfig.getConsumerGroupId();
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            String errorMessage = String.format("Subscription: broker bound to consumer group [%s] does not exist", consumerGroupId);
            LOGGER.warn(errorMessage);
            throw new SubscriptionException(errorMessage);
        }
        String consumerId = consumerConfig.getConsumerId();
        return broker.pollTsFile(consumerId, commitContext, writingOffset);
    }

    public List<SubscriptionEvent> pollTablets(ConsumerConfig consumerConfig, SubscriptionCommitContext commitContext, int offset) {
        String consumerGroupId = consumerConfig.getConsumerGroupId();
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            String errorMessage = String.format("Subscription: broker bound to consumer group [%s] does not exist", consumerGroupId);
            LOGGER.warn(errorMessage);
            throw new SubscriptionException(errorMessage);
        }
        String consumerId = consumerConfig.getConsumerId();
        return broker.pollTablets(consumerId, commitContext, offset);
    }

    public List<SubscriptionCommitContext> commit(ConsumerConfig consumerConfig, List<SubscriptionCommitContext> commitContexts, boolean nack) {
        String consumerGroupId = consumerConfig.getConsumerGroupId();
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            String errorMessage = String.format("Subscription: broker bound to consumer group [%s] does not exist", consumerGroupId);
            LOGGER.warn(errorMessage);
            throw new SubscriptionException(errorMessage);
        }
        String consumerId = consumerConfig.getConsumerId();
        return broker.commit(consumerId, commitContexts, nack);
    }

    public boolean isCommitContextOutdated(SubscriptionCommitContext commitContext) {
        String consumerGroupId = commitContext.getConsumerGroupId();
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            return true;
        }
        return broker.isCommitContextOutdated(commitContext);
    }

    public boolean isBrokerExist(String consumerGroupId) {
        return this.consumerGroupIdToSubscriptionBroker.containsKey(consumerGroupId);
    }

    public void createBrokerIfNotExist(String consumerGroupId) {
        this.consumerGroupIdToSubscriptionBroker.computeIfAbsent(consumerGroupId, SubscriptionBroker::new);
        LOGGER.info("Subscription: create broker bound to consumer group [{}]", (Object)consumerGroupId);
    }

    public boolean dropBroker(String consumerGroupId) {
        AtomicBoolean dropped = new AtomicBoolean(false);
        this.consumerGroupIdToSubscriptionBroker.compute(consumerGroupId, (id, broker) -> {
            if (Objects.isNull(broker)) {
                LOGGER.warn("Subscription: broker bound to consumer group [{}] does not exist", (Object)consumerGroupId);
                dropped.set(true);
                return null;
            }
            if (!broker.isEmpty()) {
                LOGGER.warn("Subscription: broker bound to consumer group [{}] is not empty when dropping", (Object)consumerGroupId);
                return broker;
            }
            dropped.set(true);
            LOGGER.info("Subscription: drop broker bound to consumer group [{}]", (Object)consumerGroupId);
            return null;
        });
        return dropped.get();
    }

    public void bindPrefetchingQueue(SubscriptionConnectorSubtask subtask) {
        String consumerGroupId = subtask.getConsumerGroupId();
        this.consumerGroupIdToSubscriptionBroker.compute(consumerGroupId, (id, broker) -> {
            if (Objects.isNull(broker)) {
                LOGGER.info("Subscription: broker bound to consumer group [{}] does not exist, create new for binding prefetching queue", (Object)consumerGroupId);
                return new SubscriptionBroker(consumerGroupId);
            }
            return broker;
        }).bindPrefetchingQueue(subtask.getTopicName(), subtask.getInputPendingQueue());
    }

    public void unbindPrefetchingQueue(String consumerGroupId, String topicName) {
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            LOGGER.warn("Subscription: broker bound to consumer group [{}] does not exist", (Object)consumerGroupId);
            return;
        }
        broker.unbindPrefetchingQueue(topicName);
    }

    public void removePrefetchingQueue(String consumerGroupId, String topicName) {
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            LOGGER.warn("Subscription: broker bound to consumer group [{}] does not exist", (Object)consumerGroupId);
            return;
        }
        broker.removePrefetchingQueue(topicName);
    }

    public boolean executePrefetch(String consumerGroupId, String topicName) {
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            SubscriptionDataNodeResourceManager.log().schedule(SubscriptionBrokerAgent.class, consumerGroupId, topicName).ifPresent(l -> l.warn("Subscription: broker bound to consumer group [{}] does not exist", (Object)consumerGroupId));
            return false;
        }
        return broker.executePrefetch(topicName);
    }

    public int getPipeEventCount(String consumerGroupId, String topicName) {
        SubscriptionBroker broker = this.consumerGroupIdToSubscriptionBroker.get(consumerGroupId);
        if (Objects.isNull(broker)) {
            LOGGER.warn("Subscription: broker bound to consumer group [{}] does not exist", (Object)consumerGroupId);
            return 0;
        }
        return broker.getPipeEventCount(topicName);
    }

    public int getPrefetchingQueueCount() {
        return this.consumerGroupIdToSubscriptionBroker.values().stream().map(SubscriptionBroker::getPrefetchingQueueCount).reduce(0, Integer::sum);
    }
}

