/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.attribute.update;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;

@NotThreadSafe
class RewritableByteArrayOutputStream
extends ByteArrayOutputStream {
    private static final byte[] intPlaceHolder = new byte[4];

    RewritableByteArrayOutputStream() {
    }

    void writeWithLength(byte[] bytes) throws IOException {
        if (Objects.isNull(bytes)) {
            ReadWriteIOUtils.write((int)-1, (OutputStream)this);
            return;
        }
        ReadWriteIOUtils.write((int)bytes.length, (OutputStream)this);
        this.write(bytes);
    }

    int skipInt() throws IOException {
        int result = this.count;
        this.write(intPlaceHolder);
        return result;
    }

    void rewrite(int n, int off) {
        byte[] bytes = BytesUtils.intToBytes((int)n);
        if (off < 0 || off > this.buf.length - bytes.length) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(bytes, 0, this.buf, off, bytes.length);
    }
}

