/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;

public class GetSeriesSlotListStatement
extends Statement
implements IConfigStatement {
    private final String database;
    private final TConsensusGroupType partitionType;

    public GetSeriesSlotListStatement(String database, TConsensusGroupType partitionType) {
        this.database = database;
        this.partitionType = partitionType;
    }

    public String getDatabase() {
        return this.database;
    }

    public TConsensusGroupType getPartitionType() {
        return this.partitionType;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitGetSeriesSlotList(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.READ;
    }

    public List<PartialPath> getPaths() {
        try {
            return Collections.singletonList(new PartialPath(this.database));
        }
        catch (IllegalPathException e) {
            return new ArrayList<PartialPath>();
        }
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        return AuthorityChecker.checkSuperUserOrMaintain(userName);
    }
}

