/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.async;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.connector.protocol.IoTDBConnector;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.connector.client.IoTDBDataNodeAsyncClientManager;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.batch.PipeTabletEventBatch;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.batch.PipeTabletEventPlainBatch;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.batch.PipeTabletEventTsFileBatch;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.batch.PipeTransferBatchReqBuilder;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBinaryReqV2;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletInsertNodeReqV2;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletRawReqV2;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTabletBatchEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTabletInsertNodeEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTabletRawEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTrackableHandler;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTsFileHandler;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.sync.IoTDBDataRegionSyncConnector;
import org.apache.iotdb.db.pipe.event.common.deletion.PipeDeleteDataNodeEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.terminate.PipeTerminateEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.metric.source.PipeDataRegionEventCounter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.pipe.api.annotation.TableModel;
import org.apache.iotdb.pipe.api.annotation.TreeModel;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.tsfile.exception.write.WriteProcessException;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TreeModel
@TableModel
public class IoTDBDataRegionAsyncConnector
extends IoTDBConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDataRegionAsyncConnector.class);
    private static final String THRIFT_ERROR_FORMATTER_WITHOUT_ENDPOINT = "Failed to borrow client from client pool when sending to receiver.";
    private static final String THRIFT_ERROR_FORMATTER_WITH_ENDPOINT = "Exception occurred while sending to receiver %s:%s.";
    private final IoTDBDataRegionSyncConnector syncConnector = new IoTDBDataRegionSyncConnector();
    private final BlockingQueue<Event> retryEventQueue = new LinkedBlockingQueue<Event>();
    private final PipeDataRegionEventCounter retryEventQueueEventCounter = new PipeDataRegionEventCounter();
    private IoTDBDataNodeAsyncClientManager clientManager;
    private PipeTransferBatchReqBuilder tabletBatchBuilder;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final Map<PipeTransferTrackableHandler, PipeTransferTrackableHandler> pendingHandlers = new ConcurrentHashMap<PipeTransferTrackableHandler, PipeTransferTrackableHandler>();

    public void validate(PipeParameterValidator validator) throws Exception {
        super.validate(validator);
        this.syncConnector.validate(validator);
        PipeParameters parameters = validator.getParameters();
        validator.validate(args -> (Boolean)args[0] == false && (Boolean)args[1] == false && (Boolean)args[2] == false, "Only 'iotdb-thrift-ssl-sink' supports SSL transmission currently.", new Object[]{parameters.getBooleanOrDefault("sink.ssl.enable", false), parameters.hasAttribute("sink.ssl.trust-store-path"), parameters.hasAttribute("sink.ssl.trust-store-pwd")});
    }

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        super.customize(parameters, configuration);
        this.syncConnector.customize(parameters, configuration);
        this.clientManager = new IoTDBDataNodeAsyncClientManager(this.nodeUrls, parameters.getBooleanOrDefault(Arrays.asList("sink.leader-cache.enable", "connector.leader-cache.enable"), true), this.loadBalanceStrategy, this.username, this.password, this.shouldReceiverConvertOnTypeMismatch, this.loadTsFileStrategy, this.loadTsFileValidation, this.shouldMarkAsPipeRequest);
        if (this.isTabletBatchModeEnabled) {
            this.tabletBatchBuilder = new PipeTransferBatchReqBuilder(parameters);
        }
    }

    public synchronized void handshake() throws Exception {
        this.syncConnector.handshake();
    }

    public void heartbeat() throws Exception {
        this.syncConnector.heartbeat();
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        this.transferQueuedEventsIfNecessary(false);
        if (!(tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) && !(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent)) {
            LOGGER.warn("IoTDBThriftAsyncConnector only support PipeInsertNodeTabletInsertionEvent and PipeRawTabletInsertionEvent. Current event: {}.", (Object)tabletInsertionEvent);
            return;
        }
        if (this.isTabletBatchModeEnabled) {
            Pair<TEndPoint, PipeTabletEventBatch> endPointAndBatch = this.tabletBatchBuilder.onEvent(tabletInsertionEvent);
            this.transferInBatchWithoutCheck(endPointAndBatch);
        } else {
            this.transferInEventWithoutCheck(tabletInsertionEvent);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void transferInBatchWithoutCheck(Pair<TEndPoint, PipeTabletEventBatch> endPointAndBatch) throws IOException, WriteProcessException, InterruptedException {
        if (Objects.isNull(endPointAndBatch)) {
            return;
        }
        batch = (PipeTabletEventBatch)endPointAndBatch.getRight();
        if (batch instanceof PipeTabletEventPlainBatch) {
            this.transfer((TEndPoint)endPointAndBatch.getLeft(), new PipeTransferTabletBatchEventHandler((PipeTabletEventPlainBatch)batch, this));
        } else if (batch instanceof PipeTabletEventTsFileBatch) {
            tsFileBatch = (PipeTabletEventTsFileBatch)batch;
            dbTsFilePairs = tsFileBatch.sealTsFiles();
            pipe2WeightMap = tsFileBatch.deepCopyPipe2WeightMap();
            events = tsFileBatch.deepCopyEvents();
            eventsReferenceCount = new AtomicInteger(dbTsFilePairs.size());
            eventsHadBeenAddedToRetryQueue = new AtomicBoolean(false);
            try {
                for (Pair<String, File> sealedFile : dbTsFilePairs) {
                    this.transfer(new PipeTransferTsFileHandler(this, pipe2WeightMap, events, eventsReferenceCount, eventsHadBeenAddedToRetryQueue, (File)sealedFile.right, null, false, (String)sealedFile.left));
                }
            }
            catch (Throwable t) {
                IoTDBDataRegionAsyncConnector.LOGGER.warn("Failed to transfer tsfile batch ({}).", dbTsFilePairs, (Object)t);
                if (!eventsHadBeenAddedToRetryQueue.compareAndSet(false, true)) ** GOTO lbl25
                this.addFailureEventsToRetryQueue(events);
            }
        } else {
            IoTDBDataRegionAsyncConnector.LOGGER.warn("Unsupported batch type {} when transferring tablet insertion event.", batch.getClass());
        }
lbl25:
        // 5 sources

        ((PipeTabletEventBatch)endPointAndBatch.getRight()).onSuccess();
    }

    private boolean transferInEventWithoutCheck(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
            PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent = (PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent;
            if (!pipeInsertNodeTabletInsertionEvent.increaseReferenceCount(IoTDBDataRegionAsyncConnector.class.getName())) {
                return false;
            }
            InsertNode insertNode = pipeInsertNodeTabletInsertionEvent.getInsertNodeViaCacheIfPossible();
            String databaseName = pipeInsertNodeTabletInsertionEvent.isTableModelEvent() ? pipeInsertNodeTabletInsertionEvent.getTableModelDatabaseName() : null;
            TPipeTransferReq pipeTransferReq = this.compressIfNeeded(Objects.isNull(insertNode) ? PipeTransferTabletBinaryReqV2.toTPipeTransferReq(pipeInsertNodeTabletInsertionEvent.getByteBuffer(), databaseName) : PipeTransferTabletInsertNodeReqV2.toTPipeTransferReq(insertNode, databaseName));
            PipeTransferTabletInsertNodeEventHandler pipeTransferInsertNodeReqHandler = new PipeTransferTabletInsertNodeEventHandler(pipeInsertNodeTabletInsertionEvent, pipeTransferReq, this);
            this.transfer(pipeInsertNodeTabletInsertionEvent.getDeviceId(), pipeTransferInsertNodeReqHandler);
        } else {
            PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent = (PipeRawTabletInsertionEvent)tabletInsertionEvent;
            if (!pipeRawTabletInsertionEvent.increaseReferenceCount(IoTDBDataRegionAsyncConnector.class.getName())) {
                return false;
            }
            TPipeTransferReq pipeTransferTabletRawReq = this.compressIfNeeded(PipeTransferTabletRawReqV2.toTPipeTransferReq(pipeRawTabletInsertionEvent.convertToTablet(), pipeRawTabletInsertionEvent.isAligned(), pipeRawTabletInsertionEvent.isTableModelEvent() ? pipeRawTabletInsertionEvent.getTableModelDatabaseName() : null));
            PipeTransferTabletRawEventHandler pipeTransferTabletReqHandler = new PipeTransferTabletRawEventHandler(pipeRawTabletInsertionEvent, pipeTransferTabletRawReq, this);
            this.transfer(pipeRawTabletInsertionEvent.getDeviceId(), pipeTransferTabletReqHandler);
        }
        return true;
    }

    private void transfer(TEndPoint endPoint, PipeTransferTabletBatchEventHandler pipeTransferTabletBatchEventHandler) {
        AsyncPipeDataTransferServiceClient client = null;
        try {
            client = this.clientManager.borrowClient(endPoint);
            pipeTransferTabletBatchEventHandler.transfer(client);
        }
        catch (Exception ex) {
            this.logOnClientException(client, ex);
            pipeTransferTabletBatchEventHandler.onError(ex);
        }
    }

    private void transfer(String deviceId, PipeTransferTabletInsertNodeEventHandler pipeTransferInsertNodeReqHandler) {
        AsyncPipeDataTransferServiceClient client = null;
        try {
            client = this.clientManager.borrowClient(deviceId);
            pipeTransferInsertNodeReqHandler.transfer(client);
        }
        catch (Exception ex) {
            this.logOnClientException(client, ex);
            pipeTransferInsertNodeReqHandler.onError(ex);
        }
    }

    private void transfer(String deviceId, PipeTransferTabletRawEventHandler pipeTransferTabletReqHandler) {
        AsyncPipeDataTransferServiceClient client = null;
        try {
            client = this.clientManager.borrowClient(deviceId);
            pipeTransferTabletReqHandler.transfer(client);
        }
        catch (Exception ex) {
            this.logOnClientException(client, ex);
            pipeTransferTabletReqHandler.onError(ex);
        }
    }

    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        this.transferQueuedEventsIfNecessary(false);
        this.transferBatchedEventsIfNecessary();
        if (!(tsFileInsertionEvent instanceof PipeTsFileInsertionEvent)) {
            LOGGER.warn("IoTDBThriftAsyncConnector only support PipeTsFileInsertionEvent. Current event: {}.", (Object)tsFileInsertionEvent);
            return;
        }
        this.transferWithoutCheck(tsFileInsertionEvent);
    }

    private boolean transferWithoutCheck(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        PipeTsFileInsertionEvent pipeTsFileInsertionEvent = (PipeTsFileInsertionEvent)tsFileInsertionEvent;
        if (!pipeTsFileInsertionEvent.increaseReferenceCount(IoTDBDataRegionAsyncConnector.class.getName())) {
            return false;
        }
        try {
            if (!pipeTsFileInsertionEvent.getTsFile().exists()) {
                throw new FileNotFoundException(pipeTsFileInsertionEvent.getTsFile().getAbsolutePath());
            }
            PipeTransferTsFileHandler pipeTransferTsFileHandler = new PipeTransferTsFileHandler(this, Collections.singletonMap(new Pair((Object)pipeTsFileInsertionEvent.getPipeName(), (Object)pipeTsFileInsertionEvent.getCreationTime()), 1.0), Collections.singletonList(pipeTsFileInsertionEvent), new AtomicInteger(1), new AtomicBoolean(false), pipeTsFileInsertionEvent.getTsFile(), pipeTsFileInsertionEvent.getModFile(), pipeTsFileInsertionEvent.isWithMod() && this.clientManager.supportModsIfIsDataNodeReceiver(), pipeTsFileInsertionEvent.isTableModelEvent() ? pipeTsFileInsertionEvent.getTableModelDatabaseName() : null);
            this.transfer(pipeTransferTsFileHandler);
            return true;
        }
        catch (Exception e) {
            pipeTsFileInsertionEvent.decreaseReferenceCount(IoTDBDataRegionAsyncConnector.class.getName(), false);
            throw e;
        }
    }

    private void transfer(PipeTransferTsFileHandler pipeTransferTsFileHandler) {
        AsyncPipeDataTransferServiceClient client = null;
        try {
            client = this.clientManager.borrowClient();
            pipeTransferTsFileHandler.transfer(this.clientManager, client);
        }
        catch (Exception ex) {
            this.logOnClientException(client, ex);
            pipeTransferTsFileHandler.onError(ex);
        }
    }

    public void transfer(Event event) throws Exception {
        this.transferQueuedEventsIfNecessary(true);
        this.transferBatchedEventsIfNecessary();
        if (!(event instanceof PipeHeartbeatEvent || event instanceof PipeDeleteDataNodeEvent || event instanceof PipeTerminateEvent)) {
            LOGGER.warn("IoTDBThriftAsyncConnector does not support transferring generic event: {}.", (Object)event);
            return;
        }
        this.syncConnector.transfer(event);
    }

    private void transferBatchedEventsIfNecessary() throws IOException, WriteProcessException, InterruptedException {
        if (!this.isTabletBatchModeEnabled || this.tabletBatchBuilder.isEmpty()) {
            return;
        }
        for (Pair<TEndPoint, PipeTabletEventBatch> endPointAndBatch : this.tabletBatchBuilder.getAllNonEmptyBatches()) {
            this.transferInBatchWithoutCheck(endPointAndBatch);
        }
    }

    public void updateLeaderCache(String deviceId, TEndPoint endPoint) {
        this.clientManager.updateLeaderCache(deviceId, endPoint);
    }

    private void logOnClientException(AsyncPipeDataTransferServiceClient client, Exception e) {
        if (client == null) {
            LOGGER.warn(THRIFT_ERROR_FORMATTER_WITHOUT_ENDPOINT);
        } else {
            client.resetMethodStateIfStopped();
            LOGGER.warn(String.format(THRIFT_ERROR_FORMATTER_WITH_ENDPOINT, client.getIp(), client.getPort()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferQueuedEventsIfNecessary(boolean forced) {
        if (this.retryEventQueue.isEmpty() || !forced && this.retryEventQueueEventCounter.getTabletInsertionEventCount() < PipeConfig.getInstance().getPipeAsyncConnectorForcedRetryTabletEventQueueSizeThreshold() && this.retryEventQueueEventCounter.getTsFileInsertionEventCount() < PipeConfig.getInstance().getPipeAsyncConnectorForcedRetryTsFileEventQueueSizeThreshold() && this.retryEventQueue.size() < PipeConfig.getInstance().getPipeAsyncConnectorForcedRetryTotalEventQueueSizeThreshold()) {
            return;
        }
        long retryStartTime = System.currentTimeMillis();
        int remainingEvents = this.retryEventQueue.size();
        while (!this.retryEventQueue.isEmpty()) {
            IoTDBDataRegionAsyncConnector ioTDBDataRegionAsyncConnector = this;
            synchronized (ioTDBDataRegionAsyncConnector) {
                if (this.isClosed.get()) {
                    return;
                }
                if (this.retryEventQueue.isEmpty()) {
                    break;
                }
                Event peekedEvent = (Event)this.retryEventQueue.peek();
                if (peekedEvent instanceof PipeInsertNodeTabletInsertionEvent) {
                    this.retryTransfer((PipeInsertNodeTabletInsertionEvent)peekedEvent);
                } else if (peekedEvent instanceof PipeRawTabletInsertionEvent) {
                    this.retryTransfer((PipeRawTabletInsertionEvent)peekedEvent);
                } else if (peekedEvent instanceof PipeTsFileInsertionEvent) {
                    this.retryTransfer((PipeTsFileInsertionEvent)peekedEvent);
                } else {
                    LOGGER.warn("IoTDBThriftAsyncConnector does not support transfer generic event: {}.", (Object)peekedEvent);
                }
                Event polledEvent = (Event)this.retryEventQueue.poll();
                this.retryEventQueueEventCounter.decreaseEventCount(polledEvent);
                if (polledEvent != peekedEvent) {
                    LOGGER.error("The event polled from the queue is not the same as the event peeked from the queue. Peeked event: {}, polled event: {}.", (Object)peekedEvent, (Object)polledEvent);
                }
                if (polledEvent != null && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Polled event {} from retry queue.", (Object)polledEvent);
                }
            }
            if (System.currentTimeMillis() - retryStartTime <= PipeConfig.getInstance().getPipeAsyncConnectorMaxRetryExecutionTimeMsPerCall()) continue;
            if (this.retryEventQueueEventCounter.getTabletInsertionEventCount() < PipeConfig.getInstance().getPipeAsyncConnectorForcedRetryTabletEventQueueSizeThreshold() && this.retryEventQueueEventCounter.getTsFileInsertionEventCount() < PipeConfig.getInstance().getPipeAsyncConnectorForcedRetryTsFileEventQueueSizeThreshold() && this.retryEventQueue.size() < PipeConfig.getInstance().getPipeAsyncConnectorForcedRetryTotalEventQueueSizeThreshold()) {
                return;
            }
            if (remainingEvents > this.retryEventQueue.size()) continue;
            throw new PipeException("Failed to retry transferring events in the retry queue. Remaining events: " + this.retryEventQueue.size() + " (tablet events: " + this.retryEventQueueEventCounter.getTabletInsertionEventCount() + ", tsfile events: " + this.retryEventQueueEventCounter.getTsFileInsertionEventCount() + ").");
        }
    }

    private void retryTransfer(TabletInsertionEvent tabletInsertionEvent) {
        if (this.isTabletBatchModeEnabled) {
            try {
                this.transferInBatchWithoutCheck(this.tabletBatchBuilder.onEvent(tabletInsertionEvent));
                if (tabletInsertionEvent instanceof EnrichedEvent) {
                    ((EnrichedEvent)tabletInsertionEvent).decreaseReferenceCount(IoTDBDataRegionAsyncConnector.class.getName(), false);
                }
            }
            catch (Exception e) {
                this.addFailureEventToRetryQueue((Event)tabletInsertionEvent);
            }
            return;
        }
        try {
            if (this.transferInEventWithoutCheck(tabletInsertionEvent)) {
                if (tabletInsertionEvent instanceof EnrichedEvent) {
                    ((EnrichedEvent)tabletInsertionEvent).decreaseReferenceCount(IoTDBDataRegionAsyncConnector.class.getName(), false);
                }
            } else {
                this.addFailureEventToRetryQueue((Event)tabletInsertionEvent);
            }
        }
        catch (Exception e) {
            if (tabletInsertionEvent instanceof EnrichedEvent) {
                ((EnrichedEvent)tabletInsertionEvent).decreaseReferenceCount(IoTDBDataRegionAsyncConnector.class.getName(), false);
            }
            this.addFailureEventToRetryQueue((Event)tabletInsertionEvent);
        }
    }

    private void retryTransfer(PipeTsFileInsertionEvent tsFileInsertionEvent) {
        try {
            if (this.transferWithoutCheck(tsFileInsertionEvent)) {
                tsFileInsertionEvent.decreaseReferenceCount(IoTDBDataRegionAsyncConnector.class.getName(), false);
            } else {
                this.addFailureEventToRetryQueue((Event)tsFileInsertionEvent);
            }
        }
        catch (Exception e) {
            tsFileInsertionEvent.decreaseReferenceCount(IoTDBDataRegionAsyncConnector.class.getName(), false);
            this.addFailureEventToRetryQueue((Event)tsFileInsertionEvent);
        }
    }

    public void addFailureEventToRetryQueue(Event event) {
        if (event instanceof EnrichedEvent && ((EnrichedEvent)event).isReleased()) {
            return;
        }
        if (this.isClosed.get()) {
            if (event instanceof EnrichedEvent) {
                ((EnrichedEvent)event).clearReferenceCount(IoTDBDataRegionAsyncConnector.class.getName());
            }
            return;
        }
        this.retryEventQueue.offer(event);
        this.retryEventQueueEventCounter.increaseEventCount(event);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Added event {} to retry queue.", (Object)event);
        }
        if (this.isClosed.get() && event instanceof EnrichedEvent) {
            ((EnrichedEvent)event).clearReferenceCount(IoTDBDataRegionAsyncConnector.class.getName());
        }
    }

    public void addFailureEventsToRetryQueue(Iterable<EnrichedEvent> events) {
        events.forEach(this::addFailureEventToRetryQueue);
    }

    public synchronized void discardEventsOfPipe(String pipeNameToDrop, int regionId) {
        if (this.isTabletBatchModeEnabled) {
            this.tabletBatchBuilder.discardEventsOfPipe(pipeNameToDrop, regionId);
        }
        this.retryEventQueue.removeIf(event -> {
            if (event instanceof EnrichedEvent && pipeNameToDrop.equals(((EnrichedEvent)event).getPipeName()) && regionId == ((EnrichedEvent)event).getRegionId()) {
                ((EnrichedEvent)event).clearReferenceCount(IoTDBDataRegionAsyncConnector.class.getName());
                this.retryEventQueueEventCounter.decreaseEventCount((Event)event);
                return true;
            }
            return false;
        });
    }

    public synchronized void close() {
        this.isClosed.set(true);
        this.syncConnector.close();
        if (this.tabletBatchBuilder != null) {
            this.tabletBatchBuilder.close();
        }
        if (this.hasPendingHandlers()) {
            ImmutableSet.copyOf(this.pendingHandlers.keySet()).forEach(handler -> {
                handler.clearEventsReferenceCount();
                this.eliminateHandler((PipeTransferTrackableHandler)handler);
            });
        }
        try {
            if (this.clientManager != null) {
                this.clientManager.close();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to close client manager.", (Throwable)e);
        }
        this.clearRetryEventsReferenceCount();
        super.close();
    }

    public synchronized void clearRetryEventsReferenceCount() {
        while (!this.retryEventQueue.isEmpty()) {
            Event event = (Event)this.retryEventQueue.poll();
            this.retryEventQueueEventCounter.decreaseEventCount(event);
            if (!(event instanceof EnrichedEvent)) continue;
            ((EnrichedEvent)event).clearReferenceCount(IoTDBDataRegionAsyncConnector.class.getName());
        }
    }

    public int getRetryEventQueueSize() {
        return this.retryEventQueue.size();
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    public void trackHandler(PipeTransferTrackableHandler handler) {
        this.pendingHandlers.put(handler, handler);
    }

    public void eliminateHandler(PipeTransferTrackableHandler handler) {
        handler.close();
        this.pendingHandlers.remove(handler);
    }

    public boolean hasPendingHandlers() {
        return !this.pendingHandlers.isEmpty();
    }
}

