/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ClientManagerMetrics;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.client.property.ClientPoolProperty;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.config.RatisConfig;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.consensus.exception.ConsensusGroupAlreadyExistException;
import org.apache.iotdb.consensus.exception.ConsensusGroupNotExistException;
import org.apache.iotdb.consensus.exception.PeerAlreadyInConsensusGroupException;
import org.apache.iotdb.consensus.exception.PeerNotInConsensusGroupException;
import org.apache.iotdb.consensus.exception.RatisReadUnavailableException;
import org.apache.iotdb.consensus.exception.RatisRequestFailedException;
import org.apache.iotdb.consensus.ratis.ApplicationStateMachineProxy;
import org.apache.iotdb.consensus.ratis.DiskGuardian;
import org.apache.iotdb.consensus.ratis.RatisClient;
import org.apache.iotdb.consensus.ratis.RequestMessage;
import org.apache.iotdb.consensus.ratis.ResponseMessage;
import org.apache.iotdb.consensus.ratis.metrics.RatisMetricSet;
import org.apache.iotdb.consensus.ratis.metrics.RatisMetricsManager;
import org.apache.iotdb.consensus.ratis.utils.Retriable;
import org.apache.iotdb.consensus.ratis.utils.RetryPolicy;
import org.apache.iotdb.consensus.ratis.utils.Utils;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcFactory;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SnapshotManagementRequest;
import org.apache.ratis.protocol.exceptions.AlreadyExistsException;
import org.apache.ratis.protocol.exceptions.GroupMismatchException;
import org.apache.ratis.protocol.exceptions.LeaderNotReadyException;
import org.apache.ratis.protocol.exceptions.LeaderSteppingDownException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.protocol.exceptions.ReadException;
import org.apache.ratis.protocol.exceptions.ReadIndexException;
import org.apache.ratis.protocol.exceptions.ResourceUnavailableException;
import org.apache.ratis.protocol.exceptions.ServerNotReadyException;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.server.DivisionInfo;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.thirdparty.io.grpc.StatusRuntimeException;
import org.apache.ratis.util.MemoizedCheckedSupplier;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RatisConsensus
implements IConsensus {
    private static final Logger logger = LoggerFactory.getLogger(RatisConsensus.class);
    private final RaftPeer myself;
    private final File storageDir;
    private final MemoizedCheckedSupplier<RaftServer, IOException> server;
    private final RaftProperties properties = new RaftProperties();
    private final RaftClientRpc clientRpc;
    private final IClientManager<RaftGroup, RatisClient> clientManager;
    private final IClientManager<RaftGroup, RatisClient> reconfigurationClientManager;
    private final DiskGuardian diskGuardian;
    private final Map<RaftGroupId, RaftGroup> lastSeen = new ConcurrentHashMap<RaftGroupId, RaftGroup>();
    private final ClientId localFakeId = ClientId.randomId();
    private final AtomicLong localFakeCallId = new AtomicLong(0L);
    private static final int DEFAULT_PRIORITY = 0;
    private static final int DEFAULT_WAIT_LEADER_READY_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(20L);
    private final RatisConfig config;
    private final RatisConfig.Read.Option readOption;
    private final RetryPolicy<RaftClientReply> readRetryPolicy;
    private final RetryPolicy<RaftClientReply> writeRetryPolicy;
    private final RatisMetricSet ratisMetricSet;
    private final TConsensusGroupType consensusGroupType;
    private Map<ConsensusGroupId, List<Peer>> correctPeerListBeforeStart = null;
    private final ConcurrentHashMap<ConsensusGroupId, AtomicBoolean> canServeStaleRead;

    public RatisConsensus(ConsensusConfig config, IStateMachine.Registry registry) {
        this.myself = Utils.fromNodeInfoAndPriorityToRaftPeer(config.getThisNodeId(), config.getThisNodeEndPoint(), 0);
        this.storageDir = new File(config.getStorageDir());
        RaftServerConfigKeys.setStorageDir((RaftProperties)this.properties, Collections.singletonList(this.storageDir));
        GrpcConfigKeys.Server.setPort((RaftProperties)this.properties, (int)config.getThisNodeEndPoint().getPort());
        Utils.initRatisConfig(this.properties, config.getRatisConfig());
        this.config = config.getRatisConfig();
        this.readOption = this.config.getRead().getReadOption();
        this.canServeStaleRead = this.readOption == RatisConfig.Read.Option.DEFAULT ? new ConcurrentHashMap() : null;
        this.consensusGroupType = config.getConsensusGroupType();
        this.ratisMetricSet = new RatisMetricSet();
        this.readRetryPolicy = RetryPolicy.newBuilder().setRetryHandler(c -> !c.isSuccess() && (c.getException() instanceof ReadIndexException || c.getException() instanceof ReadException || c.getException() instanceof NotLeaderException)).setMaxAttempts(this.config.getImpl().getRetryTimesMax()).setWaitTime(TimeDuration.valueOf((long)this.config.getImpl().getRetryWaitMillis(), (TimeUnit)TimeUnit.MILLISECONDS)).setMaxWaitTime(TimeDuration.valueOf((long)this.config.getImpl().getRetryMaxWaitMillis(), (TimeUnit)TimeUnit.MILLISECONDS)).setExponentialBackoff(true).build();
        this.writeRetryPolicy = RetryPolicy.newBuilder().setRetryHandler(reply -> !reply.isSuccess() && (reply.getException() instanceof ResourceUnavailableException || reply.getException() instanceof LeaderNotReadyException || reply.getException() instanceof LeaderSteppingDownException || reply.getException() instanceof StateMachineException)).setMaxAttempts(this.config.getImpl().getRetryTimesMax()).setWaitTime(TimeDuration.valueOf((long)this.config.getImpl().getRetryWaitMillis(), (TimeUnit)TimeUnit.MILLISECONDS)).setMaxWaitTime(TimeDuration.valueOf((long)this.config.getImpl().getRetryMaxWaitMillis(), (TimeUnit)TimeUnit.MILLISECONDS)).setExponentialBackoff(true).build();
        this.diskGuardian = new DiskGuardian(() -> this, this.config);
        this.clientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new RatisClientPoolFactory(false));
        this.reconfigurationClientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new RatisClientPoolFactory(true));
        this.clientRpc = new GrpcFactory(new Parameters()).newRaftClientRpc(ClientId.randomId(), this.properties);
        this.server = MemoizedCheckedSupplier.valueOf(() -> RaftServer.newBuilder().setServerId(this.myself.getId()).setProperties(this.properties).setOption(RaftStorage.StartupOption.RECOVER).setStateMachineRegistry(raftGroupId -> new ApplicationStateMachineProxy((IStateMachine)registry.apply(Utils.fromRaftGroupIdToConsensusGroupId(raftGroupId)), (RaftGroupId)raftGroupId, this::onLeaderChanged)).build());
    }

    @Override
    public synchronized void start() throws IOException {
        MetricService.getInstance().addMetricSet((IMetricSet)this.ratisMetricSet);
        ((RaftServer)this.server.get()).start();
        this.registerAndStartDiskGuardian();
        if (this.correctPeerListBeforeStart != null) {
            BiConsumer<ConsensusGroupId, List> resetPeerListWithoutThrow = (consensusGroupId, peers) -> {
                try {
                    this.resetPeerList((ConsensusGroupId)consensusGroupId, (List<Peer>)peers);
                }
                catch (ConsensusGroupNotExistException consensusGroupNotExistException) {
                }
                catch (Exception e) {
                    logger.warn("Failed to reset peer list while start", (Throwable)e);
                }
            };
            this.correctPeerListBeforeStart.forEach(resetPeerListWithoutThrow);
            this.getAllConsensusGroupIds().stream().filter(consensusGroupId -> !this.correctPeerListBeforeStart.containsKey(consensusGroupId)).forEach(consensusGroupId -> resetPeerListWithoutThrow.accept((ConsensusGroupId)consensusGroupId, Collections.emptyList()));
        }
    }

    @Override
    public synchronized void stop() throws IOException {
        try {
            this.diskGuardian.stop();
        }
        catch (InterruptedException e) {
            logger.warn("{}: interrupted when shutting down add Executor with exception {}", (Object)this, (Object)e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.clientManager.close();
            this.reconfigurationClientManager.close();
            ((RaftServer)this.server.get()).close();
            MetricService.getInstance().removeMetricSet((IMetricSet)this.ratisMetricSet);
        }
    }

    private RaftClientReply writeWithRetry(CheckedSupplier<RaftClientReply, IOException> caller, RaftGroupId groupId) throws IOException {
        RaftClientReply reply = null;
        try {
            reply = Retriable.attempt(caller, this.writeRetryPolicy, () -> caller, logger);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.debug("{}: interrupted when retrying for write request {}", (Object)this, caller);
        }
        if (reply == null) {
            return RaftClientReply.newBuilder().setClientId(ClientId.emptyClientId()).setServerId(((RaftServer)this.server.get()).getId()).setGroupId(groupId).setSuccess(false).setException(new RaftException("null reply received in writeWithRetry for request " + caller)).build();
        }
        return reply;
    }

    private RaftClientReply writeLocallyWithRetry(RaftClientRequest request, RaftGroupId groupId) throws IOException {
        return this.writeWithRetry((CheckedSupplier<RaftClientReply, IOException>)((CheckedSupplier)() -> ((RaftServer)this.server.get()).submitClientRequest(request)), groupId);
    }

    private RaftClientReply writeRemotelyWithRetry(RatisClient client, Message message, RaftGroupId groupId) throws IOException {
        return this.writeWithRetry((CheckedSupplier<RaftClientReply, IOException>)((CheckedSupplier)() -> client.getRaftClient().io().send(message)), groupId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TSStatus write(ConsensusGroupId groupId, IConsensusRequest request) throws ConsensusException {
        TSStatus writeResult;
        RaftClientRequest clientRequest;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup raftGroup = this.getGroupInfo(raftGroupId);
        if (raftGroup == null) throw new ConsensusGroupNotExistException(groupId);
        if (!raftGroup.getPeers().contains(this.myself)) {
            throw new ConsensusGroupNotExistException(groupId);
        }
        if (this.isLeader(groupId) && Utils.rejectWrite(this.consensusGroupType)) {
            try {
                this.forceStepDownLeader(raftGroup);
                return StatusUtils.getStatus((TSStatusCode)TSStatusCode.SYSTEM_READ_ONLY);
            }
            catch (Exception e) {
                logger.warn("leader {} read only, force step down failed due to, ", (Object)this.myself, (Object)e);
            }
            return StatusUtils.getStatus((TSStatusCode)TSStatusCode.SYSTEM_READ_ONLY);
        }
        RequestMessage message = new RequestMessage(request);
        try {
            clientRequest = this.buildRawRequest(raftGroupId, message, RaftClientRequest.writeRequestType());
        }
        catch (IOException e) {
            throw new RatisRequestFailedException(e);
        }
        RaftPeer suggestedLeader = null;
        if ((this.isLeader(groupId) || raftGroup.getPeers().size() == 1) && this.waitUntilLeaderReady(raftGroupId)) {
            try (RatisMetricsManager.TimeReporter ignored = RatisMetricsManager.getInstance().startWriteLocallyTimer(this.consensusGroupType);){
                RaftClientReply localServerReply222 = this.writeLocallyWithRetry(clientRequest, raftGroupId);
                if (localServerReply222.isSuccess()) {
                    ResponseMessage responseMessage = (ResponseMessage)localServerReply222.getMessage();
                    TSStatus tSStatus = (TSStatus)responseMessage.getContentHolder();
                    return tSStatus;
                }
                NotLeaderException ex = localServerReply222.getNotLeaderException();
                if (ex != null) {
                    suggestedLeader = ex.getSuggestedLeader();
                }
            }
            catch (GroupMismatchException e) {
                throw new ConsensusGroupNotExistException(groupId);
            }
            catch (Exception e) {
                throw new RatisRequestFailedException(e);
            }
        }
        try (RatisMetricsManager.TimeReporter ignored = RatisMetricsManager.getInstance().startWriteRemotelyTimer(this.consensusGroupType);
             RatisClient client = this.getRaftClient(raftGroup);){
            RaftClientReply reply = this.writeRemotelyWithRetry(client, message, raftGroupId);
            if (!reply.isSuccess()) {
                throw new RatisRequestFailedException((Exception)reply.getException());
            }
            writeResult = Utils.deserializeFrom(reply.getMessage().getContent().asReadOnlyByteBuffer());
        }
        catch (GroupMismatchException e) {
            throw new ConsensusGroupNotExistException(groupId);
        }
        catch (Exception e) {
            throw new RatisRequestFailedException(e);
        }
        if (suggestedLeader == null) return writeResult;
        TEndPoint leaderEndPoint = Utils.fromRaftPeerAddressToTEndPoint(suggestedLeader.getAddress());
        writeResult.setRedirectNode(new TEndPoint(leaderEndPoint.getIp(), leaderEndPoint.getPort()));
        return writeResult;
    }

    @Override
    public DataSet read(ConsensusGroupId groupId, IConsensusRequest request) throws ConsensusException {
        RaftClientReply reply;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup group = this.getGroupInfo(raftGroupId);
        if (group == null || !group.getPeers().contains(this.myself)) {
            throw new ConsensusGroupNotExistException(groupId);
        }
        boolean isLinearizableRead = this.readOption == RatisConfig.Read.Option.LINEARIZABLE || !this.canServeStaleRead.computeIfAbsent(groupId, id -> new AtomicBoolean(false)).get();
        try {
            reply = this.doRead(raftGroupId, request, isLinearizableRead);
            if (this.canServeStaleRead != null && isLinearizableRead) {
                this.canServeStaleRead.get(groupId).set(true);
            }
        }
        catch (NotLeaderException | ReadException | ReadIndexException e) {
            if (isLinearizableRead) {
                throw new RatisReadUnavailableException(e);
            }
            throw new RatisRequestFailedException((Exception)e);
        }
        catch (GroupMismatchException e) {
            throw new ConsensusGroupNotExistException(groupId);
        }
        catch (IllegalStateException e) {
            if (e.getMessage() != null && e.getMessage().contains("ServerNotReadyException")) {
                ServerNotReadyException serverNotReadyException = new ServerNotReadyException(e.getMessage());
                throw new RatisReadUnavailableException((Throwable)serverNotReadyException);
            }
            throw new RatisRequestFailedException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RatisReadUnavailableException((Throwable)e);
        }
        catch (Exception e) {
            throw new RatisRequestFailedException(e);
        }
        Message ret = reply.getMessage();
        ResponseMessage readResponseMessage = (ResponseMessage)ret;
        return (DataSet)readResponseMessage.getContentHolder();
    }

    private RaftClientReply doRead(RaftGroupId gid, IConsensusRequest readRequest, boolean linearizable) throws Exception {
        RaftClientReply reply;
        RaftClientRequest.Type readType = linearizable ? RaftClientRequest.readRequestType() : RaftClientRequest.staleReadRequestType((long)-1L);
        RequestMessage requestMessage = new RequestMessage(readRequest);
        RaftClientRequest request = this.buildRawRequest(gid, requestMessage, readType);
        try (RatisMetricsManager.TimeReporter ignored = RatisMetricsManager.getInstance().startReadTimer(this.consensusGroupType);){
            reply = Retriable.attempt(() -> {
                try {
                    return ((RaftServer)this.server.get()).submitClientRequest(request);
                }
                catch (IOException ioe) {
                    if (ioe.getCause() instanceof StatusRuntimeException) {
                        return RaftClientReply.newBuilder().setClientId(this.localFakeId).setServerId(((RaftServer)this.server.get()).getId()).setGroupId(request.getRaftGroupId()).setException((RaftException)new ReadIndexException("internal GRPC connection error:", ioe.getCause())).setSuccess(false).build();
                    }
                    throw ioe;
                }
            }, this.readRetryPolicy, () -> readRequest, logger);
        }
        if (!reply.isSuccess()) {
            throw reply.getException();
        }
        return reply;
    }

    @Override
    public void createLocalPeer(ConsensusGroupId groupId, List<Peer> peers) throws ConsensusException {
        RaftGroup group = this.buildRaftGroup(groupId, peers);
        try {
            RaftClientReply reply = ((RaftServer)this.server.get()).groupManagement(GroupManagementRequest.newAdd((ClientId)this.localFakeId, (RaftPeerId)this.myself.getId(), (long)this.localFakeCallId.incrementAndGet(), (RaftGroup)group, (boolean)true));
            if (!reply.isSuccess()) {
                throw new RatisRequestFailedException((Exception)reply.getException());
            }
        }
        catch (AlreadyExistsException e) {
            throw new ConsensusGroupAlreadyExistException(groupId);
        }
        catch (Exception e) {
            throw new RatisRequestFailedException(e);
        }
    }

    @Override
    public void deleteLocalPeer(ConsensusGroupId groupId) throws ConsensusException {
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        try {
            RaftClientReply reply = ((RaftServer)this.server.get()).groupManagement(GroupManagementRequest.newRemove((ClientId)this.localFakeId, (RaftPeerId)this.myself.getId(), (long)this.localFakeCallId.incrementAndGet(), (RaftGroupId)raftGroupId, (boolean)true, (boolean)false));
            if (!reply.isSuccess()) {
                throw new RatisRequestFailedException((Exception)reply.getException());
            }
        }
        catch (GroupMismatchException e) {
            throw new ConsensusGroupNotExistException(groupId);
        }
        catch (IOException e) {
            throw new RatisRequestFailedException(e);
        }
    }

    @Override
    public void addRemotePeer(ConsensusGroupId groupId, Peer peer) throws ConsensusException {
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup group = this.getGroupInfo(raftGroupId);
        if (group == null || !group.getPeers().contains(this.myself)) {
            throw new ConsensusGroupNotExistException(groupId);
        }
        RaftPeer peerToAdd = Utils.fromPeerAndPriorityToRaftPeer(peer, 0);
        if (group.getPeers().stream().anyMatch(p -> p.getId().equals((Object)peerToAdd.getId()) || p.getAddress().equals(peerToAdd.getAddress()))) {
            logger.warn("{}: try to add a peer {} with conflicting id or address in {}", new Object[]{this, peerToAdd, group.getPeers()});
            throw new PeerAlreadyInConsensusGroupException(groupId, peer);
        }
        ArrayList<RaftPeer> newConfig = new ArrayList<RaftPeer>(group.getPeers());
        newConfig.add(peerToAdd);
        this.sendReconfiguration(RaftGroup.valueOf((RaftGroupId)raftGroupId, newConfig));
    }

    @Override
    public void removeRemotePeer(ConsensusGroupId groupId, Peer peer) throws ConsensusException {
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup group = this.getGroupInfo(raftGroupId);
        RaftPeer peerToRemove = Utils.fromPeerAndPriorityToRaftPeer(peer, 0);
        if (group == null || !group.getPeers().contains(this.myself)) {
            throw new ConsensusGroupNotExistException(groupId);
        }
        if (!group.getPeers().contains(peerToRemove)) {
            throw new PeerNotInConsensusGroupException(groupId, this.myself.getAddress());
        }
        List newConfig = group.getPeers().stream().filter(raftPeer -> !raftPeer.equals((Object)peerToRemove)).collect(Collectors.toList());
        this.sendReconfiguration(RaftGroup.valueOf((RaftGroupId)raftGroupId, newConfig));
    }

    @Override
    public void recordCorrectPeerListBeforeStarting(Map<ConsensusGroupId, List<Peer>> correctPeerList) {
        logger.info("Record correct peer list: {}", correctPeerList);
        this.correctPeerListBeforeStart = correctPeerList;
    }

    @Override
    public void resetPeerList(ConsensusGroupId groupId, List<Peer> correctPeers) throws ConsensusException {
        HashSet<RaftPeer> correctRaftPeerSet;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup group = this.getGroupInfo(raftGroupId);
        if (group == null) {
            throw new ConsensusGroupNotExistException(groupId);
        }
        boolean myselfInCorrectPeers = correctPeers.stream().map(peer -> Utils.fromNodeInfoAndPriorityToRaftPeer(peer.getNodeId(), peer.getEndpoint(), 0)).anyMatch(raftPeer -> this.myself.getId().equals((Object)raftPeer.getId()) && this.myself.getAddress().equals(raftPeer.getAddress()));
        if (!myselfInCorrectPeers) {
            logger.info("[RESET PEER LIST] Local peer is not in the correct peer list, delete local peer {}", (Object)groupId);
            this.deleteLocalPeer(groupId);
            return;
        }
        List<RaftPeer> newGroupPeers = Utils.fromPeersAndPriorityToRaftPeers(correctPeers, 0);
        RaftGroup newGroup = RaftGroup.valueOf((RaftGroupId)raftGroupId, newGroupPeers);
        HashSet localRaftPeerSet = new HashSet(group.getPeers());
        if (localRaftPeerSet.equals(correctRaftPeerSet = new HashSet<RaftPeer>(newGroupPeers))) {
            logger.info("[RESET PEER LIST] The current peer list is correct, nothing need to be reset: {}", localRaftPeerSet);
            return;
        }
        logger.info("[RESET PEER LIST] Peer list will be reset from {} to {}", localRaftPeerSet, correctRaftPeerSet);
        RaftClientReply reply = this.sendReconfiguration(newGroup);
        if (reply.isSuccess()) {
            logger.info("[RESET PEER LIST] Peer list has been reset to {}", newGroupPeers);
        } else {
            logger.warn("[RESET PEER LIST] Peer list failed to reset to {}, reply is {}", (Object)newGroup, (Object)reply);
        }
    }

    @Override
    public void transferLeader(ConsensusGroupId groupId, Peer newLeader) throws ConsensusException {
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup raftGroup = Optional.ofNullable(this.getGroupInfo(raftGroupId)).orElseThrow(() -> new ConsensusGroupNotExistException(groupId));
        RaftPeer newRaftLeader = Utils.fromPeerAndPriorityToRaftPeer(newLeader, 0);
        try {
            RaftClientReply reply = this.transferLeader(raftGroup, newRaftLeader);
            if (!reply.isSuccess()) {
                throw new RatisRequestFailedException((Exception)reply.getException());
            }
        }
        catch (Exception e) {
            throw new RatisRequestFailedException(e);
        }
    }

    private void forceStepDownLeader(RaftGroup group) throws Exception {
        this.transferLeader(group, null);
    }

    private RaftClientReply transferLeader(RaftGroup group, RaftPeer newLeader) throws Exception {
        try (RatisClient client = this.getRaftClient(group);){
            RaftClientReply raftClientReply = client.getRaftClient().admin().transferLeadership(newLeader != null ? newLeader.getId() : null, 10000L);
            return raftClientReply;
        }
    }

    @Override
    public boolean isLeader(ConsensusGroupId groupId) {
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        try {
            return ((RaftServer)this.server.get()).getDivision(raftGroupId).getInfo().isLeader();
        }
        catch (IOException exception) {
            logger.info("isLeader request failed with exception: ", (Throwable)exception);
            return false;
        }
    }

    @Override
    public boolean isLeaderReady(ConsensusGroupId groupId) {
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        try {
            return ((RaftServer)this.server.get()).getDivision(raftGroupId).getInfo().isLeaderReady();
        }
        catch (IOException exception) {
            logger.info("isLeaderReady request failed with exception: ", (Throwable)exception);
            return false;
        }
    }

    @Override
    public long getLogicalClock(ConsensusGroupId groupId) {
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        try {
            return ((RaftServer)this.server.get()).getDivision(raftGroupId).getInfo().getCurrentTerm();
        }
        catch (IOException exception) {
            logger.info("getLogicalClock request failed with exception: ", (Throwable)exception);
            return 0L;
        }
    }

    private boolean waitUntilLeaderReady(RaftGroupId groupId) {
        DivisionInfo divisionInfo;
        try {
            divisionInfo = ((RaftServer)this.server.get()).getDivision(groupId).getInfo();
        }
        catch (IOException e) {
            logger.info("isLeaderReady checking failed with exception: ", (Throwable)e);
            return false;
        }
        long startTime = System.currentTimeMillis();
        BooleanSupplier noRetryAtAnyOfFollowingCondition = () -> Utils.anyOf(() -> this.getGroupInfo(groupId).getPeers().size() > 1 && !divisionInfo.isLeader(), () -> divisionInfo.isLeader() && divisionInfo.isLeaderReady(), () -> System.currentTimeMillis() - startTime >= (long)DEFAULT_WAIT_LEADER_READY_TIMEOUT);
        try {
            Retriable.attemptUntilTrue(noRetryAtAnyOfFollowingCondition, TimeDuration.valueOf((long)10L, (TimeUnit)TimeUnit.MILLISECONDS), "waitLeaderReady", logger);
            if (divisionInfo.isLeader() && !divisionInfo.isLeaderReady()) {
                logger.warn("{}: leader is still not ready after {}ms", (Object)groupId, (Object)DEFAULT_WAIT_LEADER_READY_TIMEOUT);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Unexpected interruption when waitUntilLeaderReady", (Throwable)e);
            return false;
        }
        return divisionInfo.isLeader();
    }

    @Override
    public Peer getLeader(ConsensusGroupId groupId) {
        RaftPeerId leaderId;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        try {
            leaderId = ((RaftServer)this.server.get()).getDivision(raftGroupId).getInfo().getLeaderId();
        }
        catch (IOException e) {
            logger.warn("fetch division info for group " + groupId + " failed due to: ", (Throwable)e);
            return null;
        }
        if (leaderId == null) {
            return null;
        }
        int nodeId = Utils.fromRaftPeerIdToNodeId(leaderId);
        return new Peer(groupId, nodeId, null);
    }

    @Override
    public int getReplicationNum(ConsensusGroupId groupId) {
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        try {
            return ((RaftServer)this.server.get()).getDivision(raftGroupId).getGroup().getPeers().size();
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public List<ConsensusGroupId> getAllConsensusGroupIds() {
        ArrayList<ConsensusGroupId> ids = new ArrayList<ConsensusGroupId>();
        try {
            ((RaftServer)this.server.get()).getGroupIds().forEach(groupId -> ids.add(Utils.fromRaftGroupIdToConsensusGroupId(groupId)));
            return ids;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public String getRegionDirFromConsensusGroupId(ConsensusGroupId consensusGroupId) {
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(consensusGroupId);
        return this.storageDir + File.separator + raftGroupId.getUuid().toString();
    }

    @Override
    public void reloadConsensusConfig(ConsensusConfig consensusConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerSnapshot(ConsensusGroupId groupId, boolean force) throws ConsensusException {
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup groupInfo = this.getGroupInfo(raftGroupId);
        if (groupInfo == null || !groupInfo.getPeers().contains(this.myself)) {
            throw new ConsensusGroupNotExistException(groupId);
        }
        SnapshotManagementRequest request = SnapshotManagementRequest.newCreate((ClientId)this.localFakeId, (RaftPeerId)this.myself.getId(), (RaftGroupId)raftGroupId, (long)this.localFakeCallId.incrementAndGet(), (long)300000L, (long)(force ? 1L : 0L));
        RaftGroupId raftGroupId2 = raftGroupId;
        synchronized (raftGroupId2) {
            try {
                RaftClientReply reply = ((RaftServer)this.server.get()).snapshotManagement(request);
                if (!reply.isSuccess()) {
                    throw new RatisRequestFailedException((Exception)reply.getException());
                }
                logger.info("{} group {}: successfully taken snapshot at index {} with force = {}", new Object[]{this, raftGroupId, reply.getLogIndex(), force});
            }
            catch (IOException ioException) {
                throw new RatisRequestFailedException(ioException);
            }
        }
    }

    private void registerAndStartDiskGuardian() {
        RatisConfig.Impl implConfig = this.config.getImpl();
        this.diskGuardian.registerChecker(summary -> summary.getTotalSize() > implConfig.getRaftLogSizeMaxThreshold(), TimeDuration.valueOf((long)implConfig.getCheckAndTakeSnapshotInterval(), (TimeUnit)TimeUnit.SECONDS));
        long forceSnapshotInterval = implConfig.getForceSnapshotInterval();
        if (forceSnapshotInterval > 0L) {
            this.diskGuardian.registerChecker(summary -> true, TimeDuration.valueOf((long)forceSnapshotInterval, (TimeUnit)TimeUnit.SECONDS));
        }
        this.diskGuardian.start();
    }

    private RaftClientRequest buildRawRequest(RaftGroupId groupId, Message message, RaftClientRequest.Type type) throws IOException {
        return RaftClientRequest.newBuilder().setServerId(((RaftServer)this.server.get()).getId()).setClientId(this.localFakeId).setCallId(this.localFakeCallId.incrementAndGet()).setGroupId(groupId).setType(type).setMessage(message).build();
    }

    private RaftGroup getGroupInfo(RaftGroupId raftGroupId) {
        RaftGroup raftGroup = null;
        try {
            raftGroup = ((RaftServer)this.server.get()).getDivision(raftGroupId).getGroup();
            RaftGroup lastSeenGroup = this.lastSeen.getOrDefault(raftGroupId, null);
            if (lastSeenGroup != null && !lastSeenGroup.equals((Object)raftGroup)) {
                this.clientManager.clear((Object)lastSeenGroup);
                this.reconfigurationClientManager.clear((Object)lastSeenGroup);
                this.lastSeen.put(raftGroupId, raftGroup);
            }
        }
        catch (IOException e) {
            logger.debug("get group {} failed ", (Object)raftGroupId, (Object)e);
        }
        return raftGroup;
    }

    private RaftGroup buildRaftGroup(ConsensusGroupId groupId, List<Peer> peers) {
        return RaftGroup.valueOf((RaftGroupId)Utils.fromConsensusGroupIdToRaftGroupId(groupId), Utils.fromPeersAndPriorityToRaftPeers(peers, 0));
    }

    private RatisClient getRaftClient(RaftGroup group) throws ClientManagerException {
        try {
            return (RatisClient)this.clientManager.borrowClient((Object)group);
        }
        catch (ClientManagerException e) {
            logger.error("Borrow client from pool for group {} failed.", (Object)group, (Object)e);
            throw e;
        }
    }

    private RatisClient getConfigurationRaftClient(RaftGroup group) throws ClientManagerException {
        try {
            return (RatisClient)this.reconfigurationClientManager.borrowClient((Object)group);
        }
        catch (ClientManagerException e) {
            logger.error("Borrow client from pool for group {} failed.", (Object)group, (Object)e);
            throw e;
        }
    }

    private RaftClientReply sendReconfiguration(RaftGroup newGroupConf) throws RatisRequestFailedException {
        RaftClientReply reply;
        try (RatisClient client = this.getConfigurationRaftClient(newGroupConf);){
            reply = client.getRaftClient().admin().setConfiguration(new ArrayList(newGroupConf.getPeers()));
            if (!reply.isSuccess()) {
                throw new RatisRequestFailedException((Exception)reply.getException());
            }
        }
        catch (Exception e) {
            throw new RatisRequestFailedException(e);
        }
        return reply;
    }

    private void onLeaderChanged(RaftGroupMemberId groupMemberId, RaftPeerId leaderId) {
        Optional.ofNullable(this.canServeStaleRead).ifPresent(m -> {
            ConsensusGroupId gid = Utils.fromRaftGroupIdToConsensusGroupId(groupMemberId.getGroupId());
            this.canServeStaleRead.computeIfAbsent(gid, id -> new AtomicBoolean()).set(false);
        });
    }

    public RaftServer getServer() throws IOException {
        return (RaftServer)this.server.get();
    }

    @TestOnly
    public void allowStaleRead(ConsensusGroupId consensusGroupId) {
        this.canServeStaleRead.computeIfAbsent(consensusGroupId, id -> new AtomicBoolean(false)).set(true);
    }

    private class RatisClientPoolFactory
    implements IClientPoolFactory<RaftGroup, RatisClient> {
        private final boolean isReconfiguration;

        RatisClientPoolFactory(boolean isReconfiguration) {
            this.isReconfiguration = isReconfiguration;
        }

        public GenericKeyedObjectPool<RaftGroup, RatisClient> createClientPool(ClientManager<RaftGroup, RatisClient> manager) {
            GenericKeyedObjectPool clientPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)(this.isReconfiguration ? new RatisClient.EndlessRetryFactory(manager, RatisConsensus.this.properties, RatisConsensus.this.clientRpc, RatisConsensus.this.config.getClient()) : new RatisClient.Factory(manager, RatisConsensus.this.properties, RatisConsensus.this.clientRpc, RatisConsensus.this.config.getClient())), new ClientPoolProperty.Builder().setMaxClientNumForEachNode(RatisConsensus.this.config.getClient().getMaxClientNumForEachNode()).build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }
}

