/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.ModifiedStatus;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader.PageLoader;
import org.apache.tsfile.compress.IUnCompressor;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.IDecryptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.write.PageException;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.EncryptionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.reader.chunk.ChunkReader;
import org.apache.tsfile.write.chunk.AlignedChunkWriterImpl;

public class InstantPageLoader
extends PageLoader {
    private ByteBuffer pageData;
    private EncryptParameter encryptParam;

    public InstantPageLoader() {
    }

    public InstantPageLoader(String file, PageHeader pageHeader, ByteBuffer pageData, CompressionType compressionType, TSDataType dataType, TSEncoding encoding, ChunkMetadata chunkMetadata, ModifiedStatus modifiedStatus, EncryptParameter encryptParam) {
        super(file, pageHeader, compressionType, dataType, encoding, chunkMetadata, modifiedStatus);
        this.pageData = pageData;
        this.encryptParam = encryptParam;
    }

    @Override
    public ByteBuffer getCompressedData() {
        return this.pageData;
    }

    @Override
    public ByteBuffer getUnCompressedData() throws IOException {
        IUnCompressor unCompressor = IUnCompressor.getUnCompressor((CompressionType)this.compressionType);
        IDecryptor decryptor = IDecryptor.getDecryptor((EncryptParameter)this.encryptParam);
        if (decryptor == null || decryptor.getEncryptionType() == EncryptionType.UNENCRYPTED) {
            return ChunkReader.uncompressPageData((PageHeader)this.pageHeader, (IUnCompressor)unCompressor, (ByteBuffer)this.pageData);
        }
        return ChunkReader.decryptAndUncompressPageData((PageHeader)this.pageHeader, (IUnCompressor)unCompressor, (ByteBuffer)this.pageData, (IDecryptor)decryptor);
    }

    @Override
    public void flushToTimeChunkWriter(AlignedChunkWriterImpl alignedChunkWriter) throws PageException {
        alignedChunkWriter.writePageHeaderAndDataIntoTimeBuff(this.pageData, this.pageHeader);
        this.clear();
    }

    @Override
    public void flushToValueChunkWriter(AlignedChunkWriterImpl alignedChunkWriter, int valueColumnIndex) throws IOException, PageException {
        if (this.isEmpty()) {
            alignedChunkWriter.getValueChunkWriterByIndex(valueColumnIndex).writeEmptyPageToPageBuffer();
        } else {
            alignedChunkWriter.getValueChunkWriterByIndex(valueColumnIndex).writePageHeaderAndDataIntoBuff(this.pageData, this.pageHeader);
            this.clear();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.pageHeader == null || this.pageData == null || this.pageHeader.getUncompressedSize() == 0 || this.modifiedStatus == ModifiedStatus.ALL_DELETED;
    }

    @Override
    public void clear() {
        this.deleteIntervalList = null;
        this.pageHeader = null;
        this.pageData = null;
    }
}

