/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadPointCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.RepairUnsortedFileCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileRepairStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ArrayDeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.db.storageengine.rescon.memory.TsFileResourceManager;

public class RepairUnsortedFileCompactionPerformer
extends ReadPointCompactionPerformer {
    @Override
    protected AbstractCompactionWriter getCompactionWriter(List<TsFileResource> seqFileResources, List<TsFileResource> unseqFileResources, List<TsFileResource> targetFileResources) throws IOException {
        return new RepairUnsortedFileCompactionWriter(targetFileResources.get(0));
    }

    @Override
    public void perform() throws Exception {
        TsFileResource resource;
        TsFileResource tsFileResource = resource = !this.seqFiles.isEmpty() ? (TsFileResource)this.seqFiles.get(0) : (TsFileResource)this.unseqFiles.get(0);
        if (resource.getTsFileRepairStatus() == TsFileRepairStatus.NEED_TO_REPAIR_BY_REWRITE) {
            TsFileResourceManager.getInstance().forceDegradeTsFileResource(resource);
            super.perform();
        } else {
            this.prepareTargetFile();
        }
    }

    @Override
    protected QueryDataSource initQueryDataSource() {
        return new QueryDataSource(!this.seqFiles.isEmpty() ? this.seqFiles : this.unseqFiles, Collections.emptyList());
    }

    private void prepareTargetFile() throws IOException {
        TsFileResource seqSourceFile = (TsFileResource)this.seqFiles.get(0);
        TsFileResource targetFile = (TsFileResource)this.targetFiles.get(0);
        Files.createLink(targetFile.getTsFile().toPath(), seqSourceFile.getTsFile().toPath());
        ITimeIndex timeIndex = seqSourceFile.getTimeIndex();
        if (timeIndex instanceof ArrayDeviceTimeIndex) {
            targetFile.setTimeIndex(timeIndex);
        } else {
            targetFile.setTimeIndex(CompactionUtils.buildDeviceTimeIndex(seqSourceFile));
        }
        if (seqSourceFile.anyModFileExists()) {
            Files.createLink(seqSourceFile.getCompactionModFile().getFile().toPath(), seqSourceFile.getExclusiveModFile().getFile().toPath());
        }
    }

    @Override
    public void setSourceFiles(List<TsFileResource> sourceFiles) {
        if (sourceFiles.get(0).isSeq()) {
            this.seqFiles = sourceFiles;
        } else {
            this.unseqFiles = sourceFiles;
        }
    }
}

