/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Assignments;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class AggregationTreeDeviceViewScanNode
extends AggregationTableScanNode {
    private String treeDBName;
    private Map<String, String> measurementColumnNameMap;

    public AggregationTreeDeviceViewScanNode(PlanNodeId id, QualifiedObjectName qualifiedObjectName, List<Symbol> outputSymbols, Map<Symbol, ColumnSchema> assignments, List<DeviceEntry> deviceEntries, Map<Symbol, Integer> idAndAttributeIndexMap, Ordering scanOrder, Expression timePredicate, Expression pushDownPredicate, long pushDownLimit, long pushDownOffset, boolean pushLimitToEachDevice, boolean containsNonAlignedDevice, Assignments projection, Map<Symbol, AggregationNode.Aggregation> aggregations, AggregationNode.GroupingSetDescriptor groupingSets, List<Symbol> preGroupedSymbols, AggregationNode.Step step, Optional<Symbol> groupIdSymbol, String treeDBName, Map<String, String> measurementColumnNameMap) {
        super(id, qualifiedObjectName, outputSymbols, assignments, deviceEntries, idAndAttributeIndexMap, scanOrder, timePredicate, pushDownPredicate, pushDownLimit, pushDownOffset, pushLimitToEachDevice, containsNonAlignedDevice, projection, aggregations, groupingSets, preGroupedSymbols, step, groupIdSymbol);
        this.treeDBName = treeDBName;
        this.measurementColumnNameMap = measurementColumnNameMap;
    }

    private AggregationTreeDeviceViewScanNode() {
    }

    public String getTreeDBName() {
        return this.treeDBName;
    }

    public Map<String, String> getMeasurementColumnNameMap() {
        return this.measurementColumnNameMap;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitAggregationTreeDeviceViewScan(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AggregationTreeDeviceViewScanNode that = (AggregationTreeDeviceViewScanNode)o;
        return Objects.equals(this.treeDBName, that.treeDBName) && Objects.equals(this.measurementColumnNameMap, that.measurementColumnNameMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.treeDBName, this.measurementColumnNameMap);
    }

    @Override
    public String toString() {
        return "AggregationTreeDeviceViewTableScanNode-" + this.getPlanNodeId();
    }

    @Override
    public AggregationTreeDeviceViewScanNode clone() {
        return new AggregationTreeDeviceViewScanNode(this.id, this.qualifiedObjectName, this.outputSymbols, this.assignments, this.deviceEntries, this.idAndAttributeIndexMap, this.scanOrder, this.timePredicate, this.pushDownPredicate, this.pushDownLimit, this.pushDownOffset, this.pushLimitToEachDevice, this.containsNonAlignedDevice, this.projection, this.aggregations, this.groupingSets, this.preGroupedSymbols, this.step, this.groupIdSymbol, this.treeDBName, this.measurementColumnNameMap);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.AGGREGATION_TREE_DEVICE_VIEW_SCAN_NODE.serialize(byteBuffer);
        AggregationTableScanNode.serializeMemberVariables((AggregationTableScanNode)this, byteBuffer);
        ReadWriteIOUtils.write((String)this.treeDBName, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.measurementColumnNameMap.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry<String, String> entry : this.measurementColumnNameMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((String)entry.getValue(), (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.AGGREGATION_TREE_DEVICE_VIEW_SCAN_NODE.serialize(stream);
        AggregationTableScanNode.serializeMemberVariables((AggregationTableScanNode)this, stream);
        ReadWriteIOUtils.write((String)this.treeDBName, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.measurementColumnNameMap.size(), (OutputStream)stream);
        for (Map.Entry<String, String> entry : this.measurementColumnNameMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)stream);
            ReadWriteIOUtils.write((String)entry.getValue(), (OutputStream)stream);
        }
    }

    public static AggregationTreeDeviceViewScanNode deserialize(ByteBuffer byteBuffer) {
        AggregationTreeDeviceViewScanNode node = new AggregationTreeDeviceViewScanNode();
        AggregationTableScanNode.deserializeMemberVariables(byteBuffer, node, false);
        node.treeDBName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashMap<String, String> measurementColumnNameMap = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            measurementColumnNameMap.put(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        node.measurementColumnNameMap = measurementColumnNameMap;
        node.setPlanNodeId(PlanNodeId.deserialize(byteBuffer));
        return node;
    }
}

