/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import io.airlift.units.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.tsfile.utils.Accountable;
import org.apache.tsfile.utils.RamUsageEstimator;

public class OperatorContext
implements Accountable {
    private static Duration maxRunTime = new Duration((double)IoTDBDescriptor.getInstance().getConfig().getDriverTaskExecutionTimeSliceInMs(), TimeUnit.MILLISECONDS);
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(OperatorContext.class);
    private final int operatorId;
    private final PlanNodeId planNodeId;
    private final String operatorType;
    private DriverContext driverContext;
    private long totalExecutionTimeInNanos = 0L;
    private long nextCalledCount = 0L;
    private long hasNextCalledCount = 0L;
    private Map<String, String> specifiedInfo = null;
    private long output = 0L;
    private long estimatedMemorySize;

    public OperatorContext(int operatorId, PlanNodeId planNodeId, String operatorType, DriverContext driverContext) {
        this.operatorId = operatorId;
        this.planNodeId = planNodeId;
        this.operatorType = operatorType;
        this.driverContext = driverContext;
    }

    @TestOnly
    public OperatorContext(int operatorId, PlanNodeId planNodeId, String operatorType, FragmentInstanceContext fragmentInstanceContext) {
        this.operatorId = operatorId;
        this.planNodeId = planNodeId;
        this.operatorType = operatorType;
        this.driverContext = new DriverContext(fragmentInstanceContext, 0);
    }

    public int getOperatorId() {
        return this.operatorId;
    }

    public String getOperatorType() {
        return this.operatorType;
    }

    public DriverContext getDriverContext() {
        return this.driverContext;
    }

    public void setDriverContext(DriverContext driverContext) {
        this.driverContext = driverContext;
    }

    public FragmentInstanceContext getInstanceContext() {
        return this.driverContext.getFragmentInstanceContext();
    }

    public Duration getMaxRunTime() {
        return maxRunTime;
    }

    public static void setMaxRunTime(Duration maxRunTime) {
        OperatorContext.maxRunTime = maxRunTime;
    }

    public SessionInfo getSessionInfo() {
        return this.getInstanceContext().getSessionInfo();
    }

    public PlanNodeId getPlanNodeId() {
        return this.planNodeId;
    }

    public void recordExecutionTime(long executionTimeInNanos) {
        this.totalExecutionTimeInNanos += executionTimeInNanos;
    }

    public void recordNextCalled() {
        ++this.nextCalledCount;
    }

    public void recordHasNextCalled() {
        ++this.hasNextCalledCount;
    }

    public long getTotalExecutionTimeInNanos() {
        return this.totalExecutionTimeInNanos;
    }

    public long getNextCalledCount() {
        return this.nextCalledCount;
    }

    public long getHasNextCalledCount() {
        return this.hasNextCalledCount;
    }

    public void setEstimatedMemorySize(long estimatedMemorySize) {
        this.estimatedMemorySize = estimatedMemorySize;
    }

    public long getEstimatedMemorySize() {
        return this.estimatedMemorySize;
    }

    public void addOutputRows(long outputRows) {
        this.output += outputRows;
    }

    public long getOutputRows() {
        return this.output;
    }

    public void recordSpecifiedInfo(String key, String value) {
        if (this.specifiedInfo == null) {
            this.specifiedInfo = new ConcurrentHashMap<String, String>();
        }
        this.specifiedInfo.put(key, value);
    }

    public Map<String, String> getSpecifiedInfo() {
        return this.specifiedInfo == null ? new HashMap() : this.specifiedInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorContext that = (OperatorContext)o;
        return this.operatorId == that.operatorId;
    }

    public int hashCode() {
        return Objects.hash(this.operatorId);
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + RamUsageEstimator.sizeOf((String)this.operatorType) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.planNodeId);
    }
}

