/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.realtime;

import java.util.stream.Collectors;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.ProgressReportEvent;
import org.apache.iotdb.consensus.pipe.PipeConsensus;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.pipe.consensus.ReplicateProgressDataNodeManager;
import org.apache.iotdb.db.pipe.event.common.deletion.PipeDeleteDataNodeEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.epoch.TsFileEpochManager;
import org.apache.iotdb.db.pipe.processor.pipeconsensus.PipeConsensusProcessor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.AbstractDeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.storageengine.dataregion.memtable.DeviceIDFactory;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALEntryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeRealtimeEventFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeRealtimeEventFactory.class);
    private static final TsFileEpochManager TS_FILE_EPOCH_MANAGER = new TsFileEpochManager();

    public static PipeRealtimeEvent createRealtimeEvent(String dataRegionId, Boolean isTableModel, String databaseNameFromDataRegion, TsFileResource resource, boolean isLoaded) {
        PipeTsFileInsertionEvent tsFileInsertionEvent = new PipeTsFileInsertionEvent(isTableModel, databaseNameFromDataRegion, resource, isLoaded, false);
        if (DataRegionConsensusImpl.getInstance() instanceof PipeConsensus && PipeConsensusProcessor.isShouldReplicate(tsFileInsertionEvent)) {
            tsFileInsertionEvent.setReplicateIndexForIoTV2(ReplicateProgressDataNodeManager.assignReplicateIndexForIoTV2(dataRegionId));
            LOGGER.debug("[Region{}]Set {} for event {}", new Object[]{dataRegionId, tsFileInsertionEvent.getReplicateIndexForIoTV2(), tsFileInsertionEvent});
        }
        return TS_FILE_EPOCH_MANAGER.bindPipeTsFileInsertionEvent(tsFileInsertionEvent, resource);
    }

    public static PipeRealtimeEvent createRealtimeEvent(String dataRegionId, Boolean isTableModel, String databaseNameFromDataRegion, WALEntryHandler walEntryHandler, InsertNode insertNode, TsFileResource resource) {
        PipeInsertNodeTabletInsertionEvent insertionEvent = new PipeInsertNodeTabletInsertionEvent(isTableModel, databaseNameFromDataRegion, walEntryHandler, insertNode.getTargetPath(), insertNode instanceof InsertRowsNode ? ((InsertRowsNode)insertNode).getInsertRowNodeList().stream().map(node -> DeviceIDFactory.getInstance().getDeviceID(node.getTargetPath()).getTableName()).collect(Collectors.toSet()) : null, insertNode.getProgressIndex(), insertNode.isAligned(), insertNode.isGeneratedByPipe());
        if (DataRegionConsensusImpl.getInstance() instanceof PipeConsensus && PipeConsensusProcessor.isShouldReplicate(insertionEvent)) {
            insertionEvent.setReplicateIndexForIoTV2(ReplicateProgressDataNodeManager.assignReplicateIndexForIoTV2(dataRegionId));
            LOGGER.debug("[Region{}]Set {} for event {}", new Object[]{dataRegionId, insertionEvent.getReplicateIndexForIoTV2(), insertionEvent});
        }
        return TS_FILE_EPOCH_MANAGER.bindPipeInsertNodeTabletInsertionEvent(insertionEvent, insertNode, resource);
    }

    public static PipeRealtimeEvent createRealtimeEvent(String dataRegionId, boolean shouldPrintMessage) {
        return new PipeRealtimeEvent(new PipeHeartbeatEvent(dataRegionId, shouldPrintMessage), null, null);
    }

    public static PipeRealtimeEvent createRealtimeEvent(String dataRegionId, AbstractDeleteDataNode node) {
        PipeDeleteDataNodeEvent deleteDataNodeEvent = new PipeDeleteDataNodeEvent(node, node.isGeneratedByPipe());
        if (DataRegionConsensusImpl.getInstance() instanceof PipeConsensus && PipeConsensusProcessor.isShouldReplicate(deleteDataNodeEvent)) {
            deleteDataNodeEvent.setReplicateIndexForIoTV2(ReplicateProgressDataNodeManager.assignReplicateIndexForIoTV2(dataRegionId));
            LOGGER.debug("[Region{}]Set {} for event {}", new Object[]{dataRegionId, deleteDataNodeEvent.getReplicateIndexForIoTV2(), deleteDataNodeEvent});
        }
        return new PipeRealtimeEvent(deleteDataNodeEvent, null, null);
    }

    public static PipeRealtimeEvent createRealtimeEvent(ProgressReportEvent event) {
        return new PipeRealtimeEvent((EnrichedEvent)event, null, null);
    }

    private PipeRealtimeEventFactory() {
    }
}

