/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.exception.table.ColumnNotExistsException;
import org.apache.iotdb.commons.exception.table.TableAlreadyExistsException;
import org.apache.iotdb.commons.exception.table.TableNotExistsException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.commons.schema.node.utils.IMNodeIterator;
import org.apache.iotdb.commons.schema.table.TableNodeStatus;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TimeColumnSchema;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.commons.schema.tree.ITreeNode;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.commons.utils.ThriftConfigNodeSerDeUtils;
import org.apache.iotdb.confignode.persistence.schema.ConfigMTreeStore;
import org.apache.iotdb.confignode.persistence.schema.mnode.IConfigMNode;
import org.apache.iotdb.confignode.persistence.schema.mnode.factory.ConfigMNodeFactory;
import org.apache.iotdb.confignode.persistence.schema.mnode.impl.ConfigTableNode;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.db.exception.metadata.DatabaseAlreadySetException;
import org.apache.iotdb.db.exception.metadata.DatabaseConflictException;
import org.apache.iotdb.db.exception.metadata.DatabaseNotSetException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.IMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.collector.DatabaseCollector;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.collector.MNodeAboveDBCollector;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.collector.MNodeCollector;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.counter.DatabaseCounter;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.MetaFormatUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMTree {
    private static final String TABLE_ERROR_MSG = "Failed to recover configNode, because there exists data from an older incompatible version, will shutdown soon. Please delete all data, and then restart again.";
    private final Logger logger = LoggerFactory.getLogger(ConfigMTree.class);
    private IConfigMNode root;
    private final ConfigMTreeStore store;
    private final IMNodeFactory<IConfigMNode> nodeFactory = ConfigMNodeFactory.getInstance();
    private final boolean isTableModel;

    public ConfigMTree(boolean isTableModel) throws MetadataException {
        this.store = new ConfigMTreeStore(this.nodeFactory);
        this.root = this.store.getRoot();
        this.isTableModel = isTableModel;
    }

    public void clear() {
        if (this.store != null) {
            this.store.clear();
            this.root = this.store.getRoot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStorageGroup(PartialPath path) throws MetadataException {
        int i;
        String[] nodeNames = path.getNodes();
        MetaFormatUtils.checkDatabase((String)path.getFullPath());
        if (nodeNames.length <= 1 || !nodeNames[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        IConfigMNode cur = this.root;
        for (i = 1; i < nodeNames.length - 1; ++i) {
            IConfigMNode temp = this.store.getChild(cur, nodeNames[i]);
            if (temp == null) {
                this.store.addChild(cur, nodeNames[i], (IConfigMNode)this.nodeFactory.createInternalMNode((IMNode)cur, nodeNames[i]));
            } else if (temp.isDatabase()) {
                throw new DatabaseConflictException(temp.getFullPath(), false);
            }
            cur = this.store.getChild(cur, nodeNames[i]);
        }
        ConfigMTree configMTree = this;
        synchronized (configMTree) {
            if (this.store.hasChild(cur, nodeNames[i])) {
                throw this.store.getChild(cur, nodeNames[i]).isDatabase() ? new DatabaseAlreadySetException(path.getFullPath()) : new DatabaseConflictException(path.getFullPath(), true);
            }
            IDatabaseMNode databaseMNode = this.nodeFactory.createDatabaseMNode((IMNode)cur, nodeNames[i]);
            IConfigMNode result = this.store.addChild(cur, nodeNames[i], (IConfigMNode)databaseMNode.getAsMNode());
            if (result != databaseMNode) {
                throw new DatabaseConflictException(path.getFullPath(), true);
            }
        }
    }

    public void deleteDatabase(PartialPath path) throws MetadataException {
        IDatabaseMNode<IConfigMNode> databaseMNode = this.getDatabaseNodeByDatabasePath(path);
        IConfigMNode cur = (IConfigMNode)databaseMNode.getParent();
        this.store.deleteChild(cur, databaseMNode.getName());
        while (cur.getParent() != null && cur.getChildren().isEmpty()) {
            ((IConfigMNode)cur.getParent()).deleteChild(cur.getName());
            cur = (IConfigMNode)cur.getParent();
        }
    }

    public List<PartialPath> getBelongedDatabases(PartialPath pathPattern) throws MetadataException {
        return this.collectDatabases(pathPattern, SchemaConstant.ALL_MATCH_SCOPE, false, true);
    }

    public List<PartialPath> getMatchedDatabases(PartialPath pathPattern, PathPatternTree scope, boolean isPrefixMatch) throws MetadataException {
        return this.collectDatabases(pathPattern, scope, isPrefixMatch, false);
    }

    private List<PartialPath> collectDatabases(PartialPath pathPattern, PathPatternTree scope, boolean isPrefixMatch, boolean collectInternal) throws MetadataException {
        final LinkedList<PartialPath> result = new LinkedList<PartialPath>();
        try (DatabaseCollector<List<PartialPath>, IConfigMNode> collector = new DatabaseCollector<List<PartialPath>, IConfigMNode>(this.root, pathPattern, (IMTreeStore)this.store, isPrefixMatch, scope){

            protected void collectDatabase(IDatabaseMNode<IConfigMNode> node) {
                result.add(node.getPartialPath());
            }
        };){
            collector.setCollectInternal(collectInternal);
            collector.traverse();
        }
        return result;
    }

    public List<PartialPath> getAllDatabasePaths(Boolean isTableModel) {
        ArrayList<PartialPath> res = new ArrayList<PartialPath>();
        ArrayDeque<IConfigMNode> nodeStack = new ArrayDeque<IConfigMNode>();
        nodeStack.add(this.root);
        while (!nodeStack.isEmpty()) {
            IConfigMNode current = (IConfigMNode)nodeStack.pop();
            if (current.isDatabase()) {
                if (Boolean.TRUE.equals(isTableModel) && !current.getDatabaseSchema().isIsTableModel() || Boolean.FALSE.equals(isTableModel) && current.getDatabaseSchema().isIsTableModel()) continue;
                res.add(current.getPartialPath());
                continue;
            }
            nodeStack.addAll(current.getChildren().values());
        }
        return res;
    }

    public int getDatabaseNum(PartialPath pathPattern, PathPatternTree scope, boolean isPrefixMatch) throws MetadataException {
        try (DatabaseCounter counter = new DatabaseCounter((IMNode)this.root, pathPattern, (IMTreeStore)this.store, isPrefixMatch, scope);){
            int n = (int)counter.count();
            return n;
        }
    }

    public IDatabaseMNode<IConfigMNode> getDatabaseNodeByDatabasePath(PartialPath databasePath) throws MetadataException {
        String[] nodes = databasePath.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(databasePath.getFullPath());
        }
        IConfigMNode cur = this.root;
        for (int i = 1; i < nodes.length - 1; ++i) {
            if ((cur = (IConfigMNode)cur.getChild(nodes[i])) == null) {
                throw new DatabaseNotSetException(databasePath.getFullPath());
            }
            if (!cur.isDatabase()) continue;
            throw new DatabaseConflictException(cur.getFullPath(), false);
        }
        if ((cur = (IConfigMNode)cur.getChild(nodes[nodes.length - 1])) == null) {
            throw new DatabaseNotSetException(databasePath.getFullPath());
        }
        if (cur.isDatabase()) {
            return cur.getAsDatabaseMNode();
        }
        throw new DatabaseConflictException(databasePath.getFullPath(), true);
    }

    public IDatabaseMNode<IConfigMNode> getDatabaseNodeByPath(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        IConfigMNode cur = this.root;
        for (int i = 1; i < nodes.length && (cur = (IConfigMNode)cur.getChild(nodes[i])) != null; ++i) {
            if (!cur.isDatabase()) continue;
            return cur.getAsDatabaseMNode();
        }
        throw new DatabaseNotSetException(path.getFullPath());
    }

    public boolean isDatabaseAlreadySet(PartialPath path) {
        String[] nodeNames = path.getNodes();
        IConfigMNode cur = this.root;
        if (!nodeNames[0].equals(this.root.getName())) {
            return false;
        }
        for (int i = 1; i < nodeNames.length; ++i) {
            if (!this.store.hasChild(cur, nodeNames[i])) {
                return false;
            }
            if (!(cur = this.store.getChild(cur, nodeNames[i])).isDatabase()) continue;
            return true;
        }
        return true;
    }

    public void checkDatabaseAlreadySet(PartialPath path) throws DatabaseAlreadySetException, DatabaseConflictException {
        String[] nodeNames = path.getNodes();
        IConfigMNode cur = this.root;
        if (!nodeNames[0].equals(this.root.getName())) {
            return;
        }
        for (int i = 1; i < nodeNames.length; ++i) {
            if (!this.store.hasChild(cur, nodeNames[i])) {
                return;
            }
            if (!(cur = this.store.getChild(cur, nodeNames[i])).isDatabase()) continue;
            throw new DatabaseAlreadySetException(cur.getFullPath());
        }
        throw new DatabaseConflictException(path.getFullPath(), true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IConfigMNode getNodeWithAutoCreate(PartialPath path) throws DatabaseNotSetException {
        String[] nodeNames = path.getNodes();
        IConfigMNode cur = this.root;
        boolean hasStorageGroup = false;
        for (int i = 1; i < nodeNames.length; ++i) {
            IConfigMNode child = this.store.getChild(cur, nodeNames[i]);
            if (child == null) {
                if (!hasStorageGroup) throw new DatabaseNotSetException(path.getFullPath());
                child = this.store.addChild(cur, nodeNames[i], (IConfigMNode)this.nodeFactory.createInternalMNode((IMNode)cur, nodeNames[i]));
            } else if (child.isDatabase()) {
                hasStorageGroup = true;
            }
            cur = child;
        }
        return cur;
    }

    public Pair<List<PartialPath>, Set<PartialPath>> getNodesListInGivenLevel(PartialPath pathPattern, int nodeLevel, boolean isPrefixMatch, PathPatternTree scope) throws MetadataException {
        final LinkedList result = new LinkedList();
        try (MNodeAboveDBCollector<Void, IConfigMNode> collector = new MNodeAboveDBCollector<Void, IConfigMNode>(this.root, pathPattern, (IMTreeStore)this.store, isPrefixMatch, scope){

            protected Void collectMNode(IConfigMNode node) {
                result.add(this.getPartialPathFromRootToNode((ITreeNode)node));
                return null;
            }
        };){
            collector.setTargetLevel(nodeLevel);
            collector.traverse();
            Pair pair = new Pair(result, (Object)collector.getInvolvedDatabaseMNodes());
            return pair;
        }
    }

    public Pair<Set<TSchemaNode>, Set<PartialPath>> getChildNodePathInNextLevel(PartialPath pathPattern, PathPatternTree scope) throws MetadataException {
        Pair pair;
        final TreeSet result = new TreeSet();
        MNodeAboveDBCollector<Void, IConfigMNode> collector = new MNodeAboveDBCollector<Void, IConfigMNode>(this.root, pathPattern.concatNode("*"), (IMTreeStore)this.store, false, scope){

            protected Void collectMNode(IConfigMNode node) {
                result.add(new TSchemaNode(this.getPartialPathFromRootToNode((ITreeNode)node).getFullPath(), node.getMNodeType().getNodeType()));
                return null;
            }
        };
        try {
            collector.traverse();
            pair = new Pair(result, (Object)collector.getInvolvedDatabaseMNodes());
        }
        catch (Throwable throwable) {
            try {
                try {
                    collector.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IllegalPathException e) {
                throw new IllegalPathException(pathPattern.getFullPath());
            }
        }
        collector.close();
        return pair;
    }

    public void checkTemplateOnPath(PartialPath path) throws MetadataException {
        String[] nodeNames = path.getNodes();
        IConfigMNode cur = this.root;
        if (cur.getSchemaTemplateId() != -1) {
            throw new MetadataException("Template already exists on " + cur.getFullPath());
        }
        for (int i = 1; i < nodeNames.length; ++i) {
            IConfigMNode child = (IConfigMNode)cur.getChild(nodeNames[i]);
            if (child == null) {
                return;
            }
            cur = child;
            if (cur.getSchemaTemplateId() == -1) continue;
            throw new MetadataException("Template already exists on " + cur.getFullPath());
        }
        this.checkTemplateOnSubtree(cur);
    }

    private void checkTemplateOnSubtree(IConfigMNode node) throws MetadataException {
        IMNodeIterator<IConfigMNode> iterator = this.store.getChildrenIterator(node);
        while (iterator.hasNext()) {
            IConfigMNode child = (IConfigMNode)iterator.next();
            if (child.isDatabase() && child.getDatabaseSchema().isIsTableModel()) continue;
            if (child.getSchemaTemplateId() != -1) {
                throw new MetadataException("Template already exists on " + child.getFullPath());
            }
            this.checkTemplateOnSubtree(child);
        }
    }

    public List<String> getPathsSetOnTemplate(final int templateId, PathPatternTree scope, final boolean filterPreUnset) throws MetadataException {
        final ArrayList<String> resSet = new ArrayList<String>();
        try (MNodeCollector<Void, IConfigMNode> collector = new MNodeCollector<Void, IConfigMNode>(this.root, new PartialPath(SchemaConstant.ALL_RESULT_NODES), (IMTreeStore)this.store, false, scope){

            protected boolean acceptFullMatchedNode(IConfigMNode node) {
                if (super.acceptFullMatchedNode((IMNode)node) && node.getSchemaTemplateId() != -1) {
                    if (filterPreUnset && node.isSchemaTemplatePreUnset()) {
                        return false;
                    }
                    return templateId == -2 || templateId == node.getSchemaTemplateId();
                }
                return false;
            }

            protected Void collectMNode(IConfigMNode node) {
                resSet.add(node.getFullPath());
                return null;
            }

            protected boolean shouldVisitSubtreeOfFullMatchedNode(IConfigMNode node) {
                return node.getSchemaTemplateId() == -1 && (!node.isDatabase() || !node.getDatabaseSchema().isIsTableModel()) && super.shouldVisitSubtreeOfFullMatchedNode((IMNode)node);
            }

            protected boolean shouldVisitSubtreeOfInternalMatchedNode(IConfigMNode node) {
                return node.getSchemaTemplateId() == -1 && (!node.isDatabase() || !node.getDatabaseSchema().isIsTableModel()) && super.shouldVisitSubtreeOfInternalMatchedNode((IMNode)node);
            }
        };){
            collector.traverse();
        }
        return resSet;
    }

    public Map<Integer, Set<PartialPath>> getTemplateSetInfo(PartialPath pathPattern) throws MetadataException {
        final HashMap<Integer, Set<PartialPath>> result = new HashMap<Integer, Set<PartialPath>>();
        try (MNodeCollector<Void, IConfigMNode> collector = new MNodeCollector<Void, IConfigMNode>(this.root, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            protected boolean acceptFullMatchedNode(IConfigMNode node) {
                return node.getSchemaTemplateId() != -1 || super.acceptFullMatchedNode((IMNode)node);
            }

            protected boolean acceptInternalMatchedNode(IConfigMNode node) {
                return node.getSchemaTemplateId() != -1 || super.acceptInternalMatchedNode((IMNode)node);
            }

            protected Void collectMNode(IConfigMNode node) {
                if (node.getSchemaTemplateId() != -1 && !node.isSchemaTemplatePreUnset()) {
                    result.computeIfAbsent(node.getSchemaTemplateId(), k -> new HashSet()).add(this.getPartialPathFromRootToNode((ITreeNode)node));
                }
                return null;
            }

            protected boolean shouldVisitSubtreeOfFullMatchedNode(IConfigMNode node) {
                return node.getSchemaTemplateId() == -1 && (!node.isDatabase() || !node.getDatabaseSchema().isIsTableModel()) && super.shouldVisitSubtreeOfFullMatchedNode((IMNode)node);
            }

            protected boolean shouldVisitSubtreeOfInternalMatchedNode(IConfigMNode node) {
                return node.getSchemaTemplateId() == -1 && (!node.isDatabase() || !node.getDatabaseSchema().isIsTableModel()) && super.shouldVisitSubtreeOfInternalMatchedNode((IMNode)node);
            }
        };){
            collector.traverse();
        }
        return result;
    }

    public void setTemplate(int templateId, PartialPath templateSetPath) throws MetadataException {
        this.getNodeWithAutoCreate(templateSetPath).setSchemaTemplateId(templateId);
    }

    public void preUnsetTemplate(int templateId, PartialPath path) throws MetadataException {
        this.getNodeSetTemplate(templateId, path).preUnsetSchemaTemplate();
    }

    public void rollbackUnsetTemplate(int templateId, PartialPath path) throws MetadataException {
        this.getNodeSetTemplate(templateId, path).rollbackUnsetSchemaTemplate();
    }

    public void unsetTemplate(int templateId, PartialPath path) throws MetadataException {
        this.getNodeSetTemplate(templateId, path).unsetSchemaTemplate();
    }

    private IConfigMNode getNodeSetTemplate(int templateId, PartialPath path) throws MetadataException {
        String[] nodeNames = path.getNodes();
        IConfigMNode cur = this.root;
        for (int i = 1; i < nodeNames.length; ++i) {
            if ((cur = (IConfigMNode)cur.getChild(nodeNames[i])) != null) continue;
            throw new PathNotExistException(path.getFullPath());
        }
        if (cur.getSchemaTemplateId() != templateId) {
            throw new MetadataException(String.format("Template %s is not set on path %s", templateId, path));
        }
        return cur;
    }

    public void preCreateTable(PartialPath database, TsTable table) throws MetadataException {
        IConfigMNode databaseNode = (IConfigMNode)this.getDatabaseNodeByDatabasePath(database).getAsMNode();
        IConfigMNode node = (IConfigMNode)databaseNode.getChild(table.getTableName());
        if (node != null) {
            if (node instanceof ConfigTableNode) {
                throw new TableAlreadyExistsException(database.getFullPath().substring("root".length() + 1), table.getTableName());
            }
            throw new PathAlreadyExistException(database.concatNode(table.getTableName()).getFullPath());
        }
        ConfigTableNode tableNode = (ConfigTableNode)databaseNode.addChild(table.getTableName(), new ConfigTableNode(databaseNode, table.getTableName()));
        tableNode.setTable(table);
        tableNode.setStatus(TableNodeStatus.PRE_CREATE);
    }

    public void rollbackCreateTable(PartialPath database, String tableName) throws MetadataException {
        IConfigMNode databaseNode = (IConfigMNode)this.getDatabaseNodeByDatabasePath(database).getAsMNode();
        databaseNode.deleteChild(tableName);
    }

    public void commitCreateTable(PartialPath database, String tableName) throws MetadataException {
        IConfigMNode databaseNode = (IConfigMNode)this.getDatabaseNodeByDatabasePath(database).getAsMNode();
        if (!databaseNode.hasChild(tableName)) {
            throw new TableNotExistsException(database.getFullPath().substring("root".length() + 1), tableName);
        }
        ConfigTableNode tableNode = (ConfigTableNode)databaseNode.getChild(tableName);
        if (!tableNode.getStatus().equals((Object)TableNodeStatus.PRE_CREATE)) {
            throw new IllegalStateException();
        }
        tableNode.setStatus(TableNodeStatus.USING);
    }

    public void preDeleteTable(PartialPath database, String tableName) throws MetadataException {
        IConfigMNode databaseNode = (IConfigMNode)this.getDatabaseNodeByDatabasePath(database).getAsMNode();
        if (!databaseNode.hasChild(tableName)) {
            throw new TableNotExistsException(database.getFullPath().substring("root".length() + 1), tableName);
        }
        ConfigTableNode tableNode = (ConfigTableNode)databaseNode.getChild(tableName);
        if (tableNode.getStatus().equals((Object)TableNodeStatus.PRE_CREATE)) {
            throw new IllegalStateException();
        }
        tableNode.setStatus(TableNodeStatus.PRE_DELETE);
    }

    public void dropTable(PartialPath database, String tableName) throws MetadataException {
        IConfigMNode databaseNode = (IConfigMNode)this.getDatabaseNodeByDatabasePath(database).getAsMNode();
        this.store.deleteChild(databaseNode, tableName);
    }

    public void setTableComment(PartialPath database, String tableName, String comment) throws MetadataException {
        TsTable table = this.getTable(database, tableName);
        if (Objects.nonNull(comment)) {
            table.addProp("__comment", comment);
        } else {
            table.removeProp("__comment");
        }
    }

    public void setTableColumnComment(@Nonnull PartialPath database, @Nonnull String tableName, @Nonnull String columnName, @Nullable String comment) throws MetadataException {
        TsTableColumnSchema columnSchema;
        TsTable table = this.getTable(database, tableName);
        Object object = columnSchema = !columnName.equals("time") || Objects.isNull(comment) ? table.getColumnSchema(columnName) : new TimeColumnSchema("time", TSDataType.TIMESTAMP);
        if (Objects.isNull(columnSchema)) {
            throw new ColumnNotExistsException(PathUtils.unQualifyDatabaseName((String)database.getFullPath()), tableName, columnName);
        }
        if (Objects.nonNull(comment)) {
            columnSchema.getProps().put("__comment", comment);
            if (columnName.equals("time")) {
                table.addColumnSchema(columnSchema);
            }
        } else {
            columnSchema.getProps().remove("__comment");
        }
    }

    public List<TsTable> getAllUsingTablesUnderSpecificDatabase(PartialPath databasePath) throws MetadataException {
        IConfigMNode databaseNode = (IConfigMNode)this.getDatabaseNodeByDatabasePath(databasePath).getAsMNode();
        return databaseNode.getChildren().values().stream().filter(child -> child instanceof ConfigTableNode && ((ConfigTableNode)child).getStatus().equals((Object)TableNodeStatus.USING)).map(child -> ((ConfigTableNode)child).getTable()).collect(Collectors.toList());
    }

    public List<Pair<TsTable, TableNodeStatus>> getAllTablesUnderSpecificDatabase(PartialPath databasePath) throws MetadataException {
        IConfigMNode databaseNode = (IConfigMNode)this.getDatabaseNodeByDatabasePath(databasePath).getAsMNode();
        return databaseNode.getChildren().values().stream().filter(ConfigTableNode.class::isInstance).map(child -> new Pair((Object)((ConfigTableNode)child).getTable(), (Object)((ConfigTableNode)child).getStatus())).collect(Collectors.toList());
    }

    public Map<String, TsTable> getSpecificTablesUnderSpecificDatabase(PartialPath databasePath, Set<String> tables) throws MetadataException {
        IConfigMNode databaseNode = (IConfigMNode)this.getDatabaseNodeByDatabasePath(databasePath).getAsMNode();
        HashMap<String, TsTable> result = new HashMap<String, TsTable>();
        tables.forEach(table -> {
            IConfigMNode child = (IConfigMNode)databaseNode.getChildren().get(table);
            if (child instanceof ConfigTableNode && ((ConfigTableNode)child).getStatus().equals((Object)TableNodeStatus.USING)) {
                result.put((String)table, ((ConfigTableNode)child).getTable());
            } else {
                result.put((String)table, (TsTable)null);
            }
        });
        return result;
    }

    public Map<String, List<Pair<TsTable, TableNodeStatus>>> getAllTables() {
        return this.getAllDatabasePaths(true).stream().collect(Collectors.toMap(databasePath -> PathUtils.unQualifyDatabaseName((String)databasePath.getFullPath()), databasePath -> {
            try {
                return this.getAllTablesUnderSpecificDatabase((PartialPath)databasePath);
            }
            catch (MetadataException metadataException) {
                return Collections.emptyList();
            }
        }));
    }

    public Map<String, List<TsTable>> getAllUsingTables() {
        return this.getAllDatabasePaths(true).stream().collect(Collectors.toMap(PartialPath::getFullPath, databasePath -> {
            try {
                return this.getAllUsingTablesUnderSpecificDatabase((PartialPath)databasePath);
            }
            catch (MetadataException metadataException) {
                return Collections.emptyList();
            }
        }));
    }

    public Map<String, List<TsTable>> getAllPreCreateTables() throws MetadataException {
        HashMap<String, List<TsTable>> result = new HashMap<String, List<TsTable>>();
        List<PartialPath> databaseList = this.getAllDatabasePaths(true);
        for (PartialPath databasePath : databaseList) {
            String database = databasePath.getFullPath().substring("root".length() + 1);
            IConfigMNode databaseNode = (IConfigMNode)this.getDatabaseNodeByDatabasePath(databasePath).getAsMNode();
            for (IConfigMNode child : databaseNode.getChildren().values()) {
                ConfigTableNode tableNode;
                if (!(child instanceof ConfigTableNode) || !(tableNode = (ConfigTableNode)child).getStatus().equals((Object)TableNodeStatus.PRE_CREATE)) continue;
                result.computeIfAbsent(database, k -> new ArrayList()).add(tableNode.getTable());
            }
        }
        return result;
    }

    public void addTableColumn(PartialPath database, String tableName, List<TsTableColumnSchema> columnSchemaList) throws MetadataException {
        TsTable table = this.getTable(database, tableName);
        columnSchemaList.forEach(arg_0 -> ((TsTable)table).addColumnSchema(arg_0));
    }

    public void rollbackAddTableColumn(PartialPath database, String tableName, List<TsTableColumnSchema> columnSchemaList) throws MetadataException {
        TsTable table = this.getTable(database, tableName);
        columnSchemaList.forEach(o -> table.removeColumnSchema(o.getColumnName()));
    }

    public void renameTableColumn(PartialPath database, String tableName, String oldName, String newName) throws MetadataException {
        this.getTable(database, tableName).renameColumnSchema(oldName, newName);
    }

    public void setTableProperties(PartialPath database, String tableName, Map<String, String> tableProperties) throws MetadataException {
        IConfigMNode databaseNode = (IConfigMNode)this.getDatabaseNodeByDatabasePath(database).getAsMNode();
        if (!databaseNode.hasChild(tableName)) {
            throw new TableNotExistsException(database.getFullPath().substring("root".length() + 1), tableName);
        }
        TsTable table = ((ConfigTableNode)databaseNode.getChild(tableName)).getTable();
        tableProperties.forEach((k, v) -> {
            if (Objects.nonNull(v)) {
                table.addProp(k, v);
            } else if (k.equals("ttl") && databaseNode.getDatabaseSchema().isSetTTL() && databaseNode.getDatabaseSchema().getTTL() != Long.MAX_VALUE) {
                table.addProp(k, String.valueOf(databaseNode.getDatabaseSchema().getTTL()));
            } else {
                table.removeProp(k);
            }
        });
    }

    public boolean preDeleteColumn(PartialPath database, String tableName, String columnName) throws MetadataException, SemanticException {
        ConfigTableNode node = this.getTableNode(database, tableName);
        TsTableColumnSchema columnSchema = node.getTable().getColumnSchema(columnName);
        if (Objects.isNull(columnSchema)) {
            throw new ColumnNotExistsException(PathUtils.unQualifyDatabaseName((String)database.getFullPath()), tableName, columnName);
        }
        if (columnSchema.getColumnCategory() == TsTableColumnCategory.TAG || columnSchema.getColumnCategory() == TsTableColumnCategory.TIME) {
            throw new SemanticException("Dropping tag or time column is not supported.");
        }
        node.addPreDeletedColumn(columnName);
        return columnSchema.getColumnCategory() == TsTableColumnCategory.ATTRIBUTE;
    }

    public void commitDeleteColumn(PartialPath database, String tableName, String columnName) throws MetadataException {
        ConfigTableNode node = this.getTableNode(database, tableName);
        TsTable table = this.getTable(database, tableName);
        if (Objects.nonNull(table.getColumnSchema(columnName))) {
            table.removeColumnSchema(columnName);
            node.removePreDeletedColumn(columnName);
        }
    }

    public TsTable getUsingTableSchema(PartialPath database, String tableName) throws MetadataException {
        ConfigTableNode node = this.getTableNode(database, tableName);
        if (node.getPreDeletedColumns().isEmpty()) {
            return node.getTable();
        }
        TsTable newTable = TsTable.deserialize((ByteBuffer)ByteBuffer.wrap(node.getTable().serialize()));
        node.getPreDeletedColumns().forEach(arg_0 -> ((TsTable)newTable).removeColumnSchema(arg_0));
        return newTable;
    }

    public Pair<TsTable, Set<String>> getTableSchemaDetails(PartialPath database, String tableName) throws MetadataException {
        ConfigTableNode node = this.getTableNode(database, tableName);
        return new Pair((Object)node.getTable(), node.getPreDeletedColumns());
    }

    private TsTable getTable(PartialPath database, String tableName) throws MetadataException {
        return this.getTableNode(database, tableName).getTable();
    }

    public Optional<TsTable> getTableIfExists(PartialPath database, String tableName) throws MetadataException {
        IConfigMNode databaseNode = (IConfigMNode)this.getDatabaseNodeByDatabasePath(database).getAsMNode();
        if (!databaseNode.hasChild(tableName)) {
            return Optional.empty();
        }
        ConfigTableNode tableNode = (ConfigTableNode)databaseNode.getChild(tableName);
        return Optional.of(tableNode.getTable());
    }

    private ConfigTableNode getTableNode(PartialPath database, String tableName) throws MetadataException {
        IConfigMNode databaseNode = (IConfigMNode)this.getDatabaseNodeByDatabasePath(database).getAsMNode();
        if (!databaseNode.hasChild(tableName)) {
            throw new TableNotExistsException(database.getFullPath().substring("root".length() + 1), tableName);
        }
        return (ConfigTableNode)databaseNode.getChild(tableName);
    }

    public void serialize(OutputStream outputStream) throws IOException {
        this.serializeConfigBasicMNode(this.root, outputStream);
    }

    private void serializeConfigBasicMNode(IConfigMNode node, OutputStream outputStream) throws IOException {
        this.serializeChildren(node, outputStream);
        ReadWriteIOUtils.write((byte)0, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)node.getName(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)node.getSchemaTemplateId(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)node.getChildren().size(), (OutputStream)outputStream);
    }

    private void serializeChildren(IConfigMNode node, OutputStream outputStream) throws IOException {
        for (IConfigMNode child : node.getChildren().values()) {
            if (child.isDatabase()) {
                this.serializeDatabaseNode((IDatabaseMNode<IConfigMNode>)child.getAsDatabaseMNode(), outputStream);
                continue;
            }
            if (child instanceof ConfigTableNode) {
                this.serializeTableNode((ConfigTableNode)child, outputStream);
                continue;
            }
            this.serializeConfigBasicMNode(child, outputStream);
        }
    }

    private void serializeDatabaseNode(IDatabaseMNode<IConfigMNode> storageGroupNode, OutputStream outputStream) throws IOException {
        this.serializeChildren((IConfigMNode)storageGroupNode.getAsMNode(), outputStream);
        ReadWriteIOUtils.write((byte)1, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)storageGroupNode.getName(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)((IConfigMNode)storageGroupNode.getAsMNode()).getSchemaTemplateId(), (OutputStream)outputStream);
        ThriftConfigNodeSerDeUtils.serializeTDatabaseSchema((TDatabaseSchema)((IConfigMNode)storageGroupNode.getAsMNode()).getDatabaseSchema(), (OutputStream)outputStream);
    }

    private void serializeTableNode(ConfigTableNode tableNode, OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)6, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)tableNode.getName(), (OutputStream)outputStream);
        tableNode.getTable().serialize(outputStream);
        tableNode.getStatus().serialize(outputStream);
        Set<String> preDeletedColumns = tableNode.getPreDeletedColumns();
        ReadWriteIOUtils.write((int)preDeletedColumns.size(), (OutputStream)outputStream);
        for (String column : preDeletedColumns) {
            ReadWriteIOUtils.write((String)column, (OutputStream)outputStream);
        }
    }

    public void deserialize(InputStream inputStream) throws IOException {
        IConfigMNode internalMNode;
        IConfigMNode tableNode;
        String name;
        IConfigMNode databaseMNode;
        byte type = ReadWriteIOUtils.readByte((InputStream)inputStream);
        Stack<Pair> stack = new Stack<Pair>();
        if (type == 1) {
            databaseMNode = this.deserializeDatabaseMNode(inputStream);
            name = databaseMNode.getName();
            stack.push(new Pair((Object)databaseMNode, (Object)true));
        } else if (type == 6) {
            tableNode = ConfigMTree.deserializeTableMNode(inputStream);
            name = tableNode.getName();
            stack.push(new Pair((Object)tableNode, (Object)false));
        } else {
            internalMNode = this.deserializeInternalMNode(inputStream);
            ReadWriteIOUtils.readInt((InputStream)inputStream);
            name = internalMNode.getName();
            stack.push(new Pair((Object)internalMNode, (Object)false));
        }
        block5: while (!"root".equals(name)) {
            type = ReadWriteIOUtils.readByte((InputStream)inputStream);
            switch (type) {
                case 0: {
                    internalMNode = this.deserializeInternalMNode(inputStream);
                    boolean hasDB = false;
                    for (int childNum = ReadWriteIOUtils.readInt((InputStream)inputStream); childNum > 0; --childNum) {
                        hasDB = (Boolean)((Pair)stack.peek()).right;
                        internalMNode.addChild((IConfigMNode)((Pair)stack.pop()).left);
                    }
                    stack.push(new Pair((Object)internalMNode, (Object)hasDB));
                    name = internalMNode.getName();
                    continue block5;
                }
                case 1: {
                    databaseMNode = (IConfigMNode)this.deserializeDatabaseMNode(inputStream).getAsMNode();
                    while (!stack.isEmpty() && Boolean.FALSE.equals(((Pair)stack.peek()).right)) {
                        databaseMNode.addChild((IConfigMNode)((Pair)stack.pop()).left);
                    }
                    stack.push(new Pair((Object)databaseMNode, (Object)true));
                    name = databaseMNode.getName();
                    continue block5;
                }
                case 6: {
                    tableNode = ConfigMTree.deserializeTableMNode(inputStream).getAsMNode();
                    stack.push(new Pair((Object)tableNode, (Object)false));
                    name = tableNode.getName();
                    continue block5;
                }
            }
            this.logger.error("Unrecognized node type {} when recovering the mTree.", (Object)type);
            return;
        }
        this.root = (IConfigMNode)((Pair)stack.peek()).left;
    }

    private IConfigMNode deserializeInternalMNode(InputStream inputStream) throws IOException {
        IConfigMNode basicMNode = (IConfigMNode)this.nodeFactory.createInternalMNode(null, ReadWriteIOUtils.readString((InputStream)inputStream));
        basicMNode.setSchemaTemplateId(ReadWriteIOUtils.readInt((InputStream)inputStream));
        return basicMNode;
    }

    private IConfigMNode deserializeDatabaseMNode(InputStream inputStream) throws IOException {
        IDatabaseMNode databaseMNode = this.nodeFactory.createDatabaseMNode(null, ReadWriteIOUtils.readString((InputStream)inputStream));
        ((IConfigMNode)databaseMNode.getAsMNode()).setSchemaTemplateId(ReadWriteIOUtils.readInt((InputStream)inputStream));
        ((IConfigMNode)databaseMNode.getAsMNode()).setDatabaseSchema(ThriftConfigNodeSerDeUtils.deserializeTDatabaseSchema((InputStream)inputStream));
        if (!this.isTableModel && ((IConfigMNode)databaseMNode.getAsMNode()).getDatabaseSchema().isIsTableModel()) {
            IoTDBException e = new IoTDBException(TABLE_ERROR_MSG, TSStatusCode.START_UP_ERROR.getStatusCode());
            this.logger.error(e.getMessage(), (Throwable)e);
            Runtime.getRuntime().halt(-1);
        }
        return (IConfigMNode)databaseMNode.getAsMNode();
    }

    public static ConfigTableNode deserializeTableMNode(InputStream inputStream) throws IOException {
        ConfigTableNode tableNode = new ConfigTableNode(null, ReadWriteIOUtils.readString((InputStream)inputStream));
        tableNode.setTable(TsTable.deserialize((InputStream)inputStream));
        tableNode.setStatus(TableNodeStatus.deserialize((InputStream)inputStream));
        int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < size; ++i) {
            tableNode.addPreDeletedColumn(ReadWriteIOUtils.readString((InputStream)inputStream));
        }
        return tableNode;
    }
}

