/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin.relational.tvf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.udf.builtin.relational.tvf.WindowTVFUtils;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.relational.TableFunction;
import org.apache.iotdb.udf.api.relational.access.Record;
import org.apache.iotdb.udf.api.relational.table.TableFunctionAnalysis;
import org.apache.iotdb.udf.api.relational.table.TableFunctionProcessorProvider;
import org.apache.iotdb.udf.api.relational.table.argument.Argument;
import org.apache.iotdb.udf.api.relational.table.argument.DescribedSchema;
import org.apache.iotdb.udf.api.relational.table.argument.ScalarArgument;
import org.apache.iotdb.udf.api.relational.table.argument.TableArgument;
import org.apache.iotdb.udf.api.relational.table.processor.TableFunctionDataProcessor;
import org.apache.iotdb.udf.api.relational.table.specification.ParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.ScalarParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.TableParameterSpecification;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.block.column.ColumnBuilder;

public class SessionTableFunction
implements TableFunction {
    private static final String DATA_PARAMETER_NAME = "DATA";
    private static final String TIMECOL_PARAMETER_NAME = "TIMECOL";
    private static final String GAP_PARAMETER_NAME = "GAP";

    public List<ParameterSpecification> getArgumentsSpecifications() {
        return Arrays.asList(TableParameterSpecification.builder().name(DATA_PARAMETER_NAME).passThroughColumns().build(), ScalarParameterSpecification.builder().name(TIMECOL_PARAMETER_NAME).type(Type.STRING).build(), ScalarParameterSpecification.builder().name(GAP_PARAMETER_NAME).type(Type.INT64).build());
    }

    public TableFunctionAnalysis analyze(Map<String, Argument> arguments) throws UDFException {
        TableArgument tableArgument = (TableArgument)arguments.get(DATA_PARAMETER_NAME);
        String expectedFieldName = (String)((ScalarArgument)arguments.get(TIMECOL_PARAMETER_NAME)).getValue();
        int requiredIndex = WindowTVFUtils.findColumnIndex(tableArgument, expectedFieldName, Collections.singleton(Type.TIMESTAMP));
        DescribedSchema properColumnSchema = new DescribedSchema.Builder().addField("window_start", Type.TIMESTAMP).addField("window_end", Type.TIMESTAMP).build();
        return TableFunctionAnalysis.builder().properColumnSchema(properColumnSchema).requireRecordSnapshot(false).requiredColumns(DATA_PARAMETER_NAME, Collections.singletonList(requiredIndex)).build();
    }

    public TableFunctionProcessorProvider getProcessorProvider(Map<String, Argument> arguments) {
        final long gap = (Long)((ScalarArgument)arguments.get(GAP_PARAMETER_NAME)).getValue();
        return new TableFunctionProcessorProvider(){

            public TableFunctionDataProcessor getDataProcessor() {
                return new SessionDataProcessor(gap);
            }
        };
    }

    private static class SessionDataProcessor
    implements TableFunctionDataProcessor {
        private final long gap;
        private long currentStartIndex = 0L;
        private long curIndex = 0L;
        private long windowStart = Long.MIN_VALUE;
        private long windowEnd = Long.MIN_VALUE;

        public SessionDataProcessor(long gap) {
            this.gap = gap;
        }

        public void process(Record input, List<ColumnBuilder> properColumnBuilders, ColumnBuilder passThroughIndexBuilder) {
            long timeValue = input.getLong(0);
            if (timeValue > this.windowEnd) {
                this.outputWindow(properColumnBuilders, passThroughIndexBuilder);
                this.currentStartIndex = this.curIndex;
                this.windowStart = timeValue;
            }
            this.windowEnd = timeValue + this.gap;
            ++this.curIndex;
        }

        public void finish(List<ColumnBuilder> columnBuilders, ColumnBuilder passThroughIndexBuilder) {
            this.outputWindow(columnBuilders, passThroughIndexBuilder);
        }

        private void outputWindow(List<ColumnBuilder> properColumnBuilders, ColumnBuilder passThroughIndexBuilder) {
            long currentWindowEnd = this.windowEnd - this.gap;
            for (long i = this.currentStartIndex; i < this.curIndex; ++i) {
                properColumnBuilders.get(0).writeLong(this.windowStart);
                properColumnBuilders.get(1).writeLong(currentWindowEnd);
                passThroughIndexBuilder.writeLong(i);
            }
        }
    }
}

