/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.receiver;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeConnectorCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeConnectorRetryTimesConfigurableException;
import org.apache.iotdb.commons.utils.RetryUtils;
import org.apache.iotdb.pipe.api.exception.PipeConsensusRetryWithIncreasingIntervalException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeReceiverStatusHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeReceiverStatusHandler.class);
    private static final int CONFLICT_RETRY_MAX_TIMES = 100;
    private final boolean isRetryAllowedWhenConflictOccurs;
    private final long retryMaxMillisWhenConflictOccurs;
    private final boolean shouldRecordIgnoredDataWhenConflictOccurs;
    private final long retryMaxMillisWhenOtherExceptionsOccur;
    private final boolean shouldRecordIgnoredDataWhenOtherExceptionsOccur;
    private final AtomicLong exceptionFirstEncounteredTime = new AtomicLong(0L);
    private final AtomicBoolean exceptionEventHasBeenRetried = new AtomicBoolean(false);
    private final AtomicReference<String> exceptionRecordedMessage = new AtomicReference<String>("");
    private static final List<Integer> STATUS_PRIORITY = Collections.unmodifiableList(Arrays.asList(TSStatusCode.SUCCESS_STATUS.getStatusCode(), TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode(), TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode(), TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode(), TSStatusCode.PIPE_RECEIVER_TEMPORARY_UNAVAILABLE_EXCEPTION.getStatusCode()));

    public PipeReceiverStatusHandler(boolean isRetryAllowedWhenConflictOccurs, long retryMaxSecondsWhenConflictOccurs, boolean shouldRecordIgnoredDataWhenConflictOccurs, long retryMaxSecondsWhenOtherExceptionsOccur, boolean shouldRecordIgnoredDataWhenOtherExceptionsOccur) {
        this.isRetryAllowedWhenConflictOccurs = isRetryAllowedWhenConflictOccurs;
        this.retryMaxMillisWhenConflictOccurs = retryMaxSecondsWhenConflictOccurs < 0L ? Long.MAX_VALUE : retryMaxSecondsWhenConflictOccurs * 1000L;
        this.shouldRecordIgnoredDataWhenConflictOccurs = shouldRecordIgnoredDataWhenConflictOccurs;
        this.retryMaxMillisWhenOtherExceptionsOccur = retryMaxSecondsWhenOtherExceptionsOccur < 0L ? Long.MAX_VALUE : retryMaxSecondsWhenOtherExceptionsOccur * 1000L;
        this.shouldRecordIgnoredDataWhenOtherExceptionsOccur = shouldRecordIgnoredDataWhenOtherExceptionsOccur;
    }

    public void handle(TSStatus status, String exceptionMessage, String recordMessage) {
        if (RetryUtils.needRetryForConsensus(status.getCode())) {
            LOGGER.info("IoTConsensusV2: will retry with increasing interval. status: {}", (Object)status);
            throw new PipeConsensusRetryWithIncreasingIntervalException(exceptionMessage);
        }
        switch (status.getCode()) {
            case 200: 
            case 400: {
                return;
            }
            case 1809: {
                LOGGER.info("Idempotent conflict exception: will be ignored. status: {}", (Object)status);
                return;
            }
            case 1808: {
                LOGGER.info("Temporary unavailable exception: will retry forever. status: {}", (Object)status);
                throw new PipeRuntimeConnectorCriticalException(exceptionMessage);
            }
            case 1810: {
                if (!this.isRetryAllowedWhenConflictOccurs) {
                    LOGGER.warn("User conflict exception: will be ignored because retry is not allowed. event: {}. status: {}", (Object)(this.shouldRecordIgnoredDataWhenConflictOccurs ? recordMessage : "not recorded"), (Object)status);
                    return;
                }
                PipeReceiverStatusHandler pipeReceiverStatusHandler = this;
                synchronized (pipeReceiverStatusHandler) {
                    this.recordExceptionStatusIfNecessary(recordMessage);
                    if (this.exceptionEventHasBeenRetried.get() && System.currentTimeMillis() - this.exceptionFirstEncounteredTime.get() > this.retryMaxMillisWhenConflictOccurs) {
                        LOGGER.warn("User conflict exception: retry timeout. will be ignored. event: {}. status: {}", (Object)(this.shouldRecordIgnoredDataWhenConflictOccurs ? recordMessage : "not recorded"), (Object)status);
                        this.resetExceptionStatus();
                        return;
                    }
                    LOGGER.warn("User conflict exception: will retry {}. status: {}", (Object)(this.retryMaxMillisWhenConflictOccurs == Long.MAX_VALUE ? "forever" : "for at least " + (double)(this.retryMaxMillisWhenConflictOccurs + this.exceptionFirstEncounteredTime.get() - System.currentTimeMillis()) / 1000.0 + " seconds"), (Object)status);
                    this.exceptionEventHasBeenRetried.set(true);
                    throw new PipeRuntimeConnectorRetryTimesConfigurableException(exceptionMessage, (int)Math.max(5.0, Math.min(100.0, (double)this.retryMaxMillisWhenConflictOccurs * 1.1)));
                }
            }
        }
        PipeReceiverStatusHandler pipeReceiverStatusHandler = this;
        synchronized (pipeReceiverStatusHandler) {
            this.recordExceptionStatusIfNecessary(recordMessage);
            if (this.exceptionEventHasBeenRetried.get() && System.currentTimeMillis() - this.exceptionFirstEncounteredTime.get() > this.retryMaxMillisWhenOtherExceptionsOccur) {
                LOGGER.warn("Unclassified exception: retry timeout. will be ignored. event: {}. status: {}", (Object)(this.shouldRecordIgnoredDataWhenOtherExceptionsOccur ? recordMessage : "not recorded"), (Object)status);
                this.resetExceptionStatus();
                return;
            }
            LOGGER.warn("Unclassified exception: will retry {}. status: {}", (Object)(this.retryMaxMillisWhenOtherExceptionsOccur == Long.MAX_VALUE ? "forever" : "for at least " + (double)(this.retryMaxMillisWhenOtherExceptionsOccur + this.exceptionFirstEncounteredTime.get() - System.currentTimeMillis()) / 1000.0 + " seconds"), (Object)status);
            this.exceptionEventHasBeenRetried.set(true);
            throw new PipeRuntimeConnectorRetryTimesConfigurableException(exceptionMessage, (int)Math.max(5.0, Math.min(100.0, (double)this.retryMaxMillisWhenOtherExceptionsOccur * 1.1)));
        }
    }

    private void recordExceptionStatusIfNecessary(String message) {
        if (!Objects.equals(this.exceptionRecordedMessage.get(), message)) {
            this.exceptionFirstEncounteredTime.set(System.currentTimeMillis());
            this.exceptionEventHasBeenRetried.set(false);
            this.exceptionRecordedMessage.set(message);
        }
    }

    private void resetExceptionStatus() {
        this.exceptionFirstEncounteredTime.set(0L);
        this.exceptionEventHasBeenRetried.set(false);
        this.exceptionRecordedMessage.set("");
    }

    public static TSStatus getPriorStatus(List<TSStatus> givenStatusList) {
        TSStatus resultStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        for (TSStatus givenStatus : givenStatusList) {
            if (!STATUS_PRIORITY.contains(givenStatus.getCode())) {
                return givenStatus;
            }
            if (STATUS_PRIORITY.indexOf(givenStatus.getCode()) <= STATUS_PRIORITY.indexOf(resultStatus.getCode())) continue;
            resultStatus.setCode(givenStatus.getCode());
        }
        resultStatus.setSubStatus(givenStatusList);
        return resultStatus;
    }
}

