/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.file.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.StringArrayDeviceID;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PlainDeviceID
implements IDeviceID {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(PlainDeviceID.class) + RamUsageEstimator.shallowSizeOfInstance(String.class) + RamUsageEstimator.shallowSizeOfInstance(String.class);
    private final String deviceID;
    private String tableName;
    private String[] segments;
    private static final IDeviceID.Deserializer DESERIALIZER = new IDeviceID.Deserializer(){

        @Override
        public IDeviceID deserializeFrom(ByteBuffer byteBuffer) {
            return PlainDeviceID.deserialize(byteBuffer).convertToStringArrayDeviceId();
        }

        @Override
        public IDeviceID deserializeFrom(InputStream inputStream) throws IOException {
            return PlainDeviceID.deserialize(inputStream).convertToStringArrayDeviceId();
        }
    };

    public PlainDeviceID(String deviceID) {
        this.deviceID = deviceID;
    }

    public static IDeviceID.Deserializer getDESERIALIZER() {
        return DESERIALIZER;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlainDeviceID)) {
            return false;
        }
        PlainDeviceID that = (PlainDeviceID)o;
        return Objects.equals(this.deviceID, that.deviceID);
    }

    public int hashCode() {
        return this.deviceID.hashCode();
    }

    public String toString() {
        return this.deviceID;
    }

    public String toStringID() {
        return this.toString();
    }

    @Override
    public int serialize(ByteBuffer byteBuffer) {
        return ReadWriteIOUtils.writeVar(this.deviceID, byteBuffer);
    }

    @Override
    public int serialize(OutputStream outputStream) throws IOException {
        return ReadWriteIOUtils.writeVar(this.deviceID, outputStream);
    }

    @Override
    public byte[] getBytes() {
        return this.deviceID.getBytes();
    }

    @Override
    public boolean isEmpty() {
        return this.deviceID.isEmpty();
    }

    @Override
    public boolean isTableModel() {
        return false;
    }

    public long ramBytesUsed() {
        long size = INSTANCE_SIZE;
        size += RamUsageEstimator.sizeOfCharArray((int)this.deviceID.length());
        if (this.tableName != null) {
            size += RamUsageEstimator.sizeOfCharArray((int)this.tableName.length());
        }
        if (this.segments != null) {
            size += RamUsageEstimator.sizeOf((String[])this.segments);
        }
        return size;
    }

    public static PlainDeviceID deserialize(ByteBuffer byteBuffer) {
        return new PlainDeviceID(ReadWriteIOUtils.readVarIntString(byteBuffer));
    }

    public static PlainDeviceID deserialize(InputStream inputStream) throws IOException {
        return new PlainDeviceID(ReadWriteIOUtils.readVarIntString(inputStream));
    }

    public StringArrayDeviceID convertToStringArrayDeviceId() {
        return new StringArrayDeviceID(this.deviceID);
    }

    @Override
    public int compareTo(IDeviceID other) {
        if (!(other instanceof PlainDeviceID)) {
            throw new IllegalArgumentException();
        }
        return this.deviceID.compareTo(((PlainDeviceID)other).deviceID);
    }

    @Override
    public String getTableName() {
        if (this.tableName != null) {
            return this.tableName;
        }
        int lastSeparatorPos = -1;
        int separatorNum = 0;
        for (int i = 0; i < this.deviceID.length(); ++i) {
            if (this.deviceID.charAt(i) != '.') continue;
            lastSeparatorPos = i;
            if (++separatorNum == TSFileConfig.DEFAULT_SEGMENT_NUM_FOR_TABLE_NAME) break;
        }
        this.tableName = lastSeparatorPos == -1 ? this.deviceID : this.deviceID.substring(0, lastSeparatorPos);
        return this.tableName;
    }

    @Override
    public int segmentNum() {
        if (this.segments != null) {
            return this.segments.length;
        }
        this.segments = this.deviceID.split("\\.");
        return this.segments.length;
    }

    @Override
    public String segment(int i) {
        if (i >= this.segmentNum()) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return this.segments[i];
    }

    public static class Factory
    implements IDeviceID.Factory {
        @Override
        public IDeviceID create(String deviceIdString) {
            return new PlainDeviceID(deviceIdString);
        }

        @Override
        public IDeviceID create(String[] segments) {
            return new PlainDeviceID(String.join((CharSequence)".", segments));
        }
    }
}

