/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc;

import java.io.File;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.ratis.protocol.exceptions.ServerNotReadyException;
import org.apache.ratis.protocol.exceptions.TimeoutIOException;
import org.apache.ratis.security.TlsConf;
import org.apache.ratis.thirdparty.com.google.protobuf.MessageLite;
import org.apache.ratis.thirdparty.io.grpc.ManagedChannel;
import org.apache.ratis.thirdparty.io.grpc.Metadata;
import org.apache.ratis.thirdparty.io.grpc.MethodDescriptor;
import org.apache.ratis.thirdparty.io.grpc.ServerCallHandler;
import org.apache.ratis.thirdparty.io.grpc.ServerServiceDefinition;
import org.apache.ratis.thirdparty.io.grpc.Status;
import org.apache.ratis.thirdparty.io.grpc.StatusRuntimeException;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContextBuilder;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LogUtils;
import org.apache.ratis.util.ReflectionUtils;
import org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface GrpcUtil {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcUtil.class);
    public static final Metadata.Key<String> EXCEPTION_TYPE_KEY = Metadata.Key.of((String)"exception-type", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<byte[]> EXCEPTION_OBJECT_KEY = Metadata.Key.of((String)"exception-object-bin", (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);
    public static final Metadata.Key<String> CALL_ID = Metadata.Key.of((String)"call-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> HEARTBEAT = Metadata.Key.of((String)"heartbeat", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    public static StatusRuntimeException wrapException(Throwable t) {
        t = JavaUtils.unwrapCompletionException((Throwable)t);
        Metadata trailers = new StatusRuntimeExceptionMetadataBuilder(t).build();
        return GrpcUtil.wrapException(t, trailers);
    }

    public static StatusRuntimeException wrapException(Throwable t, long callId, boolean isHeartbeat) {
        t = JavaUtils.unwrapCompletionException((Throwable)t);
        Metadata trailers = new StatusRuntimeExceptionMetadataBuilder(t).addCallId(callId).addIsHeartbeat(isHeartbeat).build();
        return GrpcUtil.wrapException(t, trailers);
    }

    public static StatusRuntimeException wrapException(Throwable t, Metadata trailers) {
        return new StatusRuntimeException(Status.INTERNAL.withCause(t).withDescription(t.getMessage()), trailers);
    }

    public static Throwable unwrapThrowable(Throwable t) {
        Throwable unwrapped;
        if (t instanceof StatusRuntimeException && (unwrapped = GrpcUtil.tryUnwrapThrowable((StatusRuntimeException)t)) != null) {
            return unwrapped;
        }
        return t;
    }

    public static IOException unwrapException(StatusRuntimeException se) {
        Throwable t = GrpcUtil.tryUnwrapThrowable(se);
        return t instanceof IOException ? (IOException)t : new IOException(t != null ? t : se);
    }

    public static Throwable tryUnwrapThrowable(StatusRuntimeException se) {
        String className;
        Status status = se.getStatus();
        if (status != null && status.getCode() == Status.Code.DEADLINE_EXCEEDED) {
            return new TimeoutIOException(status.getDescription(), (Throwable)se);
        }
        Metadata trailers = se.getTrailers();
        if (trailers == null) {
            return null;
        }
        byte[] bytes = (byte[])trailers.get(EXCEPTION_OBJECT_KEY);
        if (bytes != null) {
            try {
                return (Throwable)IOUtils.bytes2Object((byte[])bytes, Throwable.class);
            }
            catch (Exception e) {
                se.addSuppressed((Throwable)e);
            }
        }
        if (status != null && (className = (String)trailers.get(EXCEPTION_TYPE_KEY)) != null) {
            try {
                Class<Throwable> clazz = Class.forName(className).asSubclass(Throwable.class);
                Throwable unwrapped = ReflectionUtils.instantiateException(clazz, (String)status.getDescription());
                return unwrapped.initCause((Throwable)se);
            }
            catch (Throwable e) {
                se.addSuppressed(e);
                return new IOException((Throwable)se);
            }
        }
        return null;
    }

    public static long getCallId(Throwable t) {
        if (t instanceof StatusRuntimeException) {
            Metadata trailers = ((StatusRuntimeException)t).getTrailers();
            String callId = (String)trailers.get(CALL_ID);
            return callId != null ? (long)Integer.parseInt(callId) : -1L;
        }
        return -1L;
    }

    public static boolean isHeartbeat(Throwable t) {
        if (t instanceof StatusRuntimeException) {
            Metadata trailers = ((StatusRuntimeException)t).getTrailers();
            String isHeartbeat = trailers != null ? (String)trailers.get(HEARTBEAT) : null;
            return isHeartbeat != null && Boolean.valueOf(isHeartbeat) != false;
        }
        return false;
    }

    public static IOException unwrapIOException(Throwable t) {
        IOException e = t instanceof StatusRuntimeException ? GrpcUtil.unwrapException((StatusRuntimeException)t) : IOUtils.asIOException((Throwable)t);
        return e;
    }

    public static <REPLY, REPLY_PROTO> void asyncCall(StreamObserver<REPLY_PROTO> responseObserver, CheckedSupplier<CompletableFuture<REPLY>, IOException> supplier, Function<REPLY, REPLY_PROTO> toProto, Consumer<Throwable> warning) {
        try {
            ((CompletableFuture)supplier.get()).whenComplete((reply, exception) -> {
                if (exception != null) {
                    warning.accept((Throwable)exception);
                    responseObserver.onError((Throwable)GrpcUtil.wrapException(exception));
                } else {
                    responseObserver.onNext(toProto.apply(reply));
                    responseObserver.onCompleted();
                }
            });
        }
        catch (Exception e) {
            warning.accept(e);
            responseObserver.onError((Throwable)GrpcUtil.wrapException(e));
        }
    }

    public static void warn(Logger log, Supplier<String> message, Throwable t) {
        LogUtils.warn((Logger)log, message, (Throwable)GrpcUtil.unwrapThrowable(t), (Class[])new Class[]{StatusRuntimeException.class, ServerNotReadyException.class});
    }

    public static void shutdownManagedChannel(ManagedChannel managedChannel) {
        if (!managedChannel.isShutdown()) {
            try {
                managedChannel.shutdown();
                if (!managedChannel.awaitTermination(3L, TimeUnit.SECONDS)) {
                    LOG.warn("Timed out gracefully shutting down connection: {}. ", (Object)managedChannel);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOG.error("Unexpected exception while waiting for channel termination", (Throwable)e);
            }
        }
        if (!managedChannel.isTerminated()) {
            try {
                managedChannel.shutdownNow();
                if (!managedChannel.awaitTermination(2L, TimeUnit.SECONDS)) {
                    LOG.warn("Timed out forcefully shutting down connection: {}. ", (Object)managedChannel);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOG.error("Unexpected exception while waiting for channel termination", (Throwable)e);
            }
        }
    }

    public static SslContextBuilder initSslContextBuilderForServer(TlsConf.KeyManagerConf keyManagerConfig) {
        KeyManager keyManager = keyManagerConfig.getKeyManager();
        if (keyManager != null) {
            return SslContextBuilder.forServer((KeyManager)keyManager);
        }
        TlsConf.PrivateKeyConf privateKey = keyManagerConfig.getPrivateKey();
        TlsConf.CertificatesConf certificates = keyManagerConfig.getKeyCertificates();
        if (keyManagerConfig.isFileBased()) {
            return SslContextBuilder.forServer((File)certificates.getFile(), (File)privateKey.getFile());
        }
        return SslContextBuilder.forServer((PrivateKey)((PrivateKey)privateKey.get()), (Iterable)((Iterable)certificates.get()));
    }

    public static void setTrustManager(SslContextBuilder b, TlsConf.TrustManagerConf trustManagerConfig) {
        if (trustManagerConfig == null) {
            return;
        }
        TrustManager trustManager = trustManagerConfig.getTrustManager();
        if (trustManager != null) {
            b.trustManager(trustManager);
            return;
        }
        TlsConf.CertificatesConf certificates = trustManagerConfig.getTrustCertificates();
        if (certificates.isFileBased()) {
            b.trustManager(certificates.getFile());
        } else {
            b.trustManager((Iterable)certificates.get());
        }
    }

    public static void setKeyManager(SslContextBuilder b, TlsConf.KeyManagerConf keyManagerConfig) {
        if (keyManagerConfig == null) {
            return;
        }
        KeyManager keyManager = keyManagerConfig.getKeyManager();
        if (keyManager != null) {
            b.keyManager(keyManager);
            return;
        }
        TlsConf.PrivateKeyConf privateKey = keyManagerConfig.getPrivateKey();
        TlsConf.CertificatesConf certificates = keyManagerConfig.getKeyCertificates();
        if (keyManagerConfig.isFileBased()) {
            b.keyManager(certificates.getFile(), privateKey.getFile());
        } else {
            b.keyManager((PrivateKey)privateKey.get(), (Iterable)certificates.get());
        }
    }

    public static <Req extends MessageLite, Resp> void addMethodWithCustomMarshaller(ServerServiceDefinition orig, ServerServiceDefinition.Builder newServiceBuilder, MethodDescriptor<Req, Resp> origMethod, MethodDescriptor.PrototypeMarshaller<Req> customMarshaller) {
        MethodDescriptor newMethod = origMethod.toBuilder().setRequestMarshaller(customMarshaller).build();
        ServerCallHandler serverCallHandler = orig.getMethod(newMethod.getFullMethodName()).getServerCallHandler();
        newServiceBuilder.addMethod(newMethod, serverCallHandler);
    }

    public static class StatusRuntimeExceptionMetadataBuilder {
        private Metadata trailers = new Metadata();

        StatusRuntimeExceptionMetadataBuilder(Throwable t) {
            this.trailers.put(EXCEPTION_TYPE_KEY, (Object)t.getClass().getCanonicalName());
            this.trailers.put(EXCEPTION_OBJECT_KEY, (Object)IOUtils.object2Bytes((Object)t));
        }

        StatusRuntimeExceptionMetadataBuilder addCallId(long callId) {
            if (callId > 0L) {
                this.trailers.put(CALL_ID, (Object)String.valueOf(callId));
            }
            return this;
        }

        StatusRuntimeExceptionMetadataBuilder addIsHeartbeat(boolean isHeartbeat) {
            this.trailers.put(HEARTBEAT, (Object)String.valueOf(isHeartbeat));
            return this;
        }

        Metadata build() {
            return this.trailers;
        }
    }
}

