/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.extractor;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MetaProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.auth.AccessDeniedException;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBTreePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.commons.pipe.datastructure.queue.ConcurrentIterableLinkedQueue;
import org.apache.iotdb.commons.pipe.datastructure.queue.listening.AbstractPipeListeningQueue;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.PipeSnapshotEvent;
import org.apache.iotdb.commons.pipe.event.PipeWritePlanEvent;
import org.apache.iotdb.commons.pipe.event.ProgressReportEvent;
import org.apache.iotdb.commons.pipe.extractor.IoTDBExtractor;
import org.apache.iotdb.pipe.api.annotation.TableModel;
import org.apache.iotdb.pipe.api.annotation.TreeModel;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.utils.Pair;

@TreeModel
@TableModel
public abstract class IoTDBNonDataRegionExtractor
extends IoTDBExtractor {
    protected IoTDBTreePattern treePattern;
    protected TablePattern tablePattern;
    private List<PipeSnapshotEvent> historicalEvents = new LinkedList<PipeSnapshotEvent>();
    private int historicalEventsCount = 0;
    private ConcurrentIterableLinkedQueue.DynamicIterator iterator;
    protected final AtomicBoolean hasBeenClosed = new AtomicBoolean(false);

    protected abstract AbstractPipeListeningQueue getListeningQueue();

    @Override
    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
        super.customize(parameters, configuration);
        TreePattern pattern = TreePattern.parsePipePatternFromSourceParameters(parameters);
        if (!(pattern instanceof IoTDBTreePattern) || !((IoTDBTreePattern)pattern).isPrefix() && !((IoTDBTreePattern)pattern).isFullPath()) {
            throw new IllegalArgumentException(String.format("The path pattern %s is not valid for the source. Only prefix or full path is allowed.", pattern.getPattern()));
        }
        this.treePattern = (IoTDBTreePattern)pattern;
        this.tablePattern = TablePattern.parsePipePatternFromSourceParameters(parameters);
    }

    @Override
    public void start() throws Exception {
        if (this.hasBeenStarted.get() || this.hasBeenClosed.get()) {
            return;
        }
        ProgressIndex progressIndex = this.pipeTaskMeta.getProgressIndex();
        long nextIndex = progressIndex instanceof MinimumProgressIndex || !this.getListeningQueue().isGivenNextIndexValid(((MetaProgressIndex)progressIndex).getIndex() + 1L) ? this.getNextIndexAfterSnapshot() : ((MetaProgressIndex)progressIndex).getIndex() + 1L;
        this.iterator = this.getListeningQueue().newIterator(nextIndex);
        super.start();
    }

    private long getNextIndexAfterSnapshot() {
        long nextIndex;
        if (this.needTransferSnapshot()) {
            nextIndex = this.findSnapshot();
            if (nextIndex == Long.MIN_VALUE) {
                this.triggerSnapshot();
                nextIndex = this.findSnapshot();
                if (nextIndex == Long.MIN_VALUE) {
                    throw new PipeException("Cannot get the newest snapshot after triggering one.");
                }
            }
        } else {
            nextIndex = Long.MAX_VALUE;
        }
        return nextIndex;
    }

    private long findSnapshot() {
        Pair<Long, List<PipeSnapshotEvent>> queueTailIndex2Snapshots = this.getListeningQueue().findAvailableSnapshots();
        long nextIndex = Objects.nonNull(queueTailIndex2Snapshots.getLeft()) && (Long)queueTailIndex2Snapshots.getLeft() != Long.MIN_VALUE ? (Long)queueTailIndex2Snapshots.getLeft() : Long.MIN_VALUE;
        this.historicalEvents = new LinkedList<PipeSnapshotEvent>((Collection)queueTailIndex2Snapshots.getRight());
        this.historicalEventsCount = this.historicalEvents.size();
        return nextIndex;
    }

    protected abstract boolean needTransferSnapshot();

    protected abstract void triggerSnapshot();

    public EnrichedEvent supply() throws Exception {
        boolean shouldBindIndex;
        if (this.hasBeenClosed.get()) {
            return null;
        }
        if (!this.hasBeenStarted.get()) {
            this.start();
            if (!this.hasBeenStarted.get()) {
                return null;
            }
        }
        PipeWritePlanEvent realtimeEvent = null;
        if (this.hasNextEventInCurrentSnapshot()) {
            realtimeEvent = this.getNextEventInCurrentSnapshot();
        }
        while (Objects.isNull(realtimeEvent) && !this.historicalEvents.isEmpty()) {
            PipeSnapshotEvent historicalEvent = (PipeSnapshotEvent)this.historicalEvents.remove(0).shallowCopySelfAndBindPipeTaskMetaForProgressReport(this.pipeName, this.creationTime, this.pipeTaskMeta, this.treePattern, this.tablePattern, this.userName, this.skipIfNoPrivileges, Long.MIN_VALUE, Long.MAX_VALUE);
            if (this.canSkipSnapshotPrivilegeCheck(historicalEvent)) {
                if (this.historicalEvents.isEmpty()) {
                    historicalEvent.bindProgressIndex(new MetaProgressIndex(this.iterator.getNextIndex() - 1L));
                }
                historicalEvent.increaseReferenceCount(IoTDBNonDataRegionExtractor.class.getName());
                this.confineHistoricalEventTransferTypes(historicalEvent);
                return historicalEvent;
            }
            this.initSnapshotGenerator(historicalEvent);
            if (!this.hasNextEventInCurrentSnapshot()) continue;
            realtimeEvent = this.getNextEventInCurrentSnapshot();
        }
        boolean bl = shouldBindIndex = this.historicalEvents.isEmpty() && !this.hasNextEventInCurrentSnapshot();
        if (Objects.isNull(realtimeEvent)) {
            realtimeEvent = (PipeWritePlanEvent)this.iterator.peek(this.getMaxBlockingTimeMs());
        }
        if (Objects.isNull(realtimeEvent)) {
            return null;
        }
        realtimeEvent = this.trimRealtimeEventByPipePattern(realtimeEvent).flatMap(this::trimRealtimeEventByPrivilege).orElse(null);
        this.iterator.next(0L);
        if (Objects.isNull(realtimeEvent) || !this.isTypeListened(realtimeEvent) || !this.isForwardingPipeRequests && realtimeEvent.isGeneratedByPipe()) {
            ProgressReportEvent event = new ProgressReportEvent(this.pipeName, this.creationTime, this.pipeTaskMeta, this.treePattern, this.tablePattern, this.userName, this.skipIfNoPrivileges, Long.MIN_VALUE, Long.MAX_VALUE);
            if (shouldBindIndex) {
                event.bindProgressIndex(new MetaProgressIndex(this.iterator.getNextIndex() - 1L));
            }
            event.increaseReferenceCount(IoTDBNonDataRegionExtractor.class.getName());
            return event;
        }
        realtimeEvent = (PipeWritePlanEvent)realtimeEvent.shallowCopySelfAndBindPipeTaskMetaForProgressReport(this.pipeName, this.creationTime, this.pipeTaskMeta, this.treePattern, this.tablePattern, this.userName, this.skipIfNoPrivileges, Long.MIN_VALUE, Long.MAX_VALUE);
        if (shouldBindIndex) {
            realtimeEvent.bindProgressIndex(new MetaProgressIndex(this.iterator.getNextIndex() - 1L));
        }
        realtimeEvent.increaseReferenceCount(IoTDBNonDataRegionExtractor.class.getName());
        return realtimeEvent;
    }

    protected abstract long getMaxBlockingTimeMs();

    protected abstract boolean canSkipSnapshotPrivilegeCheck(PipeSnapshotEvent var1);

    protected abstract void initSnapshotGenerator(PipeSnapshotEvent var1) throws IOException, IllegalPathException;

    protected abstract boolean hasNextEventInCurrentSnapshot();

    protected abstract PipeWritePlanEvent getNextEventInCurrentSnapshot();

    protected abstract Optional<PipeWritePlanEvent> trimRealtimeEventByPrivilege(PipeWritePlanEvent var1) throws AccessDeniedException;

    protected abstract Optional<PipeWritePlanEvent> trimRealtimeEventByPipePattern(PipeWritePlanEvent var1);

    protected abstract boolean isTypeListened(PipeWritePlanEvent var1);

    protected abstract void confineHistoricalEventTransferTypes(PipeSnapshotEvent var1);

    public void close() throws Exception {
        this.getListeningQueue().returnIterator(this.iterator);
        this.historicalEvents.clear();
    }

    public long getUnTransferredEventCount() {
        return !(this.pipeTaskMeta.getProgressIndex() instanceof MinimumProgressIndex) ? this.getListeningQueue().getTailIndex() - ((MetaProgressIndex)this.pipeTaskMeta.getProgressIndex()).getIndex() - 1L : this.getListeningQueue().getSize() + (long)this.historicalEventsCount;
    }
}

