/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.DeviceTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TreeNonAlignedDeviceViewScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TreeDeviceViewScanNode
extends DeviceTableScanNode {
    protected String treeDBName;
    protected Map<String, String> measurementColumnNameMap;

    public TreeDeviceViewScanNode(PlanNodeId id, QualifiedObjectName qualifiedObjectName, List<Symbol> outputSymbols, Map<Symbol, ColumnSchema> assignments, Map<Symbol, Integer> idAndAttributeIndexMap, String treeDBName, Map<String, String> measurementColumnNameMap) {
        super(id, qualifiedObjectName, outputSymbols, assignments, idAndAttributeIndexMap);
        this.treeDBName = treeDBName;
        this.measurementColumnNameMap = measurementColumnNameMap;
    }

    public TreeDeviceViewScanNode(PlanNodeId id, QualifiedObjectName qualifiedObjectName, List<Symbol> outputSymbols, Map<Symbol, ColumnSchema> assignments, List<DeviceEntry> deviceEntries, Map<Symbol, Integer> idAndAttributeIndexMap, Ordering scanOrder, Expression timePredicate, Expression pushDownPredicate, long pushDownLimit, long pushDownOffset, boolean pushLimitToEachDevice, boolean containsNonAlignedDevice, String treeDBName, Map<String, String> measurementColumnNameMap) {
        super(id, qualifiedObjectName, outputSymbols, assignments, deviceEntries, idAndAttributeIndexMap, scanOrder, timePredicate, pushDownPredicate, pushDownLimit, pushDownOffset, pushLimitToEachDevice, containsNonAlignedDevice);
        this.treeDBName = treeDBName;
        this.measurementColumnNameMap = measurementColumnNameMap;
    }

    public TreeDeviceViewScanNode() {
    }

    public String getTreeDBName() {
        return this.treeDBName;
    }

    public Map<String, String> getMeasurementColumnNameMap() {
        return this.measurementColumnNameMap;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTreeDeviceViewScan(this, context);
    }

    @Override
    public TreeDeviceViewScanNode clone() {
        return new TreeDeviceViewScanNode(this.getPlanNodeId(), this.qualifiedObjectName, this.outputSymbols, this.assignments, this.deviceEntries, this.idAndAttributeIndexMap, this.scanOrder, this.timePredicate, this.pushDownPredicate, this.pushDownLimit, this.pushDownOffset, this.pushLimitToEachDevice, this.containsNonAlignedDevice, this.treeDBName, this.measurementColumnNameMap);
    }

    protected static void serializeMemberVariables(TreeDeviceViewScanNode node, ByteBuffer byteBuffer) {
        DeviceTableScanNode.serializeMemberVariables((DeviceTableScanNode)node, byteBuffer, true);
        ReadWriteIOUtils.write((String)node.treeDBName, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)node.measurementColumnNameMap.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry<String, String> entry : node.measurementColumnNameMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((String)entry.getValue(), (ByteBuffer)byteBuffer);
        }
    }

    protected static void serializeMemberVariables(TreeDeviceViewScanNode node, DataOutputStream stream) throws IOException {
        DeviceTableScanNode.serializeMemberVariables((DeviceTableScanNode)node, stream, true);
        ReadWriteIOUtils.write((String)node.treeDBName, (OutputStream)stream);
        ReadWriteIOUtils.write((int)node.measurementColumnNameMap.size(), (OutputStream)stream);
        for (Map.Entry<String, String> entry : node.measurementColumnNameMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)stream);
            ReadWriteIOUtils.write((String)entry.getValue(), (OutputStream)stream);
        }
    }

    protected static void deserializeMemberVariables(ByteBuffer byteBuffer, TreeDeviceViewScanNode node) {
        DeviceTableScanNode.deserializeMemberVariables(byteBuffer, node, true);
        node.treeDBName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashMap<String, String> measurementColumnNameMap = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            measurementColumnNameMap.put(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        node.measurementColumnNameMap = measurementColumnNameMap;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException("Unsupported to serialize: " + TreeNonAlignedDeviceViewScanNode.class.getSimpleName());
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        throw new UnsupportedOperationException("Unsupported to serialize: " + TreeNonAlignedDeviceViewScanNode.class.getSimpleName());
    }

    public static DeviceTableScanNode deserialize(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException("Unsupported to deserialize: " + TreeNonAlignedDeviceViewScanNode.class.getSimpleName());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TreeDeviceViewScanNode that = (TreeDeviceViewScanNode)o;
        return Objects.equals(this.treeDBName, that.treeDBName) && Objects.equals(this.measurementColumnNameMap, that.measurementColumnNameMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.treeDBName, this.measurementColumnNameMap);
    }

    @Override
    public String toString() {
        return "TreeDeviceViewScanNode-" + this.getPlanNodeId();
    }
}

