/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class DeviceTableScanNode
extends TableScanNode {
    protected List<DeviceEntry> deviceEntries;
    protected Map<Symbol, Integer> idAndAttributeIndexMap;
    protected Ordering scanOrder = Ordering.ASC;
    @Nullable
    protected Expression timePredicate;
    protected transient Filter timeFilter;
    protected boolean pushLimitToEachDevice = false;
    protected transient boolean containsNonAlignedDevice;

    protected DeviceTableScanNode() {
    }

    public DeviceTableScanNode(PlanNodeId id, QualifiedObjectName qualifiedObjectName, List<Symbol> outputSymbols, Map<Symbol, ColumnSchema> assignments, Map<Symbol, Integer> idAndAttributeIndexMap) {
        super(id, qualifiedObjectName, outputSymbols, assignments);
        this.idAndAttributeIndexMap = idAndAttributeIndexMap;
    }

    public DeviceTableScanNode(PlanNodeId id, QualifiedObjectName qualifiedObjectName, List<Symbol> outputSymbols, Map<Symbol, ColumnSchema> assignments, List<DeviceEntry> deviceEntries, Map<Symbol, Integer> idAndAttributeIndexMap, Ordering scanOrder, Expression timePredicate, Expression pushDownPredicate, long pushDownLimit, long pushDownOffset, boolean pushLimitToEachDevice, boolean containsNonAlignedDevice) {
        super(id, qualifiedObjectName, outputSymbols, assignments, pushDownPredicate, pushDownLimit, pushDownOffset);
        this.deviceEntries = deviceEntries;
        this.idAndAttributeIndexMap = idAndAttributeIndexMap;
        this.scanOrder = scanOrder;
        this.timePredicate = timePredicate;
        this.pushDownPredicate = pushDownPredicate;
        this.pushLimitToEachDevice = pushLimitToEachDevice;
        this.containsNonAlignedDevice = containsNonAlignedDevice;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitDeviceTableScan(this, context);
    }

    @Override
    public DeviceTableScanNode clone() {
        return new DeviceTableScanNode(this.getPlanNodeId(), this.qualifiedObjectName, this.outputSymbols, this.assignments, this.deviceEntries, this.idAndAttributeIndexMap, this.scanOrder, this.timePredicate, this.pushDownPredicate, this.pushDownLimit, this.pushDownOffset, this.pushLimitToEachDevice, this.containsNonAlignedDevice);
    }

    protected static void serializeMemberVariables(DeviceTableScanNode node, ByteBuffer byteBuffer, boolean serializeOutputSymbols) {
        TableScanNode.serializeMemberVariables((TableScanNode)node, byteBuffer, serializeOutputSymbols);
        ReadWriteIOUtils.write((int)node.deviceEntries.size(), (ByteBuffer)byteBuffer);
        for (DeviceEntry deviceEntry : node.deviceEntries) {
            deviceEntry.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((int)node.idAndAttributeIndexMap.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry entry : node.idAndAttributeIndexMap.entrySet()) {
            Symbol.serialize((Symbol)entry.getKey(), byteBuffer);
            ReadWriteIOUtils.write((int)((Integer)entry.getValue()), (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((int)node.scanOrder.ordinal(), (ByteBuffer)byteBuffer);
        if (node.timePredicate != null) {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)byteBuffer);
            Expression.serialize(node.timePredicate, byteBuffer);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)node.pushLimitToEachDevice, (ByteBuffer)byteBuffer);
    }

    protected static void serializeMemberVariables(DeviceTableScanNode node, DataOutputStream stream, boolean serializeOutputSymbols) throws IOException {
        TableScanNode.serializeMemberVariables((TableScanNode)node, stream, serializeOutputSymbols);
        ReadWriteIOUtils.write((int)node.deviceEntries.size(), (OutputStream)stream);
        for (DeviceEntry deviceEntry : node.deviceEntries) {
            deviceEntry.serialize(stream);
        }
        ReadWriteIOUtils.write((int)node.idAndAttributeIndexMap.size(), (OutputStream)stream);
        for (Map.Entry entry : node.idAndAttributeIndexMap.entrySet()) {
            Symbol.serialize((Symbol)entry.getKey(), stream);
            ReadWriteIOUtils.write((int)((Integer)entry.getValue()), (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)node.scanOrder.ordinal(), (OutputStream)stream);
        if (node.timePredicate != null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            Expression.serialize(node.timePredicate, stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((Boolean)node.pushLimitToEachDevice, (OutputStream)stream);
    }

    protected static void deserializeMemberVariables(ByteBuffer byteBuffer, DeviceTableScanNode node, boolean deserializeOutputSymbols) {
        TableScanNode.deserializeMemberVariables(byteBuffer, node, deserializeOutputSymbols);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<DeviceEntry> deviceEntries = new ArrayList<DeviceEntry>(size);
        while (size-- > 0) {
            deviceEntries.add(DeviceEntry.deserialize(byteBuffer));
        }
        node.deviceEntries = deviceEntries;
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashMap<Symbol, Integer> idAndAttributeIndexMap = new HashMap<Symbol, Integer>(size);
        while (size-- > 0) {
            idAndAttributeIndexMap.put(Symbol.deserialize(byteBuffer), ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer));
        }
        node.idAndAttributeIndexMap = idAndAttributeIndexMap;
        node.scanOrder = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        boolean hasTimePredicate = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        if (hasTimePredicate) {
            node.timePredicate = Expression.deserialize(byteBuffer);
        }
        node.pushLimitToEachDevice = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.DEVICE_TABLE_SCAN_NODE.serialize(byteBuffer);
        DeviceTableScanNode.serializeMemberVariables(this, byteBuffer, true);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.DEVICE_TABLE_SCAN_NODE.serialize(stream);
        DeviceTableScanNode.serializeMemberVariables(this, stream, true);
    }

    public static DeviceTableScanNode deserialize(ByteBuffer byteBuffer) {
        DeviceTableScanNode node = new DeviceTableScanNode();
        DeviceTableScanNode.deserializeMemberVariables(byteBuffer, node, true);
        node.setPlanNodeId(PlanNodeId.deserialize(byteBuffer));
        return node;
    }

    public void setDeviceEntries(List<DeviceEntry> deviceEntries) {
        this.deviceEntries = deviceEntries;
    }

    public Map<Symbol, Integer> getIdAndAttributeIndexMap() {
        return this.idAndAttributeIndexMap;
    }

    public void setScanOrder(Ordering scanOrder) {
        this.scanOrder = scanOrder;
    }

    public Ordering getScanOrder() {
        return this.scanOrder;
    }

    public List<DeviceEntry> getDeviceEntries() {
        return this.deviceEntries;
    }

    public void appendDeviceEntry(DeviceEntry deviceEntry) {
        this.deviceEntries.add(deviceEntry);
    }

    public void setPushLimitToEachDevice(boolean pushLimitToEachDevice) {
        this.pushLimitToEachDevice = pushLimitToEachDevice;
    }

    public boolean isPushLimitToEachDevice() {
        return this.pushLimitToEachDevice;
    }

    public Optional<Expression> getTimePredicate() {
        return Optional.ofNullable(this.timePredicate);
    }

    public void setTimePredicate(@Nullable Expression timePredicate) {
        this.timePredicate = timePredicate;
    }

    public Filter getTimeFilter() {
        return this.timeFilter;
    }

    public void setTimeFilter(Filter timeFilter) {
        this.timeFilter = timeFilter;
    }

    public boolean containsNonAlignedDevice() {
        return this.containsNonAlignedDevice;
    }

    public void setContainsNonAlignedDevice() {
        this.containsNonAlignedDevice = true;
    }

    @Override
    public String toString() {
        return "DeviceTableScanNode-" + this.getPlanNodeId();
    }
}

