/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolsExtractor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.Util;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class PruneJoinChildrenColumns
implements Rule<JoinNode> {
    private static final Pattern<JoinNode> PATTERN = Patterns.join();

    @Override
    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
        ImmutableSet globallyUsableInputs = ImmutableSet.builder().addAll(joinNode.getOutputSymbols()).addAll((Iterable)joinNode.getFilter().map(SymbolsExtractor::extractUnique).orElse((Set)ImmutableSet.of())).build();
        ImmutableSet leftUsableInputs = ImmutableSet.builder().addAll((Iterable)globallyUsableInputs).addAll(joinNode.getCriteria().stream().map(JoinNode.EquiJoinClause::getLeft).iterator()).build();
        ImmutableSet rightUsableInputs = ImmutableSet.builder().addAll((Iterable)globallyUsableInputs).addAll(joinNode.getCriteria().stream().map(JoinNode.EquiJoinClause::getRight).iterator()).build();
        return Util.restrictChildOutputs(context.getIdAllocator(), joinNode, new Set[]{leftUsableInputs, rightUsableInputs}).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }
}

