/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.ResolvedField;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Scope;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlannerContext;
import org.apache.iotdb.db.queryengine.plan.relational.planner.QueryPlanner;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ScopeAware;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.ExpressionRewriter;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.ExpressionTreeRewriter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DereferenceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FieldReference;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GenericDataType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LikePredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Parameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Trim;
import org.apache.iotdb.db.queryengine.plan.relational.sql.util.AstUtil;

public class TranslationMap {
    private final Scope scope;
    private final Analysis analysis;
    private final Optional<TranslationMap> outerContext;
    private final PlannerContext plannerContext;
    private final Symbol[] fieldSymbols;
    private final Map<ScopeAware<Expression>, Symbol> astToSymbols;
    private final Map<NodeRef<Expression>, Symbol> substitutions;

    public TranslationMap(Optional<TranslationMap> outerContext, Scope scope, Analysis analysis, List<Symbol> fieldSymbols, PlannerContext plannerContext) {
        this(outerContext, scope, analysis, (Symbol[])fieldSymbols.toArray(new Symbol[0]).clone(), (Map<ScopeAware<Expression>, Symbol>)ImmutableMap.of(), (Map<NodeRef<Expression>, Symbol>)ImmutableMap.of(), plannerContext);
    }

    public TranslationMap(Optional<TranslationMap> outerContext, Scope scope, Analysis analysis, List<Symbol> fieldSymbols, Map<ScopeAware<Expression>, Symbol> astToSymbols, PlannerContext plannerContext) {
        this(outerContext, scope, analysis, fieldSymbols.toArray(new Symbol[0]), astToSymbols, (Map<NodeRef<Expression>, Symbol>)ImmutableMap.of(), plannerContext);
    }

    public TranslationMap(Optional<TranslationMap> outerContext, Scope scope, Analysis analysis, Symbol[] fieldSymbols, Map<ScopeAware<Expression>, Symbol> astToSymbols, Map<NodeRef<Expression>, Symbol> substitutions, PlannerContext plannerContext) {
        this.outerContext = Objects.requireNonNull(outerContext, "outerContext is null");
        this.scope = Objects.requireNonNull(scope, "scope is null");
        this.analysis = Objects.requireNonNull(analysis, "analysis is null");
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.substitutions = ImmutableMap.copyOf(substitutions);
        Objects.requireNonNull(fieldSymbols, "fieldSymbols is null");
        this.fieldSymbols = (Symbol[])fieldSymbols.clone();
        Objects.requireNonNull(astToSymbols, "astToSymbols is null");
        this.astToSymbols = ImmutableMap.copyOf(astToSymbols);
        astToSymbols.keySet().stream().map(ScopeAware::getNode).forEach(TranslationMap::verifyAstExpression);
    }

    public TranslationMap withScope(Scope scope, List<Symbol> fields) {
        return new TranslationMap(this.outerContext, scope, this.analysis, fields.toArray(new Symbol[0]), this.astToSymbols, this.substitutions, this.plannerContext);
    }

    public TranslationMap withNewMappings(Map<ScopeAware<Expression>, Symbol> mappings, List<Symbol> fields) {
        return new TranslationMap(this.outerContext, this.scope, this.analysis, fields, mappings, this.plannerContext);
    }

    public TranslationMap withAdditionalMappings(Map<ScopeAware<Expression>, Symbol> mappings) {
        HashMap<ScopeAware<Expression>, Symbol> newMappings = new HashMap<ScopeAware<Expression>, Symbol>();
        newMappings.putAll(this.astToSymbols);
        newMappings.putAll(mappings);
        return new TranslationMap(this.outerContext, this.scope, this.analysis, this.fieldSymbols, newMappings, this.substitutions, this.plannerContext);
    }

    public TranslationMap withAdditionalIdentityMappings(Map<NodeRef<Expression>, Symbol> mappings) {
        HashMap<NodeRef<Expression>, Symbol> newMappings = new HashMap<NodeRef<Expression>, Symbol>();
        newMappings.putAll(this.substitutions);
        newMappings.putAll(mappings);
        return new TranslationMap(this.outerContext, this.scope, this.analysis, this.fieldSymbols, this.astToSymbols, newMappings, this.plannerContext);
    }

    public List<Symbol> getFieldSymbolsList() {
        return Collections.unmodifiableList(Arrays.asList(this.fieldSymbols));
    }

    public Symbol[] getFieldSymbols() {
        return this.fieldSymbols;
    }

    public Map<ScopeAware<Expression>, Symbol> getMappings() {
        return this.astToSymbols;
    }

    public Analysis getAnalysis() {
        return this.analysis;
    }

    public boolean canTranslate(Expression expression) {
        TranslationMap.verifyAstExpression(expression);
        if (this.astToSymbols.containsKey(ScopeAware.scopeAwareKey(expression, this.analysis, this.scope)) || this.substitutions.containsKey(NodeRef.of(expression)) || expression instanceof FieldReference) {
            return true;
        }
        if (this.analysis.isColumnReference(expression)) {
            ResolvedField field = this.analysis.getColumnReferenceFields().get(NodeRef.of(expression));
            return this.scope.isLocalScope(field.getScope());
        }
        return false;
    }

    public Expression rewrite(final Expression expression) {
        TranslationMap.verifyAstExpression(expression);
        Verify.verify((boolean)this.analysis.isAnalyzed(expression), (String)"Expression is not analyzed (%s): %s", (Object)expression.getClass().getName(), (Object)expression);
        return ExpressionTreeRewriter.rewriteWith(new ExpressionRewriter<Void>(){

            @Override
            protected Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping(node);
                if (mapped.isPresent()) {
                    return mapped.get();
                }
                return treeRewriter.defaultRewrite(node, context);
            }

            @Override
            public Expression rewriteFieldReference(FieldReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping(node);
                return mapped.orElseGet(() -> TranslationMap.this.getSymbolForColumn(node).map(Symbol::toSymbolReference).orElseThrow(() -> new IllegalStateException(String.format("No symbol mapping for node '%s' (%s)", node, node.getFieldIndex()))));
            }

            @Override
            public Expression rewriteIdentifier(Identifier node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping(node);
                if (mapped.isPresent()) {
                    return mapped.get();
                }
                return TranslationMap.this.getSymbolForColumn(node).map(symbol -> symbol.toSymbolReference()).orElseGet(() -> node);
            }

            @Override
            public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping(node);
                if (mapped.isPresent()) {
                    return mapped.get();
                }
                List<Expression> newArguments = node.getArguments().stream().map(TranslationMap.this::rewrite).collect(Collectors.toList());
                return new FunctionCall(node.getName(), node.isDistinct(), newArguments);
            }

            @Override
            public Expression rewriteTrim(Trim node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping(node);
                if (mapped.isPresent()) {
                    return mapped.get();
                }
                ArrayList<Expression> newArguments = new ArrayList<Expression>();
                newArguments.add(TranslationMap.this.rewrite(node.getTrimSource()));
                node.getTrimCharacter().ifPresent(argument -> newArguments.add(TranslationMap.this.rewrite((Expression)argument)));
                return new FunctionCall(QualifiedName.of(node.getSpecification().getFunctionName()), newArguments);
            }

            @Override
            public Expression rewriteDereferenceExpression(DereferenceExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping(node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary(node, mapped.get());
                }
                if (TranslationMap.this.analysis.isColumnReference(node)) {
                    return this.coerceIfNecessary(node, TranslationMap.this.getSymbolForColumn(node).map(Symbol::toSymbolReference).orElseThrow(() -> new IllegalStateException(String.format("No mapping for %s", node))));
                }
                throw new IllegalStateException("Subscript is not supported in current version");
            }

            private Expression coerceIfNecessary(Expression original, Expression rewritten) {
                if (original == expression) {
                    return rewritten;
                }
                return QueryPlanner.coerceIfNecessary(TranslationMap.this.analysis, original, rewritten);
            }

            @Override
            public Expression rewriteLikePredicate(LikePredicate node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping(node);
                if (mapped.isPresent()) {
                    return mapped.get();
                }
                Expression value = treeRewriter.rewrite(node.getValue(), context);
                Expression pattern = treeRewriter.rewrite(node.getPattern(), context);
                Optional<Expression> escape = node.getEscape().map(e -> treeRewriter.rewrite(e, context));
                return escape.isPresent() ? new LikePredicate(value, pattern, escape.get()) : new LikePredicate(value, pattern, null);
            }

            @Override
            public Expression rewriteParameter(Parameter node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping(node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary(node, mapped.get());
                }
                Preconditions.checkState((TranslationMap.this.analysis.getParameters().size() > node.getId() ? 1 : 0) != 0, (Object)"Too few parameter values");
                return this.coerceIfNecessary(node, treeRewriter.rewrite(TranslationMap.this.analysis.getParameters().get(NodeRef.of(node)), null));
            }

            @Override
            public Expression rewriteGenericDataType(GenericDataType node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return node;
            }
        }, expression);
    }

    public Optional<SymbolReference> tryGetMapping(Expression expression) {
        Symbol symbol = this.substitutions.get(NodeRef.of(expression));
        if (symbol == null) {
            symbol = this.astToSymbols.get(ScopeAware.scopeAwareKey(expression, this.analysis, this.scope));
        }
        return Optional.ofNullable(symbol).map(Symbol::toSymbolReference);
    }

    public Optional<Symbol> getSymbolForColumn(Expression expression) {
        if (!this.analysis.isColumnReference(expression)) {
            return Optional.empty();
        }
        ResolvedField field = this.analysis.getColumnReferenceFields().get(NodeRef.of(expression));
        if (this.scope.isLocalScope(field.getScope())) {
            return Optional.of(this.fieldSymbols[field.getHierarchyFieldIndex()]);
        }
        if (this.outerContext.isPresent()) {
            return Optional.of(Symbol.from(this.outerContext.get().rewrite(expression)));
        }
        return Optional.empty();
    }

    private static void verifyAstExpression(Expression astExpression) {
        Verify.verify((boolean)AstUtil.preOrder(astExpression).noneMatch(SymbolReference.class::isInstance), (String)"symbol references are not allowed", (Object[])new Object[0]);
    }

    public Scope getScope() {
        return this.scope;
    }
}

