/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.AbstractTableTask;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class DescribeTableDetailsTask
extends AbstractTableTask {
    public DescribeTableDetailsTask(String database, String tableName) {
        super(database, tableName);
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.describeTable(this.database, this.tableName, true);
    }

    public static void buildTsBlock(TsTable table, Set<String> preDeletedColumns, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.describeTableDetailsColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        for (TsTableColumnSchema columnSchema : table.getColumnList()) {
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(new Binary(columnSchema.getColumnName(), TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(1).writeBinary(new Binary(columnSchema.getDataType().name(), TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(2).writeBinary(new Binary(columnSchema.getColumnCategory().name(), TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(3).writeBinary(new Binary(preDeletedColumns.contains(columnSchema.getColumnName()) ? "PRE_DELETE" : "USING", TSFileConfig.STRING_CHARSET));
            if (columnSchema.getProps().containsKey("__comment")) {
                builder.getColumnBuilder(4).writeBinary(new Binary((String)columnSchema.getProps().get("__comment"), TSFileConfig.STRING_CHARSET));
            } else {
                builder.getColumnBuilder(4).appendNull();
            }
            builder.declarePosition();
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getDescribeTableDetailsHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

