/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.batch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.batch.PipeTransferBatchReqBuilder;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBDataRegionAsyncConnector;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALPipeException;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeTabletEventBatch
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTabletEventBatch.class);
    protected final List<EnrichedEvent> events = new ArrayList<EnrichedEvent>();
    private final int maxDelayInMs;
    private long firstEventProcessingTime = Long.MIN_VALUE;
    protected long totalBufferSize = 0L;
    private final PipeMemoryBlock allocatedMemoryBlock;
    protected volatile boolean isClosed = false;

    protected PipeTabletEventBatch(int maxDelayInMs, long requestMaxBatchSizeInBytes) {
        this.maxDelayInMs = maxDelayInMs;
        this.allocatedMemoryBlock = PipeDataNodeResourceManager.memory().tryAllocate(requestMaxBatchSizeInBytes).setShrinkMethod(oldMemory -> Math.max(oldMemory / 2L, 0L)).setShrinkCallback((oldMemory, newMemory) -> LOGGER.info("The batch size limit has shrunk from {} to {}.", oldMemory, newMemory)).setExpandMethod(oldMemory -> Math.min(Math.max(oldMemory, 1L) * 2L, requestMaxBatchSizeInBytes)).setExpandCallback((oldMemory, newMemory) -> LOGGER.info("The batch size limit has expanded from {} to {}.", oldMemory, newMemory));
        if (this.getMaxBatchSizeInBytes() != requestMaxBatchSizeInBytes) {
            LOGGER.info("PipeTabletEventBatch: the max batch size is adjusted from {} to {} due to the memory restriction", (Object)requestMaxBatchSizeInBytes, (Object)this.getMaxBatchSizeInBytes());
        }
    }

    public synchronized boolean onEvent(TabletInsertionEvent event) throws WALPipeException, IOException {
        if (this.isClosed || !(event instanceof EnrichedEvent)) {
            return false;
        }
        if (this.events.isEmpty() || !Objects.equals(this.events.get(this.events.size() - 1), event)) {
            if (((EnrichedEvent)event).increaseReferenceCount(PipeTransferBatchReqBuilder.class.getName())) {
                try {
                    if (this.constructBatch(event)) {
                        this.events.add((EnrichedEvent)event);
                    }
                }
                catch (Exception e) {
                    ((EnrichedEvent)event).decreaseReferenceCount(PipeTransferBatchReqBuilder.class.getName(), false);
                    throw e;
                }
                if (this.firstEventProcessingTime == Long.MIN_VALUE) {
                    this.firstEventProcessingTime = System.currentTimeMillis();
                }
            } else {
                LOGGER.warn("Cannot increase reference count for event: {}, ignore it in batch.", (Object)event);
            }
        }
        return this.shouldEmit();
    }

    protected abstract boolean constructBatch(TabletInsertionEvent var1) throws WALPipeException, IOException;

    public boolean shouldEmit() {
        return this.totalBufferSize >= this.getMaxBatchSizeInBytes() || System.currentTimeMillis() - this.firstEventProcessingTime >= (long)this.maxDelayInMs;
    }

    private long getMaxBatchSizeInBytes() {
        return this.allocatedMemoryBlock.getMemoryUsageInBytes();
    }

    public synchronized void onSuccess() {
        this.events.clear();
        this.totalBufferSize = 0L;
        this.firstEventProcessingTime = Long.MIN_VALUE;
    }

    @Override
    public synchronized void close() {
        this.isClosed = true;
        this.clearEventsReferenceCount(PipeTabletEventBatch.class.getName());
        this.events.clear();
        if (this.allocatedMemoryBlock != null) {
            this.allocatedMemoryBlock.close();
        }
    }

    public synchronized void discardEventsOfPipe(String pipeNameToDrop, int regionId) {
        this.events.removeIf(event -> {
            if (pipeNameToDrop.equals(event.getPipeName()) && regionId == event.getRegionId()) {
                event.clearReferenceCount(IoTDBDataRegionAsyncConnector.class.getName());
                return true;
            }
            return false;
        });
    }

    public synchronized void decreaseEventsReferenceCount(String holderMessage, boolean shouldReport) {
        this.events.forEach(event -> event.decreaseReferenceCount(holderMessage, shouldReport));
    }

    private void clearEventsReferenceCount(String holderMessage) {
        this.events.forEach(event -> event.clearReferenceCount(holderMessage));
    }

    public List<EnrichedEvent> deepCopyEvents() {
        return new ArrayList<EnrichedEvent>(this.events);
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }
}

