/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ratis.util.ReferenceCountedLeakDetector;
import org.apache.ratis.util.function.UncheckedAutoCloseableSupplier;

public interface ReferenceCountedObject<T> {
    public T get();

    public T retain();

    default public UncheckedAutoCloseableSupplier<T> retainAndReleaseOnClose() {
        final T retained = this.retain();
        final AtomicBoolean closed = new AtomicBoolean();
        return new UncheckedAutoCloseableSupplier<T>(){

            @Override
            public T get() {
                if (closed.get()) {
                    throw new IllegalStateException("Already closed");
                }
                return retained;
            }

            @Override
            public void close() {
                if (closed.compareAndSet(false, true)) {
                    ReferenceCountedObject.this.release();
                }
            }
        };
    }

    public boolean release();

    public static <V> ReferenceCountedObject<V> wrap(V value) {
        return ReferenceCountedObject.wrap(value, () -> {}, (Boolean ignored) -> {});
    }

    public static <T, V> ReferenceCountedObject<V> delegateFrom(final Collection<ReferenceCountedObject<T>> fromRefs, final V value) {
        return new ReferenceCountedObject<V>(){

            @Override
            public V get() {
                return value;
            }

            @Override
            public V retain() {
                fromRefs.forEach(ReferenceCountedObject::retain);
                return value;
            }

            @Override
            public boolean release() {
                boolean allReleased = true;
                for (ReferenceCountedObject ref : fromRefs) {
                    if (ref.release()) continue;
                    allReleased = false;
                }
                return allReleased;
            }
        };
    }

    default public <V> ReferenceCountedObject<V> delegate(final V value) {
        final ReferenceCountedObject delegated = this;
        return new ReferenceCountedObject<V>(){

            @Override
            public V get() {
                return value;
            }

            @Override
            public V retain() {
                delegated.retain();
                return value;
            }

            @Override
            public boolean release() {
                return delegated.release();
            }
        };
    }

    default public <V> ReferenceCountedObject<V> apply(Function<T, V> function) {
        return this.delegate(function.apply(this.get()));
    }

    public static <V> ReferenceCountedObject<V> wrap(V value, Runnable retainMethod, Consumer<Boolean> releaseMethod) {
        Objects.requireNonNull(value, "value == null");
        Objects.requireNonNull(retainMethod, "retainMethod == null");
        Objects.requireNonNull(releaseMethod, "releaseMethod == null");
        return ReferenceCountedLeakDetector.getFactory().create(value, retainMethod, releaseMethod);
    }

    public static <V> ReferenceCountedObject<V> wrap(V value, Runnable retainMethod, Runnable releaseMethod) {
        return ReferenceCountedObject.wrap(value, retainMethod, (Boolean ignored) -> releaseMethod.run());
    }
}

