/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.block.column;

import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.BooleanColumn;
import org.apache.tsfile.read.common.block.column.DoubleColumn;
import org.apache.tsfile.read.common.block.column.FloatColumn;
import org.apache.tsfile.read.common.block.column.IntColumn;
import org.apache.tsfile.read.common.block.column.LongColumn;

public class ColumnFactory {
    public static Column create(TSDataType dataType, int initialCapacity) {
        switch (dataType) {
            case INT64: 
            case TIMESTAMP: {
                return new LongColumn(initialCapacity);
            }
            case DOUBLE: {
                return new DoubleColumn(initialCapacity);
            }
            case FLOAT: {
                return new FloatColumn(initialCapacity);
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                return new BinaryColumn(initialCapacity);
            }
            case INT32: 
            case DATE: {
                return new IntColumn(initialCapacity);
            }
            case BOOLEAN: {
                return new BooleanColumn(initialCapacity);
            }
        }
        throw new IllegalArgumentException("Unsupported data type: " + dataType);
    }
}

