/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.EncryptUtils;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.reader.IPageReader;
import org.apache.tsfile.read.reader.chunk.ChunkReader;
import org.apache.tsfile.read.reader.chunk.TableChunkReader;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.tsfile.write.chunk.ValueChunkWriter;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class Chunk {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(Chunk.class) + ChunkHeader.INSTANCE_SIZE + RamUsageEstimator.shallowSizeOfInstance(ByteBuffer.class);
    private final ChunkHeader chunkHeader;
    private ByteBuffer chunkData;
    private Statistics chunkStatistic;
    private EncryptParameter encryptParam;
    private List<TimeRange> deleteIntervalList;

    public Chunk(ChunkHeader header, ByteBuffer buffer, List<TimeRange> deleteIntervalList, Statistics chunkStatistic) {
        this.chunkHeader = header;
        this.chunkData = buffer;
        this.deleteIntervalList = deleteIntervalList;
        this.chunkStatistic = chunkStatistic;
        this.encryptParam = EncryptUtils.getEncryptParameter();
    }

    public Chunk(ChunkHeader header, ByteBuffer buffer, List<TimeRange> deleteIntervalList, Statistics chunkStatistic, EncryptParameter encryptParam) {
        this.chunkHeader = header;
        this.chunkData = buffer;
        this.deleteIntervalList = deleteIntervalList;
        this.chunkStatistic = chunkStatistic;
        this.encryptParam = encryptParam;
    }

    public Chunk(ChunkHeader header, ByteBuffer buffer) {
        this.chunkHeader = header;
        this.chunkData = buffer;
        this.encryptParam = EncryptUtils.getEncryptParameter();
    }

    public Chunk(ChunkHeader header, ByteBuffer buffer, EncryptParameter encryptParam) {
        this.chunkHeader = header;
        this.chunkData = buffer;
        this.encryptParam = encryptParam;
    }

    public EncryptParameter getEncryptParam() {
        return this.encryptParam;
    }

    public ChunkHeader getHeader() {
        return this.chunkHeader;
    }

    public ByteBuffer getData() {
        return this.chunkData;
    }

    public List<TimeRange> getDeleteIntervalList() {
        return this.deleteIntervalList;
    }

    public void setDeleteIntervalList(List<TimeRange> list) {
        this.deleteIntervalList = list;
    }

    public void mergeChunkByAppendPage(Chunk chunk) throws IOException {
        PublicBAOS a;
        byte[] b;
        int dataSize = 0;
        int offset1 = -1;
        if ((byte)(chunk.chunkHeader.getChunkType() & 0x3F) == 5) {
            ReadWriteForEncodingUtils.readUnsignedVarInt(chunk.chunkData);
            ReadWriteForEncodingUtils.readUnsignedVarInt(chunk.chunkData);
            offset1 = chunk.chunkData.position();
            chunk.chunkData.flip();
            dataSize += chunk.chunkData.array().length + chunk.chunkStatistic.getSerializedSize();
        } else {
            dataSize += chunk.chunkData.array().length;
        }
        int offset2 = -1;
        if ((byte)(this.chunkHeader.getChunkType() & 0x3F) == 5) {
            this.chunkHeader.setChunkType((byte)1);
            ReadWriteForEncodingUtils.readUnsignedVarInt(this.chunkData);
            ReadWriteForEncodingUtils.readUnsignedVarInt(this.chunkData);
            offset2 = this.chunkData.position();
            this.chunkData.flip();
            dataSize += this.chunkData.array().length + this.chunkStatistic.getSerializedSize();
        } else {
            dataSize += this.chunkData.array().length;
        }
        this.chunkHeader.setDataSize(dataSize);
        ByteBuffer newChunkData = ByteBuffer.allocate(dataSize);
        if (offset2 == -1) {
            newChunkData.put(this.chunkData.array());
        } else {
            b = this.chunkData.array();
            newChunkData.put(b, 0, offset2);
            a = new PublicBAOS();
            this.chunkStatistic.serialize(a);
            newChunkData.put(a.getBuf(), 0, a.size());
            newChunkData.put(b, offset2, b.length - offset2);
        }
        if (offset1 == -1) {
            newChunkData.put(chunk.chunkData.array());
        } else {
            b = chunk.chunkData.array();
            newChunkData.put(b, 0, offset1);
            a = new PublicBAOS();
            chunk.chunkStatistic.serialize(a);
            newChunkData.put(a.getBuf(), 0, a.size());
            newChunkData.put(b, offset1, b.length - offset1);
        }
        this.chunkData = newChunkData;
    }

    public Statistics getChunkStatistic() {
        return this.chunkStatistic;
    }

    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE + RamUsageEstimator.sizeOfByteArray((int)this.chunkData.capacity());
    }

    public Chunk rewrite(TSDataType newType, Chunk timeChunk) throws IOException {
        if (newType == null || newType == this.chunkHeader.getDataType()) {
            return this;
        }
        TSEncoding encoding = TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getValueEncoder(newType));
        MeasurementSchema schema = new MeasurementSchema(this.chunkHeader.getMeasurementID(), newType, encoding, this.chunkHeader.getCompressionType());
        ValueChunkWriter chunkWriter = new ValueChunkWriter(this.chunkHeader.getMeasurementID(), this.chunkHeader.getCompressionType(), newType, encoding, schema.getValueEncoder(), this.encryptParam);
        ArrayList<Chunk> valueChunks = new ArrayList<Chunk>();
        valueChunks.add(this);
        TableChunkReader chunkReader = new TableChunkReader(timeChunk, valueChunks, null);
        List<IPageReader> pages = chunkReader.loadPageReaderList();
        for (IPageReader page : pages) {
            BatchData.BatchDataIterator pointReader = page.getAllSatisfiedPageData().getBatchDataIterator();
            block9: while (pointReader.hasNextTimeValuePair()) {
                TimeValuePair point = pointReader.nextTimeValuePair();
                Object convertedValue = null;
                if (point.getValue().getVector()[0] != null) {
                    convertedValue = newType.castFromSingleValue(this.chunkHeader.getDataType(), point.getValue().getVector()[0].getValue());
                }
                long timestamp = point.getTimestamp();
                switch (newType) {
                    case BOOLEAN: {
                        chunkWriter.write(timestamp, convertedValue == null ? true : (Boolean)convertedValue, convertedValue == null);
                        continue block9;
                    }
                    case DATE: 
                    case INT32: {
                        chunkWriter.write(timestamp, convertedValue == null ? Integer.MAX_VALUE : (Integer)convertedValue, convertedValue == null);
                        continue block9;
                    }
                    case TIMESTAMP: 
                    case INT64: {
                        chunkWriter.write(timestamp, convertedValue == null ? Integer.MAX_VALUE : (Long)convertedValue, convertedValue == null);
                        continue block9;
                    }
                    case FLOAT: {
                        chunkWriter.write(timestamp, convertedValue == null ? 2.1474836E9f : ((Float)convertedValue).floatValue(), convertedValue == null);
                        continue block9;
                    }
                    case DOUBLE: {
                        chunkWriter.write(timestamp, convertedValue == null ? 2.147483647E9 : (Double)convertedValue, convertedValue == null);
                        continue block9;
                    }
                    case TEXT: 
                    case STRING: 
                    case BLOB: {
                        chunkWriter.write(timestamp, convertedValue == null ? Binary.EMPTY_VALUE : (Binary)convertedValue, convertedValue == null);
                        continue block9;
                    }
                }
                throw new IOException("Unsupported data type: " + newType);
            }
            chunkWriter.sealCurrentPage();
        }
        ByteBuffer newChunkData = chunkWriter.getByteBuffer();
        ChunkHeader newChunkHeader = new ChunkHeader(this.chunkHeader.getChunkType(), this.chunkHeader.getMeasurementID(), newChunkData.capacity(), newType, this.chunkHeader.getCompressionType(), encoding);
        this.chunkData.flip();
        timeChunk.chunkData.flip();
        return new Chunk(newChunkHeader, newChunkData, this.deleteIntervalList, chunkWriter.getStatistics(), this.encryptParam);
    }

    public Chunk rewrite(TSDataType newType) throws IOException {
        if (newType == null || newType == this.chunkHeader.getDataType()) {
            return this;
        }
        TSEncoding encoding = TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getValueEncoder(newType));
        MeasurementSchema schema = new MeasurementSchema(this.chunkHeader.getMeasurementID(), newType, encoding, this.chunkHeader.getCompressionType());
        ChunkWriterImpl chunkWriter = new ChunkWriterImpl((IMeasurementSchema)schema, this.encryptParam);
        ChunkReader chunkReader = new ChunkReader(this);
        List<IPageReader> pages = chunkReader.loadPageReaderList();
        for (IPageReader page : pages) {
            BatchData batchData = page.getAllSatisfiedPageData();
            BatchData.BatchDataIterator pointReader = batchData.getBatchDataIterator();
            block9: while (pointReader.hasNextTimeValuePair()) {
                TimeValuePair point = pointReader.nextTimeValuePair();
                Object convertedValue = newType.castFromSingleValue(this.chunkHeader.getDataType(), point.getValue().getValue());
                long timestamp = point.getTimestamp();
                if (convertedValue == null) {
                    throw new IOException("NonAlignedChunk contains null, timestamp: " + timestamp);
                }
                switch (newType) {
                    case BOOLEAN: {
                        chunkWriter.write(timestamp, (Boolean)convertedValue);
                        continue block9;
                    }
                    case DATE: 
                    case INT32: {
                        chunkWriter.write(timestamp, (Integer)convertedValue);
                        continue block9;
                    }
                    case TIMESTAMP: 
                    case INT64: {
                        chunkWriter.write(timestamp, (Long)convertedValue);
                        continue block9;
                    }
                    case FLOAT: {
                        chunkWriter.write(timestamp, ((Float)convertedValue).floatValue());
                        continue block9;
                    }
                    case DOUBLE: {
                        chunkWriter.write(timestamp, (Double)convertedValue);
                        continue block9;
                    }
                    case TEXT: 
                    case STRING: 
                    case BLOB: {
                        chunkWriter.write(timestamp, (Binary)convertedValue);
                        continue block9;
                    }
                }
                throw new IOException("Unsupported data type: " + newType);
            }
            chunkWriter.sealCurrentPage();
        }
        ByteBuffer newChunkData = chunkWriter.getByteBuffer();
        ChunkHeader newChunkHeader = new ChunkHeader(this.chunkHeader.getChunkType(), this.chunkHeader.getMeasurementID(), newChunkData.capacity(), newType, this.chunkHeader.getCompressionType(), encoding);
        this.chunkData.flip();
        return new Chunk(newChunkHeader, newChunkData, this.deleteIntervalList, chunkWriter.getStatistics(), this.encryptParam);
    }
}

